/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.entities.controls;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.tardis.mod.common.entities.controls.IControl;
import net.tardis.mod.common.sounds.TSounds;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.config.TardisConfig;

public abstract class EntityControl
extends Entity
implements IControl {
    public static final DataParameter<BlockPos> CONSOLE_POS = EntityDataManager.func_187226_a(EntityControl.class, (DataSerializer)DataSerializers.field_187200_j);
    public static final DataParameter<Boolean> IS_GLOWING = EntityDataManager.func_187226_a(EntityControl.class, (DataSerializer)DataSerializers.field_187198_h);
    public static SoundEvent[] rand_sounds = new SoundEvent[]{TSounds.control_generic_01};
    public int ticks = 0;
    public int direction = 1;
    public AxisAlignedBB box = null;

    public EntityControl(World worldIn) {
        super(worldIn);
    }

    public EntityControl(TileEntityTardis tardis) {
        super(tardis.func_145831_w());
        this.field_70180_af.func_187227_b(CONSOLE_POS, (Object)tardis.func_174877_v().func_185334_h());
    }

    public BlockPos getConsolePos() {
        return (BlockPos)this.field_70180_af.func_187225_a(CONSOLE_POS);
    }

    public void setConsolePos(BlockPos pos) {
        this.field_70180_af.func_187227_b(CONSOLE_POS, (Object)pos.func_185334_h());
    }

    public boolean getGlowing() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_GLOWING);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CONSOLE_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(IS_GLOWING, (Object)false);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        TileEntityTardis tardis = (TileEntityTardis)this.field_70170_p.func_175625_s(this.getConsolePos());
        if (!tardis.isInFlight()) {
            this.preformAction(player);
        } else if (tardis.getCourseCorrect() != TileEntityTardis.EnumCourseCorrect.NONE && this.getClass() == tardis.getCourseCorrect().getControl()) {
            tardis.setCourseEvent(TileEntityTardis.EnumCourseCorrect.NONE);
        } else {
            this.preformAction(player);
        }
        this.field_70170_p.func_184148_a(null, (double)this.func_180425_c().func_177958_n(), (double)this.func_180425_c().func_177956_o(), (double)this.func_180425_c().func_177952_p(), this.getUseSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_70075_an() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    @Override
    public abstract Vec3d getOffset(TileEntityTardis var1);

    public boolean func_184202_aL() {
        return false;
    }

    public void func_184195_f(boolean glow) {
        this.field_70180_af.func_187227_b(IS_GLOWING, (Object)glow);
    }

    public abstract void preformAction(EntityPlayer var1);

    public NBTTagCompound func_189511_e(NBTTagCompound tag) {
        return super.func_189511_e(tag);
    }

    public void func_70020_e(NBTTagCompound tag) {
        super.func_70020_e(tag);
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public void func_70071_h_() {
        if (this.field_70148_d) {
            this.init((TileEntityTardis)this.field_70170_p.func_175625_s(this.getConsolePos()));
        }
        super.func_70071_h_();
        if (this.ticks > 0) {
            --this.ticks;
        }
        if (!this.field_70170_p.field_72995_K && (this.getConsolePos() == null || this.getConsolePos().equals((Object)BlockPos.field_177992_a))) {
            this.func_70106_y();
        }
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public boolean func_98034_c(EntityPlayer player) {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityPlayer) {
            this.func_184230_a((EntityPlayer)source.func_76346_g(), EnumHand.MAIN_HAND);
        }
        return true;
    }

    @Override
    public String getControlName() {
        return this.func_145748_c_().func_150260_c();
    }

    public void func_174812_G() {
        if (TardisConfig.MISC.killControlsOnKillCommand) {
            super.func_174812_G();
        }
    }

    @Override
    public SoundEvent getUseSound() {
        return rand_sounds[this.field_70146_Z.nextInt(rand_sounds.length)];
    }

    public void init(TileEntityTardis tardis) {
    }
}

