/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.entities.controls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tardis.mod.client.worldshell.BlockStorage;
import net.tardis.mod.client.worldshell.IContainsWorldShell;
import net.tardis.mod.client.worldshell.WorldBoti;
import net.tardis.mod.client.worldshell.WorldShell;
import net.tardis.mod.common.IDoor;
import net.tardis.mod.common.blocks.BlockTardisTop;
import net.tardis.mod.common.entities.IShouldDie;
import net.tardis.mod.common.items.TItems;
import net.tardis.mod.common.serializers.TDataSerializers;
import net.tardis.mod.common.sounds.TSounds;
import net.tardis.mod.common.tileentity.TileEntityDoor;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.config.TardisConfig;
import net.tardis.mod.network.NetworkHandler;
import net.tardis.mod.network.packets.MessageRequestBOTI;
import net.tardis.mod.util.common.helpers.Helper;
import net.tardis.mod.util.common.helpers.TardisHelper;

public class ControlDoor
extends Entity
implements IContainsWorldShell,
IDoor,
IShouldDie {
    public static final DataParameter<Boolean> IS_OPEN = EntityDataManager.func_187226_a(ControlDoor.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Float> FACING = EntityDataManager.func_187226_a(ControlDoor.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Boolean> UPDATE = EntityDataManager.func_187226_a(ControlDoor.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Vec3d> MOTION = EntityDataManager.func_187226_a(ControlDoor.class, TDataSerializers.VEC3D);
    public boolean updateServerSide = false;
    public int antiSpamTicks = 0;
    private WorldShell shell = new WorldShell(BlockPos.field_177992_a);
    private World clientWorld;
    AxisAlignedBB BOTI = Block.field_185505_j.func_186662_g(20.0);

    public ControlDoor(World world) {
        super(world);
        this.func_70105_a(1.0f, 2.0f);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(IS_OPEN, (Object)((Boolean)this.field_70180_af.func_187225_a(IS_OPEN) == false ? 1 : 0));
            boolean open = (Boolean)this.field_70180_af.func_187225_a(IS_OPEN);
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), open ? TSounds.door_open : TSounds.door_closed, SoundCategory.AMBIENT, 1.0f, 1.0f);
            this.setOtherDoors(open);
            this.setBotiUpdate(true);
        } else {
            this.syncWorldShell();
        }
        return true;
    }

    public void setOtherDoors(boolean open) {
        if (!this.field_70170_p.field_72995_K) {
            TileEntityTardis tardis = this.getTardis();
            if (tardis == null) {
                return;
            }
            WorldServer ws = this.field_70170_p.func_73046_m().func_71218_a(tardis.dimension);
            TileEntityDoor door = (TileEntityDoor)ws.func_175625_s(tardis.getLocation().func_177984_a());
            if (door != null) {
                door.setLocked(!open);
            }
        }
    }

    public float getFacing() {
        TileEntityTardis tardis;
        if (!this.field_70170_p.field_72995_K && (tardis = this.getTardis()) != null) {
            if (tardis.getTardisEntity() != null) {
                return tardis.getTardisEntity().field_70177_z;
            }
            WorldServer ws = this.field_70170_p.func_73046_m().func_71218_a(tardis.dimension);
            IBlockState state = ws.func_180495_p(tardis.getLocation().func_177984_a());
            if (state.func_177230_c() instanceof BlockTardisTop) {
                return Helper.getAngleFromFacing((EnumFacing)state.func_177229_b((IProperty)BlockTardisTop.FACING));
            }
        }
        return ((Float)this.field_70180_af.func_187225_a(FACING)).floatValue();
    }

    public TileEntityTardis getTardis() {
        TileEntity te = this.field_70170_p.func_175625_s(TardisHelper.getTardisForPosition((Vec3i)this.func_180425_c()));
        return te instanceof TileEntityTardis ? (TileEntityTardis)te : null;
    }

    public void updateWorldShell() {
        this.updateServerSide = false;
        if (!this.field_70170_p.field_72995_K) {
            TileEntityTardis tardis = this.getTardis();
            if (tardis == null) {
                return;
            }
            WorldServer ws = this.field_70170_p.func_73046_m().func_71218_a(tardis.dimension);
            if (ws == null) {
                return;
            }
            IBlockState state = ws.func_180495_p(tardis.getLocation().func_177984_a());
            if (!(state.func_177230_c() instanceof BlockTardisTop)) {
                return;
            }
            BlockPos offset = tardis.getLocation().func_177984_a().func_177967_a((EnumFacing)state.func_177229_b((IProperty)BlockTardisTop.FACING), 20);
            AxisAlignedBB bb = this.BOTI;
            if (!this.shell.getOffset().equals((Object)offset)) {
                this.shell = new WorldShell(offset);
            }
            this.shell.blockMap = this.getBlockStoreInAABB(bb, offset, ws);
            this.shell.setEntities(this.getShellEntities(ws, bb.func_186670_a(offset)));
            this.field_70180_af.func_187227_b(FACING, (Object)Float.valueOf(this.getFacing()));
            this.shell.setTime(ws.func_72820_D());
        }
    }

    public List<NBTTagCompound> getShellEntities(WorldServer other, AxisAlignedBB bb) {
        ArrayList<NBTTagCompound> entities = new ArrayList<NBTTagCompound>();
        for (Entity ent : other.func_72872_a(Entity.class, bb)) {
            if (EntityList.func_191301_a((Entity)ent) == null) continue;
            NBTTagCompound tag = ent.serializeNBT();
            tag.func_74778_a("id", EntityList.func_191301_a((Entity)ent).toString());
            entities.add(tag);
        }
        return entities;
    }

    public Map<BlockPos, BlockStorage> getBlockStoreInAABB(AxisAlignedBB bb, BlockPos pos, WorldServer ws) {
        HashMap<BlockPos, BlockStorage> map = new HashMap<BlockPos, BlockStorage>();
        int x = (int)bb.field_72340_a;
        while ((double)x < bb.field_72336_d) {
            int y = (int)bb.field_72338_b;
            while ((double)y < bb.field_72337_e) {
                int z = (int)bb.field_72339_c;
                while ((double)z < bb.field_72334_f) {
                    BlockPos bp = new BlockPos(x, y, z).func_177971_a((Vec3i)pos);
                    IBlockState state = ws.func_180495_p(bp);
                    if (!(state.func_177230_c() instanceof BlockTardisTop) && state.func_185904_a() != Material.field_151579_a) {
                        int light = MathHelper.func_76125_a((int)(Helper.getLight((World)ws, bp) + (ws.func_72935_r() ? Helper.getDaylight((World)ws, bp) : 0)), (int)0, (int)15);
                        map.put(bp, new BlockStorage(state, ws.func_175625_s(bp), light));
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return map;
    }

    @SideOnly(value=Side.CLIENT)
    public void setupClientWorld() {
        this.clientWorld = new WorldBoti(this.getDimension(), (WorldClient)this.field_70170_p, this.shell);
    }

    public int getLightFromNeighborsFor(WorldServer server, EnumSkyBlock type, BlockPos pos) {
        if (!server.field_73011_w.func_191066_m() && type == EnumSkyBlock.SKY) {
            return 0;
        }
        if (pos.func_177956_o() < 0) {
            pos = new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        }
        if (!server.func_175701_a(pos)) {
            return type.field_77198_c;
        }
        if (!server.func_175667_e(pos)) {
            return type.field_77198_c;
        }
        if (server.func_180495_p(pos).func_185916_f()) {
            int i1 = server.func_175642_b(type, pos.func_177984_a());
            int i = server.func_175642_b(type, pos.func_177974_f());
            int j = server.func_175642_b(type, pos.func_177976_e());
            int k = server.func_175642_b(type, pos.func_177968_d());
            int l = server.func_175642_b(type, pos.func_177978_c());
            if (i > i1) {
                i1 = i;
            }
            if (j > i1) {
                i1 = j;
            }
            if (k > i1) {
                i1 = k;
            }
            if (l > i1) {
                i1 = l;
            }
            return i1;
        }
        Chunk chunk = server.func_175726_f(pos);
        return chunk.func_177413_a(type, pos);
    }

    public void syncWorldShell() {
        NetworkHandler.NETWORK.sendToServer((IMessage)new MessageRequestBOTI(this.func_145782_y()));
    }

    public void handleEnter() {
        if (!this.field_70170_p.field_72995_K && this.isOpen()) {
            TileEntityTardis tardis = this.getTardis();
            if (tardis == null) {
                return;
            }
            for (Entity entity : this.field_70170_p.func_72872_a(Entity.class, this.func_174813_aQ())) {
                if (entity.func_70093_af()) continue;
                tardis.transferPlayer(entity, true);
            }
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        TileEntityTardis tardis = this.getTardis();
        if (tardis == null) {
            return;
        }
        if (this.isOpen() && this.field_70170_p.func_82737_E() % 200L == 0L || this.getBotiUpdate()) {
            this.updateWorldShell();
        }
        if (this.field_70170_p.field_72995_K && this.isOpen()) {
            if (this.shell.getOffset().equals((Object)BlockPos.field_177992_a)) {
                this.syncWorldShell();
            }
            if (this.field_70170_p.func_82737_E() % (long)TardisConfig.BOTI.botiTickRate == 0L || this.getBotiUpdate()) {
                this.syncWorldShell();
            }
            this.shell.setTime(this.shell.getTime() + 1L);
            if (this.clientWorld == null || ((WorldBoti)this.clientWorld).dimension != this.getDimension()) {
                this.setupClientWorld();
            }
        }
        this.setBotiUpdate(false);
        this.handleEnter();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % 20L == 0L && tardis != null) {
            WorldServer world = this.field_70170_p.func_73046_m().func_71218_a(tardis.dimension);
            EnumFacing face = EnumFacing.func_176733_a((double)(this.getFacing() + 180.0f));
            if (this.isOpen() && ControlDoor.isWater((World)world, tardis.getLocation().func_177972_a(face))) {
                if (!ControlDoor.isWater(this.field_70170_p, this.func_180425_c()) && !tardis.isForceFieldEnabled()) {
                    ControlDoor.updateFluid(this.field_70170_p, this.func_180425_c(), Blocks.field_150355_j.func_176223_P());
                }
            } else if (ControlDoor.isWater(this.field_70170_p, this.func_180425_c())) {
                ControlDoor.updateFluid(this.field_70170_p, this.func_180425_c(), Blocks.field_150350_a.func_176223_P());
            }
            if (this.isOpen() && ControlDoor.isWater((World)world, tardis.getLocation().func_177972_a(tardis.getFacing()).func_177984_a())) {
                if (!ControlDoor.isWater(this.field_70170_p, this.func_180425_c().func_177984_a()) && !tardis.isForceFieldEnabled()) {
                    ControlDoor.updateFluid(this.field_70170_p, this.func_180425_c().func_177984_a(), Blocks.field_150355_j.func_176223_P());
                }
            } else if (ControlDoor.isWater(this.field_70170_p, this.func_180425_c().func_177984_a())) {
                ControlDoor.updateFluid(this.field_70170_p, this.func_180425_c().func_177984_a(), Blocks.field_150350_a.func_176223_P());
            }
        }
        if (tardis.isInFlight() && this.isOpen()) {
            for (EntityLivingBase base : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(30.0))) {
                Vec3d move = this.func_174791_d().func_178788_d(base.func_174791_d()).func_72432_b().func_186678_a(0.23);
                base.field_70159_w += move.field_72450_a;
                base.field_70181_x += move.field_72448_b;
                base.field_70179_y += move.field_72449_c;
            }
        }
    }

    private static boolean isWater(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a() == Material.field_151586_h;
    }

    private static void updateFluid(World world, BlockPos pos, IBlockState state) {
        world.func_180501_a(pos, state, 3);
        state.func_177230_c().func_189540_a(state, world, pos, state.func_177230_c(), pos);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(IS_OPEN, (Object)false);
        this.field_70180_af.func_187214_a(FACING, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(UPDATE, (Object)true);
        this.field_70180_af.func_187214_a(MOTION, (Object)new Vec3d(0.0, 0.0, 0.0));
    }

    @Override
    public boolean isOpen() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_OPEN);
    }

    @Override
    public void setOpen(boolean open) {
        this.field_70180_af.func_187227_b(IS_OPEN, (Object)open);
    }

    @Override
    public WorldShell getWorldShell() {
        return this.shell;
    }

    @Override
    public void setWorldShell(WorldShell worldShell) {
        this.shell = worldShell;
    }

    @Override
    public int getDimension() {
        TileEntityTardis tardis = this.getTardis();
        return tardis == null ? 0 : tardis.dimension;
    }

    @Override
    public World getRenderWorld() {
        return this.clientWorld;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.field_70180_af.func_187227_b(IS_OPEN, (Object)compound.func_74767_n("open"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74757_a("open", ((Boolean)this.field_70180_af.func_187225_a(IS_OPEN)).booleanValue());
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source != null && source.func_76346_g() instanceof EntityPlayer) {
            if (!this.field_70170_p.field_72995_K) {
                InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (ItemStack)new ItemStack(TItems.interior_door));
            }
            this.func_70106_y();
        }
        return true;
    }

    public void setBotiUpdate(boolean update) {
        this.updateServerSide = update;
    }

    public boolean getBotiUpdate() {
        return this.updateServerSide;
    }

    public Vec3d getMotion() {
        return (Vec3d)this.field_70180_af.func_187225_a(MOTION);
    }
}

