/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.entities;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIZombieAttack;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.tardis.mod.api.entities.IDontSufficate;
import net.tardis.mod.common.TDamage;
import net.tardis.mod.common.entities.EntityLaserRay;
import net.tardis.mod.common.items.TItems;
import net.tardis.mod.common.sounds.TSounds;

public class EntityDalek
extends EntityMob
implements IRangedAttackMob,
EntityFlying,
IDontSufficate {
    private ItemStack[] deathItems;
    private float heightOffset;
    private int heightOffsetUpdateTime;

    public EntityDalek(World world) {
        super(world);
        this.deathItems = new ItemStack[]{new ItemStack(TItems.power_cell, 20 + this.field_70146_Z.nextInt(11)), new ItemStack(TItems.gunstick, 1), new ItemStack(TItems.circuts, 7 + this.field_70146_Z.nextInt(3))};
        this.heightOffset = 0.5f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 0.75, 40, 30.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.func_175456_n();
        this.field_70178_ae = true;
    }

    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 100, true, false, input -> !(input instanceof EntityDalek) && EntityDalek.canEntityAttack((Entity)input)));
    }

    public static boolean canEntityAttack(Entity entity) {
        if (entity instanceof EntityLiving) {
            EntityLiving ent = (EntityLiving)entity;
            for (EntityAITasks.EntityAITaskEntry task : ent.field_70714_bg.field_75782_a) {
                if (!(task.field_75733_a instanceof EntityAIAttackMelee) && !(task.field_75733_a instanceof EntityAIAttackRanged) && !(task.field_75733_a instanceof EntityAIAttackRangedBow) && !(task.field_75733_a instanceof EntityAINearestAttackableTarget) && !(task.field_75733_a instanceof EntityAIZombieAttack) && !(task.field_75733_a instanceof EntityAIOwnerHurtByTarget)) continue;
                return true;
            }
        }
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    protected void func_70664_aZ() {
        super.func_70664_aZ();
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (this.field_70170_p.field_72995_K && (!this.field_70122_E || this.field_70170_p.func_175623_d(this.func_180425_c().func_177977_b()))) {
            for (int x = 0; x <= 13; ++x) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.5 - 0.3, this.field_70163_u, this.field_70161_v + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.5 - 0.2, 1.0, 1.0, 2.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (this.field_70170_p.field_73012_v.nextDouble() + 0.5) * 0.5 - 0.3, this.field_70163_u, this.field_70161_v + (this.field_70170_p.field_73012_v.nextDouble() + 0.5) * 0.5 - 0.2, 1.0, 1.0, 2.0, new int[0]);
            }
        }
        super.func_70636_d();
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            int index = this.field_70146_Z.nextInt(this.deathItems.length);
            InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (ItemStack)this.deathItems[index]);
        }
    }

    protected void func_70619_bc() {
        --this.heightOffsetUpdateTime;
        if (this.heightOffsetUpdateTime <= 0) {
            this.heightOffsetUpdateTime = 1200;
            this.heightOffset = 0.5f + (float)this.field_70146_Z.nextGaussian() * 3.0f;
        }
        EntityLivingBase entitylivingbase = this.func_70638_az();
        if (this.func_70090_H() || this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_185904_a() == Material.field_151586_h || entitylivingbase != null && entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() > this.field_70163_u + (double)this.func_70047_e() + (double)this.heightOffset) {
            this.field_70181_x += ((double)0.3f - this.field_70181_x) * (double)0.3f;
            this.field_70160_al = true;
        }
        super.func_70619_bc();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public float func_70047_e() {
        return 1.0f;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        EntityLaserRay laser = new EntityLaserRay(this.field_70170_p, (EntityLivingBase)this, 7.0f, TDamage.DALEK, new Vec3d(0.0, 1.0, 0.0));
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - laser.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        laser.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 1.0f);
        this.func_184185_a(TSounds.dalek_ray, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)laser);
    }

    public void func_184724_a(boolean swingingArms) {
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.func_70638_az() != null) {
            return TSounds.dalek;
        }
        return null;
    }
}

