/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.worldshell;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tardis.mod.client.worldshell.BlockStorage;
import net.tardis.mod.client.worldshell.PlayerStorage;

public class WorldShell
implements IBlockAccess {
    public Map<BlockPos, BlockStorage> blockMap;
    @SideOnly(value=Side.CLIENT)
    BufferBuilder.State bufferstate;
    private List<TileEntity> tesrs;
    private List<NBTTagCompound> entities;
    private List<PlayerStorage> players = new ArrayList<PlayerStorage>();
    private BlockPos offset;
    private long time = 0L;
    private float rotation = 0.0f;
    private Biome shellBiome = Biome.func_150568_d((int)0);
    private List<Entity> renderEntities = new ArrayList<Entity>();

    public WorldShell(BlockPos bp) {
        this.blockMap = new HashMap<BlockPos, BlockStorage>();
        this.offset = bp;
        this.tesrs = new ArrayList<TileEntity>();
        this.entities = new ArrayList<NBTTagCompound>();
    }

    public BlockPos getOffset() {
        return this.offset;
    }

    @SideOnly(value=Side.CLIENT)
    public TileEntity func_175625_s(BlockPos pos) {
        if (this.blockMap == null || Minecraft.func_71410_x().field_71441_e == null || pos == null || !this.blockMap.containsKey(pos) || this.blockMap.get(pos) == null || this.blockMap.get((Object)pos).tileentity == null) {
            return null;
        }
        return TileEntity.func_190200_a((World)Minecraft.func_71410_x().field_71441_e, (NBTTagCompound)this.blockMap.get((Object)pos).tileentity);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_175626_b(BlockPos pos, int lightValue) {
        return 15;
    }

    public int getLightSet(EnumSkyBlock type, BlockPos pos) {
        return 15;
    }

    public void setShellBiome(Biome shellBiome) {
        this.shellBiome = shellBiome;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        if (this.blockMap.get(pos) != null) {
            return this.blockMap.get((Object)pos).blockstate;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.blockMap.get((Object)pos).blockstate.func_185904_a() == Material.field_151579_a;
    }

    @SideOnly(value=Side.CLIENT)
    public Biome func_180494_b(BlockPos pos) {
        return this.shellBiome;
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public WorldType func_175624_G() {
        return WorldType.field_77137_b;
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        if (!this.blockMap.containsKey(pos)) {
            return _default;
        }
        return this.blockMap.get((Object)pos).blockstate.isSideSolid((IBlockAccess)this, pos, side);
    }

    public List<TileEntity> getTESRs() {
        return this.tesrs;
    }

    @SideOnly(value=Side.CLIENT)
    public void setTESRs(World world) {
        for (BlockStorage bs : this.blockMap.values()) {
            TileEntitySpecialRenderer renderer;
            TileEntity te;
            if (bs.tileentity == null || (te = TileEntity.func_190200_a((World)world, (NBTTagCompound)bs.tileentity)) == null || (renderer = (TileEntitySpecialRenderer)TileEntityRendererDispatcher.field_147556_a.field_147559_m.get(te.getClass())) == null) continue;
            this.tesrs.add(te);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setEntities(World world) {
        for (NBTTagCompound tag : this.entities) {
            Entity e = EntityList.func_75615_a((NBTTagCompound)tag, (World)world);
            if (e == null) continue;
            this.renderEntities.add(e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<Entity> getEntitiesForRender() {
        return this.renderEntities;
    }

    public List<NBTTagCompound> getEntities() {
        return this.entities;
    }

    public void setEntities(List<NBTTagCompound> entity) {
        this.entities = entity;
    }

    public List<PlayerStorage> getPlayers() {
        return this.players;
    }

    public void setPlayers(List<PlayerStorage> storage) {
        this.players = storage;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rot) {
        this.rotation = rot;
    }
}

