/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.worldshell;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tardis.mod.client.worldshell.FakeClientPlayer;

public class PlayerStorage {
    public GameProfile profile;
    public double posX;
    public double posY;
    public double posZ;
    public double rotationYaw;
    public NBTTagCompound tag = new NBTTagCompound();

    public PlayerStorage() {
    }

    public PlayerStorage(EntityPlayer player) {
        this.profile = player.func_146103_bH();
        this.posX = player.field_70165_t;
        this.posY = player.field_70163_u;
        this.posZ = player.field_70161_v;
        this.rotationYaw = player.field_70759_as;
        this.tag.func_74757_a("sneak", player.func_70093_af());
        this.tag.func_74757_a("riding", player.func_184218_aH());
        this.tag.func_74776_a("limbSwing", player.field_184619_aG);
        this.tag.func_74776_a("limbSwingAmount", player.field_70721_aZ);
        this.tag.func_74768_a("ageInTicks", player.field_70173_aa);
        this.tag.func_74776_a("rotationYaw", player.field_70177_z);
        this.tag.func_74776_a("rotationYawHead", player.field_70759_as);
    }

    public static PlayerStorage fromBytes(ByteBuf buf) {
        PlayerStorage stor = new PlayerStorage();
        stor.profile = new GameProfile(UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf)), "name");
        stor.posX = buf.readDouble();
        stor.posY = buf.readDouble();
        stor.posZ = buf.readDouble();
        stor.tag = ByteBufUtils.readTag((ByteBuf)buf);
        return stor;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.profile.getId().toString());
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
    }

    @SideOnly(value=Side.CLIENT)
    public FakeClientPlayer getPlayer(World world) {
        FakeClientPlayer player = new FakeClientPlayer(world, this.profile);
        player.func_70107_b(this.posX, this.posY, this.posZ);
        player.func_70095_a(this.tag.func_74767_n("sneak"));
        player.isRiding = this.tag.func_74767_n("riding");
        player.field_184619_aG = this.tag.func_74760_g("limbSwing");
        player.field_70721_aZ = this.tag.func_74760_g("limbSwingAmount");
        player.field_70173_aa = this.tag.func_74762_e("ageInTicks");
        player.field_70177_z = this.tag.func_74760_g("rotationYaw");
        player.field_70759_as = this.tag.func_74760_g("rotationYawHead");
        return player;
    }
}

