/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.portalgun.common.tileentity;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import me.ichun.mods.portalgun.common.portal.info.PortalInfo;
import me.ichun.mods.portalgun.common.portal.world.PortalPlacement;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TilePortalBase
extends TileEntity {
    public EnumMap<EnumFacing, PortalPlacement> portals = new EnumMap(EnumFacing.class);
    public HashSet<PortalPlacement> portalsToRemove = new HashSet();
    public boolean iterating;

    public boolean onBlockRemoval() {
        if (this.field_145850_b.func_175625_s(this.func_174877_v()) != this) {
            return true;
        }
        this.iterating = true;
        Iterator<Map.Entry<EnumFacing, PortalPlacement>> ite = this.portals.entrySet().iterator();
        while (ite.hasNext()) {
            PortalPlacement placement = ite.next().getValue();
            placement.setWorld(this.field_145850_b);
            placement.remove(this.func_174877_v());
            ite.remove();
        }
        this.clearPortalsForRemoval();
        this.iterating = false;
        return true;
    }

    public void checkValidity() {
        this.iterating = true;
        Iterator<Map.Entry<EnumFacing, PortalPlacement>> ite = this.portals.entrySet().iterator();
        while (ite.hasNext()) {
            Map.Entry<EnumFacing, PortalPlacement> e = ite.next();
            e.getValue().setWorld(this.field_145850_b);
            e.getValue().addCompensationIfRequired(this.func_174877_v());
            if (e.getValue().isValid()) continue;
            e.getValue().remove(this.func_174877_v());
            ite.remove();
        }
        this.clearPortalsForRemoval();
        this.iterating = false;
        if (this.portals.isEmpty()) {
            this.func_145831_w().func_175698_g(this.func_174877_v());
        }
    }

    public void clearPortalsForRemoval() {
        Iterator<Map.Entry<EnumFacing, PortalPlacement>> ite = this.portals.entrySet().iterator();
        while (ite.hasNext()) {
            if (!this.portalsToRemove.contains((Object)ite.next().getValue())) continue;
            ite.remove();
        }
        this.portalsToRemove.clear();
    }

    public void removePortal(PortalPlacement portal) {
        if (portal == null) {
            return;
        }
        if (portal.equals((Object)this.portals.get(portal.getFaceOn()))) {
            if (this.iterating) {
                this.portalsToRemove.add(portal);
            } else {
                this.portals.remove(portal.getFaceOn());
            }
        }
        if (this.portals.isEmpty()) {
            this.func_145831_w().func_175698_g(this.func_174877_v());
        } else {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.func_70296_d();
        }
    }

    public boolean addPortal(PortalPlacement portal) {
        if (portal == null || this.portals.containsKey(portal.getFaceOn()) && !this.portals.get(portal.getFaceOn()).getPortal().isSameType(portal.getPortal())) {
            return false;
        }
        this.portals.put(portal.getFaceOn(), portal);
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        return true;
    }

    public PortalPlacement getPortalPlacementFromInfo(PortalInfo info) {
        for (Map.Entry<EnumFacing, PortalPlacement> e : this.portals.entrySet()) {
            if (!e.getValue().getPortal().equals(info)) continue;
            return e.getValue();
        }
        return null;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        for (Map.Entry<EnumFacing, PortalPlacement> e : this.portals.entrySet()) {
            tag.func_74782_a("face_" + e.getValue().getFaceOn().func_176745_a(), (NBTBase)e.getValue().writeToNBT(new NBTTagCompound()));
        }
        return tag;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < 6; ++i) {
            if (!tag.func_74764_b("face_" + i)) continue;
            EnumFacing face = EnumFacing.func_82600_a((int)i);
            PortalPlacement portal = new PortalPlacement(null).readFromNBT(tag.func_74775_l("face_" + i), false);
            if (portal.equals((Object)this.portals.get(portal.getFaceOn()))) continue;
            this.portals.put(face, portal);
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.portals.clear();
        this.func_145839_a(pkt.func_148857_g());
    }
}

