/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.net;

import com.feed_the_beast.ftblib.client.teamsgui.GuiSelectTeam;
import com.feed_the_beast.ftblib.client.teamsgui.PublicTeamData;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToClient;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftblib.net.FTBLibNetHandler;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageSelectTeamGui
extends MessageToClient {
    private Collection<PublicTeamData> teams;
    private boolean canCreate;

    public MessageSelectTeamGui() {
    }

    public MessageSelectTeamGui(ForgePlayer player, boolean c) {
        this.teams = new ArrayList<PublicTeamData>();
        for (ForgeTeam team : Universe.get().getTeams()) {
            PublicTeamData.Type type = PublicTeamData.Type.NEEDS_INVITE;
            if (team.isEnemy(player)) {
                type = PublicTeamData.Type.ENEMY;
            } else if (team.isInvited(player)) {
                type = PublicTeamData.Type.CAN_JOIN;
            } else if (team.isRequestingInvite(player)) {
                type = PublicTeamData.Type.REQUESTING_INVITE;
            }
            this.teams.add(new PublicTeamData(team, type));
        }
        this.canCreate = c;
    }

    @Override
    public NetworkWrapper getWrapper() {
        return FTBLibNetHandler.MY_TEAM;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeCollection(this.teams, PublicTeamData.SERIALIZER);
        data.writeBoolean(this.canCreate);
    }

    @Override
    public void readData(DataIn data) {
        this.teams = data.readCollection(null, PublicTeamData.DESERIALIZER);
        this.canCreate = data.readBoolean();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        new GuiSelectTeam(this.teams, this.canCreate).openGui();
    }
}

