/*
 * Decompiled with CFR 0.152.
 */
package net.timardo.lt3dimporter.littlestructure;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiColorPicker;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.controls.gui.custom.GuiStackSelectorAll;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.LittleSubGuiUtils;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.math.location.StructureLocation;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.timardo.lt3dimporter.importer.Importer;
import net.timardo.lt3dimporter.littlestructure.ModelImporter;
import net.timardo.lt3dimporter.network.PacketStructureImporterNBT;
import org.lwjgl.util.Color;

public class ModelImporterGui
extends SubGui {
    public GuiTextfield modelFile;
    public GuiComboBox gridSizes;
    public GuiTextfield minPrecision;
    public GuiTextfield texFile;
    public GuiColorPicker colorPicker;
    public GuiCheckBox useTex;
    public GuiCheckBox useColor;
    public GuiCheckBox useMtl;
    public GuiStackSelectorAll baseBlock;
    public GuiTextfield maxSize;
    public ModelImporter parentStructure;

    public ModelImporterGui(ModelImporter s) {
        super(220, 186);
        this.parentStructure = s;
    }

    public void createControls() {
        this.modelFile = new GuiTextfield("modelfile", "", 5, 5, 128, 14);
        this.modelFile.maxLength = 32768;
        this.modelFile.setCustomTooltip(new String[]{"Path to model"});
        this.modelFile.text = this.parentStructure.model;
        this.addControl((GuiControl)this.modelFile);
        this.gridSizes = new GuiComboBox("gridsizes", 144, 5, 27, LittleGridContext.getNames());
        this.gridSizes.setCustomTooltip(new String[]{"Grid"});
        this.gridSizes.select(this.parentStructure.gridSize);
        this.addControl((GuiControl)this.gridSizes);
        this.minPrecision = new GuiTextfield("precision", "0.7", 182, 5, 27, 14);
        this.minPrecision.allowedChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.'};
        this.minPrecision.setCustomTooltip(new String[]{"Precision"});
        this.minPrecision.text = this.parentStructure.precision;
        this.addControl((GuiControl)this.minPrecision);
        this.baseBlock = new GuiStackSelectorAll("baseblock", 5, 30, 106, this.getPlayer(), (GuiStackSelectorAll.StackCollector)new GuiStackSelectorAll.CreativeCollector((GuiStackSelectorAll.StackSelector)new LittleSubGuiUtils.LittleBlockSelector()), true);
        this.baseBlock.setCustomTooltip(new String[]{"Base block"});
        this.baseBlock.setSelectedForce(this.parentStructure.baseBlock);
        this.addControl((GuiControl)this.baseBlock);
        this.useTex = new GuiCheckBox("useTex", "Use Texture", 141, 27, false){

            public boolean mousePressed(int posX, int posY, int button) {
                if (button != -21) {
                    1.playSound((SoundEvent)SoundEvents.field_187909_gi);
                }
                if (ModelImporterGui.this.useTex.value) {
                    return false;
                }
                ModelImporterGui.this.useTex.value = true;
                ModelImporterGui.this.useColor.value = false;
                this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
                ModelImporterGui.this.removeControl((GuiControl)ModelImporterGui.this.colorPicker);
                ModelImporterGui.this.addControl((GuiControl)ModelImporterGui.this.texFile);
                ModelImporterGui.this.addControl((GuiControl)ModelImporterGui.this.useMtl);
                return true;
            }
        };
        this.useColor = new GuiCheckBox("useColor", "Use Color", 141, 40, false){

            public boolean mousePressed(int posX, int posY, int button) {
                if (button != -21) {
                    2.playSound((SoundEvent)SoundEvents.field_187909_gi);
                }
                if (ModelImporterGui.this.useColor.value) {
                    return false;
                }
                ModelImporterGui.this.useTex.value = false;
                ModelImporterGui.this.useColor.value = true;
                this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
                ModelImporterGui.this.removeControl((GuiControl)ModelImporterGui.this.texFile);
                ModelImporterGui.this.removeControl((GuiControl)ModelImporterGui.this.useMtl);
                ModelImporterGui.this.addControl((GuiControl)ModelImporterGui.this.colorPicker);
                return true;
            }
        };
        this.useMtl = new GuiCheckBox("useMtl", "Use .mtl File", 2, 77, false){

            public boolean mousePressed(int posX, int posY, int button) {
                if (button != -21) {
                    3.playSound((SoundEvent)SoundEvents.field_187909_gi);
                }
                this.value = !this.value;
                ModelImporterGui.this.texFile.enabled = !ModelImporterGui.this.useMtl.value;
                this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
                return true;
            }
        };
        this.addControl((GuiControl)this.useTex);
        this.addControl((GuiControl)this.useColor);
        this.texFile = new GuiTextfield("texfile", "", 5, 55, 128, 14);
        this.texFile.maxLength = 32768;
        this.texFile.setCustomTooltip(new String[]{"Path to texture"});
        this.texFile.text = this.parentStructure.texFile;
        this.colorPicker = new GuiColorPicker("colorpicker", 4, 55, ColorUtils.IntToRGBA((int)this.parentStructure.color), LittleTiles.CONFIG.isTransparencyEnabled(this.getPlayer()), LittleTiles.CONFIG.getMinimumTransparency(this.getPlayer()));
        this.maxSize = new GuiTextfield("maxsize", this.parentStructure.maxSize, 144, 55, 65, 14);
        this.maxSize.setCustomTooltip(new String[]{"Max size"});
        this.maxSize.setNumbersOnly();
        this.addControl((GuiControl)this.maxSize);
        this.addControl((GuiControl)new GuiButton("importbutton", "Import!", 144, 80, 42, 14){

            public void onClicked(int var1, int var2, int var3) {
                Importer converter = new Importer(ModelImporterGui.this.modelFile.text, ModelImporterGui.this.texFile.text, ModelImporterGui.this.colorPicker.color, Integer.parseInt(ModelImporterGui.this.maxSize.text), Integer.parseInt(ModelImporterGui.this.gridSizes.getCaption()), Float.parseFloat(ModelImporterGui.this.minPrecision.text), ModelImporterGui.this.baseBlock.getSelected(), ModelImporterGui.this.useTex.value, ModelImporterGui.this.useMtl.value, this.getPlayer(), ModelImporterGui.this.parentStructure);
                Thread t = new Thread(converter);
                t.start();
            }
        });
        if (this.parentStructure.useTex) {
            this.useTex.mousePressed(0, 0, -21);
        } else {
            this.useColor.mousePressed(0, 0, -21);
        }
        if (this.parentStructure.useMtl) {
            this.useMtl.mousePressed(0, 0, -21);
        }
    }

    public void onClosed() {
        super.onClosed();
        this.updateSettings();
    }

    public void updateSettings() {
        PacketStructureImporterNBT nbtPacket = new PacketStructureImporterNBT();
        NBTTagCompound packetNBT = new NBTTagCompound();
        packetNBT.func_74757_a("item", false);
        packetNBT.func_74782_a("loc", (NBTBase)new StructureLocation((LittleStructure)this.parentStructure).write());
        packetNBT.func_74778_a("model", this.modelFile.text);
        packetNBT.func_74778_a("tex_file", this.texFile.text);
        packetNBT.func_74768_a("color", ColorUtils.RGBAToInt((Color)this.colorPicker.color));
        packetNBT.func_74778_a("max_size", this.maxSize.text);
        packetNBT.func_74778_a("grid", this.gridSizes.getCaption());
        packetNBT.func_74778_a("precision", this.minPrecision.text);
        packetNBT.func_74782_a("base_block", (NBTBase)this.baseBlock.getSelected().serializeNBT());
        packetNBT.func_74757_a("use_tex", this.useTex.value);
        packetNBT.func_74757_a("use_mtl", this.useMtl.value);
        nbtPacket.setNBT(packetNBT);
        PacketHandler.sendPacketToServer((CreativeCorePacket)nbtPacket);
    }
}

