/*
 * Decompiled with CFR 0.152.
 */
package net.timardo.lt3dimporter.importer;

import de.javagl.obj.FloatTuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.timardo.lt3dimporter.LT3DImporter;
import net.timardo.lt3dimporter.importer.ConvertedModel;
import net.timardo.lt3dimporter.importer.ImportException;

public class Triangle {
    public Vec3d a;
    public Vec3d b;
    public Vec3d c;
    public double[] u;
    public double[] v;
    public boolean t;

    public Triangle(FloatTuple a, FloatTuple b, FloatTuple c) {
        this.a = new Vec3d((double)a.getX(), (double)a.getY(), (double)a.getZ());
        this.b = new Vec3d((double)b.getX(), (double)b.getY(), (double)b.getZ());
        this.c = new Vec3d((double)c.getX(), (double)c.getY(), (double)c.getZ());
        this.t = false;
    }

    public void calcBlocks(float minPrecision, double scale, ConvertedModel output, String material) throws ImportException {
        Vec3d sA = this.a.func_186678_a(scale);
        Vec3d sB = this.b.func_186678_a(scale);
        Vec3d sC = this.c.func_186678_a(scale);
        Vec3d vectAC = sA.func_72444_a(sC);
        Vec3d vectBC = sB.func_72444_a(sC);
        double slices = vectAC.func_72433_c() / (double)minPrecision + 2.0;
        int i = 0;
        while ((double)i <= slices) {
            int k;
            double[] dArray;
            double[] dArray2;
            double t = (double)i / slices;
            Vec3d p1 = sA.func_178787_e(vectAC.func_186678_a(t));
            if (this.t) {
                double[] dArray3 = new double[2];
                dArray3[0] = this.u[0] + (this.u[2] - this.u[0]) * t;
                dArray2 = dArray3;
                dArray3[1] = this.v[0] + (this.v[2] - this.v[0]) * t;
            } else {
                dArray2 = null;
            }
            double[] uv1 = dArray2;
            Vec3d p2 = sB.func_178787_e(vectBC.func_186678_a(t));
            if (this.t) {
                double[] dArray4 = new double[2];
                dArray4[0] = this.u[1] + (this.u[2] - this.u[1]) * t;
                dArray = dArray4;
                dArray4[1] = this.v[1] + (this.v[2] - this.v[1]) * t;
            } else {
                dArray = null;
            }
            double[] uv2 = dArray;
            double r = 0.0;
            int a1 = MathHelper.func_76143_f((double)p1.field_72450_a);
            int a2 = MathHelper.func_76143_f((double)p2.field_72450_a);
            int min = Math.min(a1, a2);
            int max = Math.max(a1, a2);
            for (k = min; k < max; ++k) {
                double[] dArray5;
                r = Math.abs((double)k - p1.field_72450_a) / Math.abs(p2.field_72450_a - p1.field_72450_a);
                BlockPos blockPos = new BlockPos(Triangle.getIntermediate(p1, p2, k, 0));
                if (this.t) {
                    double[] dArray6 = new double[2];
                    dArray6[0] = uv1[0] + (uv2[0] - uv1[0]) * r;
                    dArray5 = dArray6;
                    dArray6[1] = uv1[1] + (uv2[1] - uv1[1]) * r;
                } else {
                    dArray5 = null;
                }
                output.addTile(blockPos, dArray5, material);
            }
            a1 = MathHelper.func_76143_f((double)p1.field_72448_b);
            a2 = MathHelper.func_76143_f((double)p2.field_72448_b);
            min = Math.min(a1, a2);
            max = Math.max(a1, a2);
            for (k = min; k < max; ++k) {
                double[] dArray7;
                r = Math.abs((double)k - p1.field_72448_b) / Math.abs(p2.field_72448_b - p1.field_72448_b);
                BlockPos blockPos = new BlockPos(Triangle.getIntermediate(p1, p2, k, 1));
                if (this.t) {
                    double[] dArray8 = new double[2];
                    dArray8[0] = uv1[0] + (uv2[0] - uv1[0]) * r;
                    dArray7 = dArray8;
                    dArray8[1] = uv1[1] + (uv2[1] - uv1[1]) * r;
                } else {
                    dArray7 = null;
                }
                output.addTile(blockPos, dArray7, material);
            }
            a1 = MathHelper.func_76143_f((double)p1.field_72449_c);
            a2 = MathHelper.func_76143_f((double)p2.field_72449_c);
            min = Math.min(a1, a2);
            max = Math.max(a1, a2);
            for (k = min; k < max; ++k) {
                double[] dArray9;
                r = Math.abs((double)k - p1.field_72449_c) / Math.abs(p2.field_72449_c - p1.field_72449_c);
                BlockPos blockPos = new BlockPos(Triangle.getIntermediate(p1, p2, k, 2));
                if (this.t) {
                    double[] dArray10 = new double[2];
                    dArray10[0] = uv1[0] + (uv2[0] - uv1[0]) * r;
                    dArray9 = dArray10;
                    dArray10[1] = uv1[1] + (uv2[1] - uv1[1]) * r;
                } else {
                    dArray9 = null;
                }
                output.addTile(blockPos, dArray9, material);
            }
            ++i;
        }
    }

    public void addTexCoords(FloatTuple a, FloatTuple b, FloatTuple c) {
        this.u = new double[]{a.getX(), b.getX(), c.getX()};
        this.v = new double[]{a.getY(), b.getY(), c.getY()};
        this.t = true;
    }

    private static Vec3d getIntermediate(Vec3d p1, Vec3d p2, double n, int p) throws ImportException {
        double t;
        double dX = p2.field_72450_a - p1.field_72450_a;
        double dY = p2.field_72448_b - p1.field_72448_b;
        double dZ = p2.field_72449_c - p1.field_72449_c;
        if (p == 0 && dX == 0.0 || p == 1 && dY == 0.0 || p == 2 && dZ == 0.0) {
            return p1;
        }
        double d = p == 0 ? (n - p1.field_72450_a) / dX : (t = p == 1 ? (n - p1.field_72448_b) / dY : (n - p1.field_72449_c) / dZ);
        if (t >= 0.0 && t <= 1.0) {
            return new Vec3d(p1.field_72450_a + dX * t, p1.field_72448_b + dY * t, p1.field_72449_c + dZ * t);
        }
        LT3DImporter.logger.error("Error getting intermediate value! Expected t from <0,1>, got " + t + ". Base points, 'p' and 'n': " + p1 + ", " + p2 + ", " + p + ", " + n);
        throw new ImportException("An error occured while converting model, check log for more information!");
    }
}

