/*
 * Decompiled with CFR 0.152.
 */
package net.timardo.lt3dimporter.importer;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.timardo.lt3dimporter.importer.ITexture;

public class NormalTexture
implements ITexture {
    private BufferedImage texture;

    public NormalTexture(String texFile) throws IOException {
        this.texture = ImageIO.read(new File(texFile));
        this.texture = this.resizeTextureIfNeeded(this.texture);
    }

    @Override
    public int colorTile(double[] uv) {
        if (uv == null) {
            return -1;
        }
        double nU = uv[0] % 1.0;
        double nV = uv[1] % 1.0;
        if (nU < 0.0) {
            nU += 1.0;
        }
        if (nV < 0.0) {
            nV += 1.0;
        }
        int x = (int)(nU * (double)(this.texture.getWidth() - 1));
        int y = (int)((1.0 - nV) * (double)(this.texture.getHeight() - 1));
        return this.texture.getRGB(x, y);
    }
}

