/*
 * Decompiled with CFR 0.152.
 */
package net.timardo.lt3dimporter.importer;

import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import de.javagl.obj.Mtl;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.timardo.lt3dimporter.importer.ITexture;
import org.lwjgl.util.Color;

public class MtlTexture
implements ITexture {
    private float opacity;
    private float[] diffuse;
    private int color;
    private BufferedImage texture;

    public MtlTexture(Mtl mtlFile, String root) throws IOException {
        this.texture = mtlFile.getMapKd() != null ? ImageIO.read(new File((mtlFile.getMapKd().contains(":") ? "" : root) + mtlFile.getMapKd())) : null;
        this.texture = this.resizeTextureIfNeeded(this.texture);
        this.opacity = mtlFile.getD();
        this.diffuse = new float[]{MathHelper.func_76131_a((float)mtlFile.getKd().getX(), (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)mtlFile.getKd().getY(), (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)mtlFile.getKd().getZ(), (float)0.0f, (float)1.0f)};
        Color c = ColorUtils.IntToRGBA((int)ColorUtils.VecToInt((Vec3d)new Vec3d((double)this.diffuse[0], (double)this.diffuse[1], (double)this.diffuse[2])));
        c.setAlpha(MathHelper.func_76128_c((double)((double)this.opacity * 255.0)));
        this.color = ColorUtils.RGBAToInt((Color)c);
    }

    @Override
    public int colorTile(double[] uv) {
        if (this.texture == null) {
            return this.color;
        }
        double nU = uv[0] % 1.0;
        double nV = uv[1] % 1.0;
        if (nU < 0.0) {
            nU += 1.0;
        }
        if (nV < 0.0) {
            nV += 1.0;
        }
        int x = (int)(nU * (double)(this.texture.getWidth() - 1));
        int y = (int)((1.0 - nV) * (double)(this.texture.getHeight() - 1));
        Color c = ColorUtils.IntToRGBA((int)this.texture.getRGB(x, y));
        c.setRed(MathHelper.func_76141_d((float)((float)c.getRed() * this.diffuse[0])));
        c.setGreen(MathHelper.func_76141_d((float)((float)c.getGreen() * this.diffuse[1])));
        c.setBlue(MathHelper.func_76141_d((float)((float)c.getBlue() * this.diffuse[2])));
        c.setAlpha(MathHelper.func_76141_d((float)((float)c.getAlpha() * this.opacity)));
        return ColorUtils.RGBAToInt((Color)c);
    }
}

