/*
 * Decompiled with CFR 0.152.
 */
package net.timardo.lt3dimporter.importer;

import com.creativemd.littletiles.common.tile.LittleTileColored;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.timardo.lt3dimporter.importer.ITexture;
import net.timardo.lt3dimporter.obj3d.LightObj;

public class ConvertedModel {
    public LinkedHashMap<Integer, List<LittlePreview>> colorMap = new LinkedHashMap();
    public Set<Long> blocks = new LinkedHashSet<Long>();
    public Map<String, ITexture> textureMap;
    public LittleGridContext context;
    public LightObj obj;
    public double ratio;
    public Block baseBlock;
    public int meta;
    public NBTTagList previews;
    public Set<BlockPos> posSet;

    public ConvertedModel(Map<String, ITexture> texMap, LittleGridContext context, LightObj obj, double ratio, ItemStack baseBlock) {
        this.textureMap = texMap;
        this.context = context;
        this.obj = obj;
        this.ratio = ratio;
        this.baseBlock = Block.func_149634_a((Item)baseBlock.func_77973_b());
        this.meta = baseBlock.func_77960_j();
        this.previews = new NBTTagList();
        this.posSet = new HashSet<BlockPos>();
    }

    public void addTile(BlockPos blockPos, double[] uv, String material) {
        long longPos = blockPos.func_177986_g();
        if (!this.blocks.add(longPos)) {
            return;
        }
        int color = this.textureMap.get(material).colorTile(uv);
        List<LittlePreview> pList = this.colorMap.get(color);
        LittleTileColored tile = new LittleTileColored(this.baseBlock, this.meta, color);
        tile.setBox(new LittleBox(new LittleVec(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p())));
        if (pList == null) {
            pList = new ArrayList<LittlePreview>();
            pList.add(tile.getPreviewTile());
            this.colorMap.put(color, pList);
        } else {
            pList.add(tile.getPreviewTile());
        }
        BlockPos pos = tile.getPreviewTile().box.getMinVec().getBlockPos(this.context);
        if (!this.posSet.contains(pos)) {
            this.posSet.add(pos);
            this.previews.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
        }
    }
}

