/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.obj;

import de.javagl.obj.DefaultObjFace;
import de.javagl.obj.FloatTuple;
import de.javagl.obj.Obj;
import de.javagl.obj.ObjFace;
import de.javagl.obj.ObjFaces;
import de.javagl.obj.ObjGroup;
import de.javagl.obj.Objs;
import de.javagl.obj.ReadableObj;
import de.javagl.obj.WritableObj;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class ObjUtils {
    public static Obj convertToRenderable(ReadableObj input) {
        return ObjUtils.convertToRenderable(input, Objs.create());
    }

    public static <T extends WritableObj> T convertToRenderable(ReadableObj input, T output) {
        Obj obj = ObjUtils.triangulate(input);
        obj = ObjUtils.makeTexCoordsUnique(obj);
        obj = ObjUtils.makeNormalsUnique(obj);
        return ObjUtils.makeVertexIndexed(obj, output);
    }

    public static Obj triangulate(ReadableObj input) {
        return ObjUtils.triangulate(input, Objs.create());
    }

    public static <T extends WritableObj> T triangulate(ReadableObj input, T output) {
        output.setMtlFileNames(input.getMtlFileNames());
        ObjUtils.addAll(input, output);
        for (int i = 0; i < input.getNumFaces(); ++i) {
            ObjFace face = input.getFace(i);
            ObjUtils.activateGroups(input, face, output);
            if (face.getNumVertices() == 3) {
                output.addFace(face);
                continue;
            }
            for (int j = 0; j < face.getNumVertices() - 2; ++j) {
                DefaultObjFace triangle = ObjFaces.create(face, 0, j + 1, j + 2);
                output.addFace(triangle);
            }
        }
        return output;
    }

    public static Obj groupToObj(ReadableObj input, ObjGroup inputGroup, List<Integer> vertexIndexMapping) {
        return ObjUtils.groupToObj(input, inputGroup, vertexIndexMapping, Objs.create());
    }

    public static <T extends WritableObj> T groupToObj(ReadableObj input, ObjGroup inputGroup, List<Integer> vertexIndexMapping, T output) {
        int i;
        output.setMtlFileNames(input.getMtlFileNames());
        int[] vertexIndexMap = new int[input.getNumVertices()];
        int[] texCoordIndexMap = new int[input.getNumTexCoords()];
        int[] normalIndexMap = new int[input.getNumNormals()];
        Arrays.fill(vertexIndexMap, -1);
        Arrays.fill(texCoordIndexMap, -1);
        Arrays.fill(normalIndexMap, -1);
        int vertexCounter = 0;
        int texCoordCounter = 0;
        int normalCounter = 0;
        for (i = 0; i < inputGroup.getNumFaces(); ++i) {
            int j;
            ObjFace face = inputGroup.getFace(i);
            DefaultObjFace resultFace = ObjFaces.create(face);
            ObjUtils.activateGroups(input, face, output);
            for (j = 0; j < face.getNumVertices(); ++j) {
                int vertexIndex = face.getVertexIndex(j);
                if (vertexIndexMap[vertexIndex] == -1) {
                    vertexIndexMap[vertexIndex] = vertexCounter++;
                    output.addVertex(input.getVertex(vertexIndex));
                }
                resultFace.setVertexIndex(j, vertexIndexMap[vertexIndex]);
            }
            if (face.containsTexCoordIndices()) {
                for (j = 0; j < face.getNumVertices(); ++j) {
                    int texCoordIndex = face.getTexCoordIndex(j);
                    if (texCoordIndexMap[texCoordIndex] == -1) {
                        texCoordIndexMap[texCoordIndex] = texCoordCounter++;
                        output.addTexCoord(input.getTexCoord(texCoordIndex));
                    }
                    resultFace.setTexCoordIndex(j, texCoordIndexMap[texCoordIndex]);
                }
            }
            if (face.containsNormalIndices()) {
                for (j = 0; j < face.getNumVertices(); ++j) {
                    int normalIndex = face.getNormalIndex(j);
                    if (normalIndexMap[normalIndex] == -1) {
                        normalIndexMap[normalIndex] = normalCounter++;
                        output.addNormal(input.getNormal(normalIndex));
                    }
                    resultFace.setNormalIndex(j, normalIndexMap[normalIndex]);
                }
            }
            output.addFace(resultFace);
        }
        if (vertexIndexMapping != null) {
            for (i = 0; i < vertexCounter; ++i) {
                vertexIndexMapping.add(-1);
            }
            for (i = 0; i < input.getNumVertices(); ++i) {
                if (vertexIndexMap[i] == -1) continue;
                vertexIndexMapping.set(vertexIndexMap[i], i);
            }
        }
        return output;
    }

    public static Obj makeTexCoordsUnique(ReadableObj input) {
        return ObjUtils.makeTexCoordsUnique(input, null, Objs.create());
    }

    public static <T extends WritableObj> T makeTexCoordsUnique(ReadableObj input, List<Integer> indexMapping, T output) {
        PropertyIndexAccessor accessor = new PropertyIndexAccessor(){

            @Override
            public int getPropertyIndex(ReadableObj input, ObjFace face, int vertexNumber) {
                return face.getTexCoordIndex(vertexNumber);
            }

            @Override
            public boolean hasProperty(ObjFace face) {
                return face.containsTexCoordIndices();
            }
        };
        ObjUtils.makePropertiesUnique(input, accessor, indexMapping, output);
        return output;
    }

    public static Obj makeNormalsUnique(ReadableObj input) {
        return ObjUtils.makeNormalsUnique(input, null, Objs.create());
    }

    public static <T extends WritableObj> T makeNormalsUnique(ReadableObj input, List<Integer> indexMapping, T output) {
        PropertyIndexAccessor accessor = new PropertyIndexAccessor(){

            @Override
            public int getPropertyIndex(ReadableObj input, ObjFace face, int vertexNumber) {
                return face.getNormalIndex(vertexNumber);
            }

            @Override
            public boolean hasProperty(ObjFace face) {
                return face.containsNormalIndices();
            }
        };
        ObjUtils.makePropertiesUnique(input, accessor, indexMapping, output);
        return output;
    }

    private static void makePropertiesUnique(ReadableObj input, PropertyIndexAccessor propertyIndexAccessor, List<Integer> indexMapping, WritableObj output) {
        output.setMtlFileNames(input.getMtlFileNames());
        ObjUtils.addAll(input, output);
        int[] usedPropertyIndices = new int[input.getNumVertices()];
        Arrays.fill(usedPropertyIndices, -1);
        ArrayList<FloatTuple> extendedVertices = new ArrayList<FloatTuple>();
        for (int i = 0; i < input.getNumFaces(); ++i) {
            ObjFace inputFace = input.getFace(i);
            ObjUtils.activateGroups(input, inputFace, output);
            ObjFace outputFace = inputFace;
            if (propertyIndexAccessor.hasProperty(inputFace)) {
                DefaultObjFace extendedOutputFace = null;
                for (int j = 0; j < outputFace.getNumVertices(); ++j) {
                    int vertexIndex = outputFace.getVertexIndex(j);
                    int propertyIndex = propertyIndexAccessor.getPropertyIndex(input, outputFace, j);
                    if (usedPropertyIndices[vertexIndex] != -1 && usedPropertyIndices[vertexIndex] != propertyIndex) {
                        FloatTuple vertex = input.getVertex(vertexIndex);
                        int extendedVertexIndex = input.getNumVertices() + extendedVertices.size();
                        extendedVertices.add(vertex);
                        output.addVertex(vertex);
                        if (extendedOutputFace == null) {
                            extendedOutputFace = ObjFaces.create(inputFace);
                        }
                        extendedOutputFace.setVertexIndex(j, extendedVertexIndex);
                        if (indexMapping == null) continue;
                        int indexInObj = indexMapping.get(vertexIndex);
                        indexMapping.add(indexInObj);
                        continue;
                    }
                    usedPropertyIndices[vertexIndex] = propertyIndex;
                }
                if (extendedOutputFace != null) {
                    outputFace = extendedOutputFace;
                }
            }
            output.addFace(outputFace);
        }
    }

    private static void addAll(ReadableObj input, WritableObj output) {
        int i;
        for (i = 0; i < input.getNumVertices(); ++i) {
            output.addVertex(input.getVertex(i));
        }
        for (i = 0; i < input.getNumTexCoords(); ++i) {
            output.addTexCoord(input.getTexCoord(i));
        }
        for (i = 0; i < input.getNumNormals(); ++i) {
            output.addNormal(input.getNormal(i));
        }
    }

    public static void add(ReadableObj input, Obj output) {
        int i;
        int verticesOffset = output.getNumVertices();
        for (int i2 = 0; i2 < input.getNumVertices(); ++i2) {
            output.addVertex(input.getVertex(i2));
        }
        int texCoordsOffset = output.getNumTexCoords();
        for (int i3 = 0; i3 < input.getNumTexCoords(); ++i3) {
            output.addTexCoord(input.getTexCoord(i3));
        }
        int normalsOffset = output.getNumNormals();
        for (i = 0; i < input.getNumNormals(); ++i) {
            output.addNormal(input.getNormal(i));
        }
        for (i = 0; i < input.getNumFaces(); ++i) {
            ObjFace inputFace = input.getFace(i);
            ObjUtils.activateGroups(input, inputFace, output);
            DefaultObjFace outputFace = ObjFaces.createWithOffsets(inputFace, verticesOffset, texCoordsOffset, normalsOffset);
            output.addFace(outputFace);
        }
    }

    public static Obj makeVertexIndexed(ReadableObj input) {
        return ObjUtils.makeVertexIndexed(input, Objs.create());
    }

    public static <T extends WritableObj> T makeVertexIndexed(ReadableObj input, T output) {
        int i;
        output.setMtlFileNames(input.getMtlFileNames());
        for (int i2 = 0; i2 < input.getNumVertices(); ++i2) {
            output.addVertex(input.getVertex(i2));
        }
        boolean foundTexCoords = false;
        boolean foundNormals = false;
        int[] texCoordIndicesForVertexIndices = new int[input.getNumVertices()];
        int[] normalIndicesForVertexIndices = new int[input.getNumVertices()];
        for (i = 0; i < input.getNumFaces(); ++i) {
            ObjFace inputFace = input.getFace(i);
            for (int j = 0; j < inputFace.getNumVertices(); ++j) {
                int normalIndex;
                int vertexIndex = inputFace.getVertexIndex(j);
                if (inputFace.containsTexCoordIndices()) {
                    int texCoordIndex;
                    texCoordIndicesForVertexIndices[vertexIndex] = texCoordIndex = inputFace.getTexCoordIndex(j);
                    foundTexCoords = true;
                }
                if (!inputFace.containsNormalIndices()) continue;
                normalIndicesForVertexIndices[vertexIndex] = normalIndex = inputFace.getNormalIndex(j);
                foundNormals = true;
            }
        }
        if (foundTexCoords) {
            for (i = 0; i < input.getNumVertices(); ++i) {
                int texCoordIndex = texCoordIndicesForVertexIndices[i];
                FloatTuple texCoord = input.getTexCoord(texCoordIndex);
                output.addTexCoord(texCoord);
            }
        }
        if (foundNormals) {
            for (i = 0; i < input.getNumVertices(); ++i) {
                int normalIndex = normalIndicesForVertexIndices[i];
                FloatTuple normal = input.getNormal(normalIndex);
                output.addNormal(normal);
            }
        }
        for (i = 0; i < input.getNumFaces(); ++i) {
            int j;
            ObjFace inputFace = input.getFace(i);
            ObjUtils.activateGroups(input, inputFace, output);
            DefaultObjFace outputFace = ObjFaces.create(inputFace);
            if (inputFace.containsTexCoordIndices()) {
                for (j = 0; j < inputFace.getNumVertices(); ++j) {
                    outputFace.setTexCoordIndex(j, outputFace.getVertexIndex(j));
                }
            }
            if (inputFace.containsNormalIndices()) {
                for (j = 0; j < inputFace.getNumVertices(); ++j) {
                    outputFace.setNormalIndex(j, outputFace.getVertexIndex(j));
                }
            }
            output.addFace(outputFace);
        }
        return output;
    }

    private static void activateGroups(ReadableObj input, ObjFace face, WritableObj output) {
        String activatedMaterialGroupName;
        Set<String> activatedGroupNames = input.getActivatedGroupNames(face);
        if (activatedGroupNames != null) {
            output.setActiveGroupNames(activatedGroupNames);
        }
        if ((activatedMaterialGroupName = input.getActivatedMaterialGroupName(face)) != null) {
            output.setActiveMaterialGroupName(activatedMaterialGroupName);
        }
    }

    public static String createInfoString(ReadableObj obj) {
        ObjGroup objGroup;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("Obj:\n");
        sb.append("    mtlFileNames     : " + obj.getMtlFileNames() + "\n");
        sb.append("    numVertices      : " + obj.getNumVertices() + "\n");
        sb.append("    numTexCoords     : " + obj.getNumTexCoords() + "\n");
        sb.append("    numNormals       : " + obj.getNumNormals() + "\n");
        sb.append("    numFaces         : " + obj.getNumFaces() + "\n");
        sb.append("    numGroups        : " + obj.getNumGroups() + "\n");
        for (i = 0; i < obj.getNumGroups(); ++i) {
            objGroup = obj.getGroup(i);
            sb.append("        Group " + i + ":\n");
            sb.append("            name    : " + objGroup.getName() + "\n");
            sb.append("            numFaces: " + objGroup.getNumFaces() + "\n");
        }
        sb.append("    numMaterialGroups: " + obj.getNumMaterialGroups() + "\n");
        for (i = 0; i < obj.getNumMaterialGroups(); ++i) {
            objGroup = obj.getMaterialGroup(i);
            sb.append("        MaterialGroup " + i + ":\n");
            sb.append("            name    : " + objGroup.getName() + "\n");
            sb.append("            numFaces: " + objGroup.getNumFaces() + "\n");
        }
        return sb.toString();
    }

    private ObjUtils() {
    }

    private static interface PropertyIndexAccessor {
        public int getPropertyIndex(ReadableObj var1, ObjFace var2, int var3);

        public boolean hasProperty(ObjFace var1);
    }
}

