/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rscpl.gui;

import cd4017be.lib.Gui.comp.FormatText;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.Slider;
import cd4017be.lib.Gui.comp.TextField;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.circuit.Circuit;
import cd4017be.rscpl.util.StateBuffer;
import java.util.Arrays;
import java.util.function.IntConsumer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;

public class StateEditor
extends GuiCompGroup {
    private final int maxVar;
    public final String[] keys;
    private StateBuffer state;
    public final Circuit circuit;
    public final IntConsumer set;
    public final boolean editIO;
    public boolean hex;
    int scroll;

    public static StateEditor of(GuiFrame parent, Circuit circuit, String[] ioLabels, int max, IntConsumer set, boolean editIO) {
        StateBuffer state = circuit.getState();
        Object[] keys = state.nbt.func_150296_c().toArray(new String[state.nbt.func_186856_d()]);
        Arrays.sort(keys);
        return new StateEditor(parent, circuit, state, (String[])keys, ioLabels, Math.min(max, keys.length), set, editIO);
    }

    private StateEditor(GuiFrame parent, Circuit circuit, StateBuffer state, String[] keys, String[] ioLabels, int n, IntConsumer set, boolean editIO) {
        super((GuiCompGroup)parent, 168, 19 + (circuit.inputs.length + circuit.outputs.length + n) * 9 + (n > 0 ? 12 : 0), 2 * (circuit.inputs.length + circuit.outputs.length + n) + 1);
        parent.extendBy((GuiCompGroup)this);
        this.circuit = circuit;
        this.state = circuit.getState();
        this.set = set;
        this.keys = keys;
        this.maxVar = n;
        this.editIO = editIO;
        int y = 12;
        int in = circuit.inputs.length;
        int i = 0;
        while (i < in) {
            String label = ioLabels[i];
            int idx = i;
            new FormatText((GuiCompGroup)this, 70, 7, 8, y + 1, "\\" + label.replace("%", "%%"), null).color(-16777089);
            if (editIO) {
                new TextField((GuiCompGroup)this, 70, 7, 90, y + 1, 16, () -> Integer.toString(this.circuit.inputs[idx], this.hex ? 16 : 10), t -> {
                    try {
                        int v = Integer.parseInt(t, this.hex ? 16 : 10);
                        if (v == circuit.inputs[idx]) {
                            return;
                        }
                        circuit.inputs[idx] = v;
                        set.accept(-1 - idx);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
            } else {
                new FormatText((GuiCompGroup)this, 70, 7, 90, y + 1, "\\%s", () -> new Object[]{Integer.toString(this.circuit.inputs[idx], this.hex ? 16 : 10)});
            }
            ++i;
            y += 9;
        }
        int out = circuit.outputs.length;
        int i2 = 0;
        while (i2 < out) {
            String label = ioLabels[in + i2];
            int idx = i2++;
            new FormatText((GuiCompGroup)this, 70, 7, 8, y + 1, "\\" + label.replace("%", "%%"), null).color(-16744704);
            new FormatText((GuiCompGroup)this, 70, 7, 90, y + 1, "\\%s", () -> new Object[]{Integer.toString(circuit.outputs[idx], this.hex ? 16 : 10)});
            y += 9;
        }
        y += 12;
        if (keys.length > n) {
            new Slider((GuiCompGroup)this, 8, 12, n * 9 - 2, 152, y + 1, 178, 0, false, () -> this.scroll, v -> {
                this.scroll = (int)Math.round(v);
            }, null, 0.0, (double)(keys.length - n));
        }
        i2 = 0;
        while (i2 < n) {
            int idx = i2++;
            new FormatText((GuiCompGroup)this, 70, 7, 8, y + 1, "\\%s", () -> new Object[]{keys[idx + this.scroll]});
            new TextField((GuiCompGroup)this, 70, 7, 80, y + 1, 1024, () -> this.getValue(idx), t -> this.setValue(idx, (String)t));
            y += 9;
        }
    }

    private String getValue(int i) {
        return StateEditor.toString(this.state.nbt.func_74781_a(this.keys[i += this.scroll]), this.hex);
    }

    private static String toString(NBTBase nbt, boolean hex) {
        switch (nbt.func_74732_a()) {
            case 1: {
                return String.format(hex ? "%02X" : "%d", ((NBTPrimitive)nbt).func_150290_f());
            }
            case 2: {
                return String.format(hex ? "%04X" : "%d", ((NBTPrimitive)nbt).func_150289_e());
            }
            case 3: {
                return String.format(hex ? "%08X" : "%d", ((NBTPrimitive)nbt).func_150287_d());
            }
            case 4: {
                return String.format(hex ? "%016X" : "%d", ((NBTPrimitive)nbt).func_150291_c());
            }
            case 5: {
                return String.format(hex ? "%a" : "%s", Float.valueOf(((NBTPrimitive)nbt).func_150288_h()));
            }
            case 6: {
                return String.format(hex ? "%a" : "%s", ((NBTPrimitive)nbt).func_150286_g());
            }
            case 7: {
                byte[] arr = ((NBTTagByteArray)nbt).func_150292_c();
                int l = arr.length;
                int ll = hex ? Integer.toHexString(l - 1).length() : Integer.toString(l - 1).length();
                String fmt = hex ? "%0" + ll + "x:%02x " : "%d:%d ";
                StringBuilder sb = new StringBuilder((ll + 3) * l);
                for (int j = 0; j < l; ++j) {
                    sb.append(String.format(fmt, j, arr[j] & 0xFF));
                }
                sb.deleteCharAt(sb.length() - 1);
                return sb.toString();
            }
            case 11: {
                int[] arr = ((NBTTagIntArray)nbt).func_150302_c();
                int l = arr.length;
                int ll = hex ? Integer.toHexString(l - 1).length() : Integer.toString(l - 1).length();
                String fmt = hex ? "%0" + ll + "x:%08x " : "%d:%d ";
                StringBuilder sb = new StringBuilder((ll + (hex ? 8 : 5)) * l);
                for (int j = 0; j < l; ++j) {
                    sb.append(String.format(fmt, j, arr[j]));
                }
                sb.deleteCharAt(sb.length() - 1);
                return sb.toString();
            }
            case 9: {
                NBTTagList list = (NBTTagList)nbt;
                int l = list.func_74745_c();
                int ll = hex ? Integer.toHexString(l - 1).length() : Integer.toString(l - 1).length();
                String fmt = hex ? "%0" + ll + "x:%s " : "%d:%s ";
                StringBuilder sb = new StringBuilder();
                for (int j = 0; j < l; ++j) {
                    sb.append(String.format(fmt, j, StateEditor.toString(list.func_179238_g(j), hex)));
                }
                sb.deleteCharAt(sb.length() - 1);
                return sb.toString();
            }
        }
        return nbt.toString();
    }

    private void setValue(int i, String t) {
        String key = this.keys[i += this.scroll];
        try {
            this.state.nbt.func_74782_a(key, this.fromString(this.state.nbt.func_74781_a(key), t, this.hex ? 16 : 10));
            this.circuit.setState(this.state);
            this.set.accept(i);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private NBTBase fromString(NBTBase nbt, String t, int rad) {
        switch (nbt.func_74732_a()) {
            case 1: {
                return new NBTTagByte((byte)StateEditor.parseNumber(t, 127L, rad));
            }
            case 2: {
                return new NBTTagShort((short)StateEditor.parseNumber(t, 32767L, rad));
            }
            case 3: {
                return new NBTTagInt((int)StateEditor.parseNumber(t, Integer.MAX_VALUE, rad));
            }
            case 4: {
                return new NBTTagLong(StateEditor.parseNumber(t, Long.MAX_VALUE, rad));
            }
            case 5: {
                return new NBTTagFloat(Float.parseFloat(t));
            }
            case 6: {
                return new NBTTagDouble(Double.parseDouble(t));
            }
            case 7: {
                byte[] arr = ((NBTTagByteArray)nbt).func_150292_c();
                int p = t.indexOf(58);
                int q = -1;
                while (p >= 0) {
                    int j = Integer.parseInt(t.substring(q + 1, p), rad);
                    if (j < arr.length) {
                        q = t.indexOf(32, p);
                        if (q < 0) {
                            q = t.length();
                        }
                        arr[j] = (byte)Integer.parseInt(t.substring(p + 1, q), rad);
                    }
                    p = t.indexOf(58, p + 1);
                }
                break;
            }
            case 11: {
                int[] arr = ((NBTTagIntArray)nbt).func_150302_c();
                int p = t.indexOf(58);
                int q = -1;
                while (p >= 0) {
                    int j = Integer.parseInt(t.substring(q + 1, p), rad);
                    if (j < arr.length) {
                        q = t.indexOf(32, p);
                        if (q < 0) {
                            q = t.length();
                        }
                        arr[j] = Integer.parseInt(t.substring(p + 1, q), rad);
                    }
                    p = t.indexOf(58, p + 1);
                }
                break;
            }
            case 9: {
                NBTTagList list = (NBTTagList)nbt;
                int p = t.indexOf(58);
                int q = -1;
                while (p >= 0) {
                    int j = Integer.parseInt(t.substring(q + 1, p), rad);
                    if (j < list.func_74745_c()) {
                        q = t.indexOf(32, p);
                        if (q < 0) {
                            q = t.length();
                        }
                        list.func_150304_a(j, this.fromString(list.func_179238_g(j), t.substring(p + 1, q), rad));
                    }
                    p = t.indexOf(58, p + 1);
                }
                break;
            }
        }
        return nbt;
    }

    private static long parseNumber(String t, long max, int rad) {
        long l;
        if (t.isEmpty()) {
            throw new NumberFormatException();
        }
        if (rad == 16 || t.charAt(0) == '+') {
            l = Long.parseUnsignedLong(t, rad);
            if (max != Long.MAX_VALUE && (l < 0L || l > max * 2L + 1L)) {
                throw new NumberFormatException();
            }
        } else {
            l = Long.parseLong(t, rad);
            if (l > max || l < -1L - max) {
                throw new NumberFormatException();
            }
        }
        return l;
    }

    public void drawBackground(int mx, int my, float t) {
        int y = this.y;
        this.drawRect(this.x, y, 0, 165, 168, 12);
        y += 12;
        int n = this.circuit.inputs.length;
        while (n > 0) {
            this.drawRect(this.x, y, 0, this.editIO ? 147 : 81, 168, 9);
            --n;
            y += 9;
        }
        n = this.circuit.outputs.length;
        while (n > 0) {
            this.drawRect(this.x, y, 0, 156, 168, 9);
            --n;
            y += 9;
        }
        if (this.maxVar > 0) {
            int m = this.maxVar * 9;
            int m2 = m / 2;
            this.drawRect(this.x, y, 0, 165, 168, 12 + m - m2);
            this.drawRect(this.x, y + 12 + m - m2, 0, 249 - m2, 168, 7 + m2);
            String title = TooltipUtil.translate((String)"gui.rs_ctr.state.name");
            this.drawNow();
            this.fontRenderer.func_78276_b(title, this.x + (this.w - this.fontRenderer.func_78256_a(title)) / 2, y + 2, 0x404040);
        } else {
            this.drawRect(this.x, y, 0, 249, 168, 7);
            this.drawNow();
        }
        String title = TooltipUtil.translate((String)"gui.rs_ctr.state.io");
        this.fontRenderer.func_78276_b(title, this.x + (this.w - this.fontRenderer.func_78256_a(title)) / 2, this.y + 2, 0x404040);
        super.drawBackground(mx, my, t);
    }

    public void update() {
        this.state = this.circuit.getState();
    }
}

