/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rscpl.gui;

import cd4017be.rscpl.editor.Gate;
import cd4017be.rscpl.editor.Pin;
import cd4017be.rscpl.editor.TraceNode;

public class PinRef {
    public final int gate;
    public final int pin;
    public final int trace;
    public final int x;
    public final int y;
    public PinRef link;

    public PinRef(Pin out) {
        Gate g = out.gate;
        this.gate = g.index;
        this.pin = out.idx;
        this.trace = -1;
        this.x = g.rasterX + Math.max(0, g.type.width);
        this.y = g.rasterY + g.type.getOutputHeight(this.pin);
        this.link = null;
    }

    public PinRef(Gate gate, int pin) {
        Pin out;
        this.gate = gate.index;
        this.pin = pin;
        this.trace = 0;
        this.x = gate.rasterX - Math.min(0, gate.type.width);
        this.y = gate.rasterY + gate.type.getInputHeight(pin);
        TraceNode tn = gate.traces[pin];
        this.link = tn == null ? ((out = gate.getInput(pin)) != null ? new PinRef(out) : null) : new PinRef(tn, 1);
    }

    public PinRef(TraceNode tn, int depth) {
        Pin out;
        this.gate = tn.owner.index;
        this.pin = tn.pin;
        this.trace = depth;
        this.x = tn.rasterX;
        this.y = tn.rasterY;
        this.link = tn.next == null ? ((out = tn.owner.getInput(this.pin)) != null ? new PinRef(out) : null) : new PinRef(tn.next, depth + 1);
    }

    public PinRef(PinRef ref, int x, int y) {
        this.gate = ref.gate;
        this.pin = ref.pin;
        this.trace = ref.trace + 1;
        this.x = x;
        this.y = y;
        this.link = ref.link;
    }

    public int hashCode() {
        return this.x & 0xFFFF | this.y << 16;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PinRef)) {
            return false;
        }
        PinRef p = (PinRef)o;
        return this.gate == p.gate && this.pin == p.pin && this.trace == p.trace;
    }
}

