/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rscpl.gui;

import cd4017be.rs_ctr.Main;
import cd4017be.rscpl.editor.BoundingBox2D;
import cd4017be.rscpl.editor.GateType;
import java.util.ArrayList;
import java.util.List;

public class Category {
    public final String name;
    public final List<BoundingBox2D<GateType>> instructions = new ArrayList<BoundingBox2D<GateType>>();
    private int lastWidth = 0;

    public Category(String name) {
        this.name = name;
    }

    public <T extends GateType> T[] add(T ... types) {
        for (T t : types) {
            this.instructions.add(new BoundingBox2D<T>(t, 0, 0, Math.abs(((GateType)t).width) + 1, ((GateType)t).height + 1));
        }
        return types;
    }

    public void arrange(int width, int height) {
        if (width == this.lastWidth) {
            return;
        }
        int x = 0;
        int y = 0;
        int my = Integer.MAX_VALUE;
        int l = this.instructions.size();
        for (int i = 0; i < l; ++i) {
            BoundingBox2D<GateType> bb = this.instructions.get(i);
            bb.move(x - bb.x0, y - bb.y0);
            BoundingBox2D<?> b = this.collision(bb, i);
            while (b != null) {
                if (b.y1 < my) {
                    my = b.y1;
                }
                bb.move(b.x1 - bb.x0, 0);
                b = this.collision(bb, i);
            }
            x = bb.x1;
            if (x > width) {
                x = 0;
                y = my;
                my = Integer.MAX_VALUE;
                if (bb.x1 - bb.x0 > width) {
                    width = bb.x1 - bb.x0;
                    i = 0;
                    y = -1;
                    Main.LOG.warn("Gate {} is too wide for tab area! retrying arrangement with an increased width of {} ...", bb.owner, (Object)width);
                    continue;
                }
                --i;
                continue;
            }
            if (bb.y1 >= my) continue;
            my = bb.y1;
        }
        if (my > height) {
            Main.LOG.warn("Gate arrangement for tab {} exceeded height {} by {}!", (Object)this.name, (Object)height, (Object)my);
        }
        this.lastWidth = width;
    }

    private BoundingBox2D<?> collision(BoundingBox2D<?> box, int count) {
        for (int i = 0; i < count; ++i) {
            BoundingBox2D<GateType> b = this.instructions.get(i);
            if (!b.overlapsWith(box)) continue;
            return b;
        }
        return null;
    }

    public GateType get(int x, int y) {
        for (BoundingBox2D<GateType> bb : this.instructions) {
            if (!bb.isPointInside(x, y)) continue;
            return (GateType)bb.owner;
        }
        return null;
    }

    public String getIcon() {
        return this.name;
    }
}

