/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rscpl.editor;

import cd4017be.lib.util.Utils;
import cd4017be.rscpl.editor.BoundingBox2D;
import cd4017be.rscpl.editor.GateType;
import cd4017be.rscpl.editor.InvalidSchematicException;
import cd4017be.rscpl.editor.Pin;
import cd4017be.rscpl.editor.TraceNode;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.Type;

public class Gate {
    public final GateType type;
    public final int index;
    protected final Pin[] inputs;
    public final Pin[] outputs;
    public byte check = 0;
    public int rasterX;
    public int rasterY;
    public String label = "";
    public final TraceNode[] traces;

    public Gate(GateType type, int index, int in, int out) {
        this.type = type;
        this.index = index;
        this.inputs = new Pin[in];
        this.outputs = new Pin[out];
        for (int i = 0; i < this.outputs.length; ++i) {
            this.outputs[i] = new Pin(this, i);
        }
        this.traces = new TraceNode[this.inputs.length];
    }

    public int inputCount() {
        return this.inputs.length;
    }

    public Pin getInput(int pin) {
        return this.inputs[pin];
    }

    public void setInput(int pin, Pin op) {
        Pin old = this.inputs[pin];
        if (old == op) {
            return;
        }
        Pair p = Pair.of((Object)this, (Object)pin);
        if (old != null) {
            old.receivers.remove(p);
        }
        this.inputs[pin] = op;
        if (op != null) {
            op.receivers.add((Pair<Gate, Integer>)p);
        }
    }

    public void checkValid() throws InvalidSchematicException {
        if (this.check > 0) {
            return;
        }
        this.check = (byte)-1;
        for (Pin out : this.outputs) {
            out.node = null;
        }
        Pin[] inputs = this.inputs;
        int l = inputs.length;
        for (int i = 0; i < l; ++i) {
            Pin pin = inputs[i];
            if (pin != null) {
                if (!this.type.isInputTypeValid(i, pin.getOutType())) {
                    throw new InvalidSchematicException(2, this, i);
                }
                Gate gate = pin.gate;
                if (gate.isIndependent(pin.idx)) continue;
                if (gate.check < 0) {
                    throw new InvalidSchematicException(1, this, i);
                }
                gate.checkValid();
                continue;
            }
            if (this.type.isInputTypeValid(i, Type.VOID_TYPE)) continue;
            throw new InvalidSchematicException(3, this, i);
        }
        this.check = 1;
    }

    protected boolean isIndependent(int out) {
        return false;
    }

    public void read(ByteBuf data) {
        this.setPosition(data.readUnsignedByte(), data.readUnsignedByte());
        for (int i = 0; i < this.traces.length; ++i) {
            TraceNode tn = new TraceNode(null, i);
            int n = data.readUnsignedByte();
            if (n == 0) {
                tn.rasterX = 256;
                tn.rasterY = 256;
            } else {
                tn.rasterX = data.readUnsignedByte();
                tn.rasterY = data.readUnsignedByte();
            }
            this.traces[i] = tn;
            while (--n > 0) {
                tn = tn.next = new TraceNode(this, i);
                tn.rasterX = data.readUnsignedByte();
                tn.rasterY = data.readUnsignedByte();
            }
        }
        this.label = data.readCharSequence((int)data.readUnsignedByte(), Utils.UTF8).toString();
    }

    public void write(ByteBuf data) {
        int i;
        data.writeByte(this.rasterX);
        data.writeByte(this.rasterY);
        for (i = 0; i < this.traces.length; ++i) {
            Pin op = this.inputs[i];
            int p = data.writerIndex();
            int n = 1;
            data.writeByte(0);
            data.markWriterIndex();
            if (op == null) {
                data.writeByte(-1);
                data.writeByte(-1);
            } else {
                data.writeByte(op.gate.index);
                data.writeByte(op.idx);
            }
            TraceNode tn = this.traces[i];
            while (tn != null) {
                data.writeByte(tn.rasterX);
                data.writeByte(tn.rasterY);
                tn = tn.next;
                ++n;
            }
            if (op != null || n > 1) {
                data.setByte(p, n);
                continue;
            }
            data.resetWriterIndex();
        }
        i = data.writeByte(0).writeCharSequence((CharSequence)this.label, Utils.UTF8);
        data.setByte(data.writerIndex() - i - 1, i);
    }

    public boolean writeCfg(ByteBuf data) {
        return false;
    }

    public boolean readCfg(ByteBuf data) {
        return false;
    }

    public void reconnect(IntFunction<Gate> indexTable) {
        for (int i = 0; i < this.traces.length; ++i) {
            TraceNode tn = this.traces[i];
            if (tn == null || tn.owner != null) continue;
            Gate g = indexTable.apply(tn.rasterX);
            this.setInput(i, g == null || g.outputs.length <= tn.rasterY ? null : g.outputs[tn.rasterY]);
            this.traces[i] = tn.next;
        }
    }

    public void remove() {
        for (int i = 0; i < this.inputs.length; ++i) {
            this.setInput(i, null);
        }
        for (Pin o : this.outputs) {
            for (Pair<Gate, Integer> p : o.receivers) {
                ((Gate)p.getLeft()).inputs[((Integer)p.getRight()).intValue()] = null;
            }
            o.receivers.clear();
        }
    }

    public void setPosition(int x, int y) {
        this.rasterX = x;
        this.rasterY = y;
    }

    public BoundingBox2D<Gate> getBounds() {
        return new BoundingBox2D<Gate>(this, this.rasterX, this.rasterY, Math.abs(this.type.width), this.type.height);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(this.index)).append(' ').append(this.type);
        if (!this.label.isEmpty()) {
            sb.append(" \"").append(this.label).append('\"');
        }
        return sb.toString();
    }

    public TraceNode getTrace(int pin, int trace) {
        TraceNode tn = this.traces[pin];
        while (trace > 0 && tn != null) {
            tn = tn.next;
            --trace;
        }
        return tn;
    }
}

