/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rscpl.compile;

import cd4017be.rscpl.compile.Dep;
import cd4017be.rscpl.compile.NodeCompiler;
import java.util.ArrayList;
import java.util.HashSet;
import org.objectweb.asm.Type;

public class Node {
    public final NodeCompiler code;
    final Object param;
    final Dep[] deps;
    final ArrayList<Dep> users;
    final int order;
    int localIdx = -1;
    int remUses;
    Node commonUser;

    public Node(NodeCompiler code, Node ... inputs) {
        this(code, (Object)null, inputs);
    }

    public Node(NodeCompiler code, Object param, Node ... inputs) {
        this.code = code;
        this.param = param;
        this.users = new ArrayList(1);
        this.deps = new Dep[inputs.length];
        int order = -1;
        for (int i = 0; i < inputs.length; ++i) {
            Node n = inputs[i];
            if (n == null) continue;
            this.deps[i] = new Dep(n, this, code.getInType(i));
            if (n.order <= order) continue;
            order = n.order;
        }
        this.order = order + 1;
    }

    int getNumOfUsers() {
        int n = 0;
        for (Dep d : this.users) {
            if (d.type == Type.VOID_TYPE) continue;
            ++n;
        }
        this.remUses = n;
        return this.remUses;
    }

    Node getCommonUser() {
        if (this.commonUser != null) {
            return this.commonUser;
        }
        if (this.users.size() == 1) {
            this.commonUser = this.users.get((int)0).dst;
            return this.commonUser;
        }
        HashSet<Node> set = new HashSet<Node>();
        for (Dep u : this.users) {
            set.add(u.dst);
        }
        int last = this.order + 1;
        while (set.size() > 1) {
            Node lowest = null;
            int lvl = Integer.MAX_VALUE;
            for (Node n : set) {
                int l = n.order;
                if (l >= lvl) continue;
                lvl = l;
                lowest = n;
                if (l != last) continue;
                break;
            }
            last = lvl;
            set.remove(lowest);
            set.add(lowest.getCommonUser());
        }
        return (Node)set.iterator().next();
    }
}

