/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rscpl.compile;

import cd4017be.rs_ctr.Main;
import cd4017be.rscpl.compile.CompiledProgram;
import cd4017be.rscpl.compile.MethodCompiler;
import cd4017be.rscpl.compile.Node;
import cd4017be.rscpl.editor.Gate;
import cd4017be.rscpl.editor.InvalidSchematicException;
import cd4017be.rscpl.graph.IArrayVar;
import cd4017be.rscpl.graph.IEndpoint;
import cd4017be.rscpl.graph.IReadVar;
import cd4017be.rscpl.graph.IVariable;
import cd4017be.rscpl.graph.IWriteVar;
import cd4017be.rscpl.util.IStateSerializable;
import cd4017be.rscpl.util.StateBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class Compiler<P extends CompiledProgram>
implements MethodCompiler {
    public static final int[] TYPE2ARRAY = new int[]{0, 4, 5, 8, 9, 10, 6, 11, 7};
    public static final String D_STATE_BUFFER = Type.getDescriptor(StateBuffer.class);
    public static final String C_STATE_BUFFER = Type.getInternalName(StateBuffer.class);
    public static final String D_STRING = Type.getDescriptor(String.class);
    public final String C_SUPER;
    public final String[] C_INTERFACES;
    public String C_THIS;
    protected final boolean stateSerialize;

    public Compiler(Class<?> extend, Class<?> ... implement) {
        this.C_SUPER = Type.getInternalName(extend);
        this.C_INTERFACES = new String[implement.length];
        boolean ss = IStateSerializable.class.isAssignableFrom(extend);
        for (int i = 0; i < implement.length; ++i) {
            Class<?> c = implement[i];
            this.C_INTERFACES[i] = Type.getInternalName(c);
            ss |= IStateSerializable.class.isAssignableFrom(c);
        }
        this.stateSerialize = ss;
    }

    public Compiler<P> setName(String c_name) {
        this.C_THIS = c_name.replace('.', '/');
        return this;
    }

    public P compile(Collection<Gate> gates) throws InvalidSchematicException {
        long t = System.nanoTime();
        ArrayList<IEndpoint> ends = new ArrayList<IEndpoint>();
        HashMap<String, IVariable> variables = new HashMap<String, IVariable>();
        Compiler.checkAndSort(gates, ends, variables);
        P p = this.newProgram(gates);
        ClassWriter cw = this.getHeader();
        this.addVariables(cw, p.getState(), variables.values());
        ArrayList<Node> nodes = new ArrayList<Node>(ends.size());
        for (IEndpoint end : ends) {
            nodes.add(end.getEndNode());
        }
        MethodCompiler.addMethod(cw, this, nodes);
        cw.visitEnd();
        byte[] code = cw.toByteArray();
        p.setCode(code);
        Main.LOG.info("circuit compiled in {} ms: {} bytes", (Object)String.format("%.2f", Float.valueOf((float)(System.nanoTime() - t) * 1.0E-6f)), (Object)code.length);
        return p;
    }

    protected abstract P newProgram(Collection<Gate> var1) throws InvalidSchematicException;

    protected ClassWriter getHeader() {
        ClassWriter cw = new ClassWriter(2);
        cw.newUTF8(this.C_THIS);
        cw.visit(52, 4113, this.C_THIS, null, this.C_SUPER, this.C_INTERFACES);
        return cw;
    }

    protected void addVariables(ClassWriter cw, StateBuffer state, Collection<IVariable> variables) throws InvalidSchematicException {
        String desc;
        String name;
        for (IVariable var : variables) {
            cw.visitField(2 | (var instanceof IArrayVar ? 16 : 0), var.name(), var.type().getDescriptor(), null, null);
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, this.C_SUPER, "<init>", "()V", false);
        boolean hasArrays = false;
        for (IVariable var : variables) {
            if (!(var instanceof IArrayVar)) continue;
            mv.visitVarInsn(25, 0);
            Compiler.i_const(mv, ((IArrayVar)var).size());
            mv.visitIntInsn(188, TYPE2ARRAY[var.type().getElementType().getSort()]);
            mv.visitFieldInsn(181, this.C_THIS, var.name(), var.type().getDescriptor());
            hasArrays = true;
        }
        mv.visitInsn(177);
        mv.visitMaxs(hasArrays ? 2 : 1, 1);
        mv.visitEnd();
        if (!this.stateSerialize) {
            return;
        }
        for (IVariable var : variables) {
            if (!(var instanceof IReadVar)) continue;
            ((IReadVar)var).initState(state);
        }
        mv = cw.visitMethod(1, "getState", "()" + D_STATE_BUFFER, null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, C_STATE_BUFFER);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, C_STATE_BUFFER, "<init>", "()V", false);
        for (IVariable var : variables) {
            name = var.name();
            desc = var.type().getDescriptor();
            mv.visitLdcInsn((Object)name);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.C_THIS, name, desc);
            mv.visitMethodInsn(182, C_STATE_BUFFER, "set", "(" + D_STRING + desc + ")" + D_STATE_BUFFER, false);
        }
        mv.visitInsn(176);
        mv.visitMaxs(3, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "setState", "(" + D_STATE_BUFFER + ")V", null, null);
        mv.visitCode();
        for (IVariable var : variables) {
            name = var.name();
            desc = var.type().getDescriptor();
            if (var instanceof IArrayVar) {
                mv.visitVarInsn(25, 1);
                mv.visitLdcInsn((Object)name);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.C_THIS, name, desc);
                mv.visitMethodInsn(182, C_STATE_BUFFER, "getArr", "(" + D_STRING + desc + ")V", false);
                continue;
            }
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn((Object)name);
            mv.visitMethodInsn(182, C_STATE_BUFFER, Compiler.getter(desc), "(" + D_STRING + ")" + desc, false);
            mv.visitFieldInsn(181, this.C_THIS, name, desc);
        }
        mv.visitInsn(177);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
    }

    protected static void checkAndSort(Collection<Gate> gatesIn, List<IEndpoint> endsOut, Map<String, IVariable> variablesOut) throws InvalidSchematicException {
        ArrayList<IWriteVar> writes = new ArrayList<IWriteVar>();
        for (Gate g : gatesIn) {
            if (g == null) continue;
            g.check = 0;
            Compiler.addOperator(g, variablesOut, writes, endsOut);
        }
        for (IWriteVar r : writes) {
            IVariable op = variablesOut.get(r.name());
            if (op instanceof IReadVar) {
                r.link((IReadVar)op);
                continue;
            }
            if (op != null) continue;
            variablesOut.put(r.name(), r);
        }
        for (IEndpoint op : endsOut) {
            ((Gate)((Object)op)).checkValid();
        }
        Collections.sort(endsOut, (a, b) -> {
            Gate ga = (Gate)((Object)a);
            Gate gb = (Gate)((Object)b);
            return ga.type.name.compareTo(gb.type.name);
        });
    }

    protected static void addOperator(Gate op, Map<String, IVariable> reads, List<IWriteVar> writes, List<IEndpoint> ends) throws InvalidSchematicException {
        if (op == null) {
            return;
        }
        if (op instanceof IWriteVar) {
            IWriteVar w = (IWriteVar)((Object)op);
            Compiler.checkName(w);
            writes.add(w);
            w.link(null);
        }
        if (op instanceof IReadVar) {
            IReadVar r = (IReadVar)((Object)op);
            Compiler.checkName(r);
            if (reads.put(r.name(), r) != null) {
                throw new InvalidSchematicException(5, op, 0);
            }
        }
        if (op instanceof IEndpoint) {
            ends.add((IEndpoint)((Object)op));
        }
    }

    private static String getter(String desc) {
        switch (desc.charAt(0)) {
            case 'B': {
                return "getByte";
            }
            case 'S': {
                return "getShort";
            }
            case 'I': {
                return "getInt";
            }
            case 'F': {
                return "getFloat";
            }
            case 'J': {
                return "getLong";
            }
            case 'D': {
                return "getDouble";
            }
        }
        return null;
    }

    public static void i_const(MethodVisitor mv, int val) {
        if (val >= -1 && val <= 5) {
            mv.visitInsn(3 + val);
        } else if (val >= -128 && val < 127) {
            mv.visitIntInsn(16, val);
        } else if (val >= Short.MIN_VALUE && val < Short.MAX_VALUE) {
            mv.visitIntInsn(17, val);
        } else {
            mv.visitLdcInsn((Object)val);
        }
    }

    public static void checkName(IVariable op) throws InvalidSchematicException {
        block3: {
            String name = op.name();
            if (!name.isEmpty() && Character.isJavaIdentifierStart(name.charAt(0))) {
                for (int i = name.length() - 1; i > 0; --i) {
                    if (Character.isJavaIdentifierPart(name.charAt(i))) {
                        continue;
                    }
                    break block3;
                }
                return;
            }
        }
        throw new InvalidSchematicException(4, (Gate)((Object)op), 0);
    }
}

