/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity.part;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.comp.Button;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.TextField;
import cd4017be.lib.render.Util;
import cd4017be.lib.render.model.IntArrayModel;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr.ClientProxy;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.tileentity.part.Module;
import cd4017be.rs_ctr.tileentity.part.SignalModule;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class _7Segment
extends SignalModule
implements SignalHandler,
IInteractiveComponent.IBlockRenderComp {
    public static final String ID = "7seg";
    SignalHandler out;
    Decoding mode = Decoding.DEC_S;
    byte color;
    byte dots;
    byte digits;
    static final byte[] DIGITS = new byte[]{126, 24, 109, 61, 27, 55, 119, 28, 127, 63, 95, 115, 102, 121, 103, 71};
    static final int[] COLORS = new int[]{-16776961, -16744449, -16711681, -16711936, -4210944, -65536, -4259649, -4210753, -8421377, -8404993, -8388609, -8388737, -129, -32897, -32769, -1, -16777152, -16768960, -16760768, -16760832, -13619200, -12582912, -13631440, -13619152, -14671808, -14667712, -14663616, -14663648, -12566496, -12574688, -12574656, -12566464};
    static final int[] EXP10 = new int[]{1, 10, 100, 1000, 10000};

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void onPlaced(ItemStack stack, float x, float y) {
        int m = stack.func_77960_j();
        int h = m >> 1 & 1;
        int w = (m & 1) * (h + 1) + h;
        this.pos = (byte)((int)Math.floor((float)(4 - w) * x) & 3 | (int)Math.floor((float)(4 - h) * y) << 2 & 0xC | w << 4 | h << 6);
    }

    @Override
    public void init(List<MountedPort> ports, int id, Module.IPanel panel) {
        Orientation o = panel.getOrientation();
        double y = this.getY() + 0.125;
        double x = this.getX() + 0.125;
        ports.add(new MountedPort((IPortProvider)panel, id << 1, SignalHandler.class, false).setLocation(x + this.getW() - 0.25, y, 0.75, EnumFacing.NORTH, o).setName("port.rs_ctr.i"));
        if ((this.pos & 0x30) != 0) {
            ports.add(new MountedPort((IPortProvider)panel, id << 1 | 1, SignalHandler.class, true).setLocation(x, y, 0.75, EnumFacing.NORTH, o).setName("port.rs_ctr.o"));
        }
        this.digits = (byte)((this.pos >> 3 & 6) + 2 >> (this.pos >> 6 & 3));
        super.init(ports, id, panel);
    }

    @Override
    public ItemStack onRemove() {
        return new ItemStack((Item)Objects.seg7);
    }

    @Override
    public void setPortCallback(Object callback) {
        SignalHandler signalHandler = this.out = callback instanceof SignalHandler ? (SignalHandler)callback : null;
        if (this.out != null) {
            this.out.updateSignal(this.mode.remainder(this.value, this.digits));
        }
    }

    public void updateSignal(int val) {
        if (val == this.value) {
            return;
        }
        this.value = val;
        if (this.out != null) {
            this.out.updateSignal(this.mode.remainder(val, this.digits));
        }
        this.host.updateDisplay();
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74774_a("mode", (byte)this.mode.ordinal());
        nbt.func_74774_a("cfg", (byte)(this.dots & 0xF | this.color << 4));
        return nbt;
    }

    @Override
    protected void loadCfg(NBTTagCompound nbt) {
        this.mode = Decoding.values()[(nbt.func_74771_c("mode") & 0xFF) % 5];
        byte i = nbt.func_74771_c("cfg");
        this.dots = (byte)(i & 7);
        this.color = (byte)(i >> 4 & 0xF);
        super.loadCfg(nbt);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected GuiFrame initGuiFrame(ModularGui gui) {
        GuiFrame frame = new GuiFrame(gui, 128, 43, 1).title("gui.rs_ctr.dsp_cfg.name", 0.5f).background(new ResourceLocation("rs_ctr", "textures/gui/small.png"), 80, 97);
        new TextField((GuiCompGroup)frame, 112, 7, 8, 16, 20, () -> this.title, t -> gui.sendPkt(new Object[]{(byte)0, t})).allowFormat().tooltip("gui.rs_ctr.label");
        new Button((GuiCompGroup)frame, 9, 9, 52, 28, 16, () -> this.color, s -> gui.sendPkt(new Object[]{(byte)1, (byte)s})).texture(247, 72).tooltip("gui.rs_ctr.color");
        new Button((GuiCompGroup)frame, 26, 9, 65, 28, 5, () -> this.mode.ordinal(), s -> gui.sendPkt(new Object[]{(byte)2, (byte)s})).texture(221, 63).tooltip("gui.rs_ctr.encoder#");
        new Button((GuiCompGroup)frame, 26, 9, 96, 28, 5, () -> this.dots, s -> gui.sendPkt(new Object[]{(byte)3, (byte)s})).texture(221, 108).tooltip("gui.rs_ctr.dot");
        return frame;
    }

    public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        switch (pkt.readByte()) {
            case 0: {
                this.title = pkt.func_150789_c(32);
                break;
            }
            case 1: {
                this.color = pkt.readByte();
                break;
            }
            case 2: {
                this.mode = Decoding.values()[pkt.readUnsignedByte() % 5];
                if (this.out == null) break;
                this.out.updateSignal(this.mode.remainder(this.value, this.digits));
                break;
            }
            case 3: {
                this.dots = pkt.readByte();
                break;
            }
            default: {
                return;
            }
        }
        this.host.markDirty(2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected boolean refreshFTESR(Orientation o, double x, double y, double z, int light, BufferBuilder buffer) {
        light = this.brightness(light);
        int vi = buffer.func_178989_h();
        double h = this.getH() * 0.5;
        Vec3d p = o.rotate(new Vec3d(this.getX() + (double)(this.digits - 1) * h - 0.5, this.getY() - 0.5, 0.51)).func_72441_c(x + 0.5, y + 0.5, z + 0.5);
        Vec3d dx = o.X.func_186678_a(h);
        Vec3d dy = o.Y.func_186678_a(h / 1.5);
        int color = COLORS[this.color & 0xF];
        int code = this.mode.decode(this.value, this.digits);
        if (this.dots > 0) {
            code |= 128 << (this.dots - 1) * 8;
        }
        for (int i = this.digits - 1; i >= 0; --i) {
            if (i == 0 && this.mode.sign) {
                buffer.func_178981_a(Util.texturedRect((Vec3d)p, (Vec3d)dx, (Vec3d)dy.func_186678_a(2.0), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_7seg, (float)12.0f, (float)((code + 1) * 4)), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_7seg, (float)15.0f, (float)(code * 4)), (int)color, (int)light));
                continue;
            }
            int u = (code & 3) * 3;
            int v = code & 0xC;
            buffer.func_178981_a(Util.texturedRect((Vec3d)p.func_178787_e(dy), (Vec3d)dx, (Vec3d)dy, (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_7seg, (float)u, (float)(v + 2)), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_7seg, (float)(u + 3), (float)v), (int)color, (int)light));
            u = ((code >>= 4) & 3) * 3;
            v = (code & 0xC) + 2;
            code >>= 4;
            buffer.func_178981_a(Util.texturedRect((Vec3d)p, (Vec3d)dx, (Vec3d)dy, (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_7seg, (float)u, (float)(v + 2)), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_7seg, (float)(u + 3), (float)v), (int)color, (int)light));
            p = p.func_178788_d(dx);
        }
        IntArrayModel m = new IntArrayModel(Util.extractData((BufferBuilder)buffer, (int)vi, (int)buffer.func_178989_h()), color, light);
        m.origin((float)x, (float)y, (float)z);
        this.renderCache = m;
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected int brightness(int light) {
        return light & 0xFF0000 | 0xF0;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(List<BakedQuad> quads) {
        Module.IPanel host = this.host;
        if (host == null) {
            return;
        }
        Orientation o = host.getOrientation();
        quads.add(new BakedQuad(Util.texturedRect((Vec3d)o.rotate(new Vec3d(this.getX() - 0.5, this.getY() - 0.5, 0.505)).func_72441_c(0.5, 0.5, 0.5), (Vec3d)o.X.func_186678_a(this.getW()), (Vec3d)o.Y.func_186678_a(this.getH() / 1.5), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_blank, (float)0.0f, (float)0.0f), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_blank, (float)16.0f, (float)16.0f), (int)-12632257, (int)0), -1, o.back, ClientProxy.t_blank, true, DefaultVertexFormats.field_176600_a));
    }

    @Override
    public Object getState(int id) {
        return id == 0 ? this.value : this.mode.remainder(this.value, this.digits);
    }

    static enum Decoding {
        RAW(false),
        RAW_S(true),
        DEC(false){

            @Override
            int decode(int val, int digits) {
                if (val < 0) {
                    if (val == Integer.MIN_VALUE) {
                        return 0;
                    }
                    val = -val;
                } else if (val == Integer.MAX_VALUE) {
                    return 0;
                }
                int code = DIGITS[val % 10];
                if (val < 10) {
                    return code;
                }
                code |= DIGITS[(val /= 10) % 10] << 8;
                if (val < 10) {
                    return code;
                }
                code |= DIGITS[(val /= 10) % 10] << 16;
                if (val < 10) {
                    return code;
                }
                return code | DIGITS[val / 10 % 10] << 24;
            }

            @Override
            int remainder(int val, int digits) {
                digits = EXP10[digits];
                return val < 0 ? (val <= -digits && val != Integer.MIN_VALUE ? val / digits : Integer.MIN_VALUE) : (val >= digits && val != Integer.MAX_VALUE ? val / digits : Integer.MAX_VALUE);
            }
        }
        ,
        DEC_S(true){

            @Override
            int decode(int val, int digits) {
                int code = 0;
                int s = digits - 1 << 3;
                if (val < 0) {
                    code = 2 << s;
                    if (val == Integer.MIN_VALUE) {
                        return code;
                    }
                    val = -val;
                } else if (val == Integer.MAX_VALUE) {
                    return code;
                }
                int i = 0;
                while (i < s) {
                    code |= DIGITS[val % 10] << i;
                    if (val < 10) {
                        return code;
                    }
                    i += 8;
                    val /= 10;
                }
                code |= 1 << s;
                if (val >= 2) {
                    code &= 3 << s;
                }
                return code;
            }
        }
        ,
        HEX(false){

            @Override
            int decode(int val, int digits) {
                int code = 0;
                int i = 0;
                while (i < digits) {
                    code |= DIGITS[val & 0xF] << (i << 3);
                    ++i;
                    val >>>= 4;
                }
                return code;
            }

            @Override
            int remainder(int val, int digits) {
                return val >>> (digits << 2);
            }
        };

        final boolean sign;

        private Decoding(boolean sign) {
            this.sign = sign;
        }

        int decode(int val, int digits) {
            return val;
        }

        int remainder(int val, int digits) {
            return val;
        }
    }
}

