/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity.part;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.comp.Button;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.TextField;
import cd4017be.lib.render.Util;
import cd4017be.lib.render.model.IntArrayModel;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.ClientProxy;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.tileentity.part.Module;
import cd4017be.rs_ctr.tileentity.part.SignalModule;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class Trigger
extends SignalModule
implements SignalHandler,
IInteractiveComponent.IBlockRenderComp {
    public static final String ID = "trigger";
    SignalHandler out = SignalHandler.NOP;
    String unit = "";
    int in;
    int on;
    int off;
    int increment = 1;
    int exp;

    public Trigger() {
        this.title = "Trigger";
    }

    public void updateSignal(int value) {
        this.in = value;
        if (this.on >= this.off ? (this.value == 0 ? value <= this.on : value > this.off) : (this.value == 0 ? value > this.on : value < this.off)) {
            return;
        }
        this.out.updateSignal(this.value ^= 0xFFFF);
        this.host.updateDisplay();
    }

    @Override
    public void setPortCallback(Object callback) {
        if (callback instanceof SignalHandler) {
            SignalHandler h = (SignalHandler)callback;
            h.updateSignal(this.value);
            this.out = h;
        } else {
            this.out = SignalHandler.NOP;
        }
    }

    @Override
    public void init(List<MountedPort> ports, int idx, Module.IPanel panel) {
        ports.add(new MountedPort((IPortProvider)panel, idx << 1, SignalHandler.class, false).setLocation(this.getX() + 0.375, this.getY() + 0.125, 0.75, EnumFacing.NORTH, panel.getOrientation()).setName("port.rs_ctr.i"));
        ports.add(new MountedPort((IPortProvider)panel, idx << 1 | 1, SignalHandler.class, true).setLocation(this.getX() + 0.125, this.getY() + 0.125, 0.75, EnumFacing.NORTH, panel.getOrientation()).setName("port.rs_ctr.o"));
        super.init(ports, idx, panel);
    }

    @Override
    public boolean onInteract(EntityPlayer player, boolean hit, EnumFacing side, Vec3d aim) {
        if (super.onInteract(player, hit, side, aim)) {
            return true;
        }
        Orientation o = this.host.getOrientation();
        int s = this.selection(aim, o);
        if (s == 0) {
            return false;
        }
        int d = this.increment(aim, o);
        if (s == 2) {
            this.on += d;
        } else {
            this.off += d;
        }
        this.updateSignal(this.in);
        this.host.updateDisplay();
        return true;
    }

    @Override
    public Pair<Vec3d, String> getDisplayText(Vec3d aim) {
        Module.IPanel host = this.host;
        if (host == null) {
            return null;
        }
        Orientation o = host.getOrientation();
        if (this.selection(aim, o) == 0) {
            return null;
        }
        double val = (double)this.increment(aim, o) * this.scale();
        return Pair.of((Object)aim, (Object)(TooltipUtil.formatNumber((double)val, (int)3, (double)1.0, (boolean)true, (boolean)true) + this.unit));
    }

    private int selection(Vec3d aim, Orientation o) {
        double d = aim.func_178786_a(0.5, 0.5, 0.5).func_72430_b(o.Y) + 0.5 - this.getY();
        if (d < 0.0 || d > 0.1875) {
            return 0;
        }
        return d < 0.09375 ? 1 : 2;
    }

    private int increment(Vec3d aim, Orientation o) {
        double dx = aim.func_178786_a(0.5, 0.5, 0.5).func_72430_b(o.X) + 0.5 - this.getX();
        return dx < 0.25 ? (dx < 0.125 ? -10 * this.increment : -this.increment) : (dx < 0.375 ? this.increment : 10 * this.increment);
    }

    private double scale() {
        if (this.exp < -12 || this.exp > 11) {
            return Double.NaN;
        }
        return TooltipUtil.ScaleUnits[(this.exp + 18) / 3] * TooltipUtil.exp10[Math.floorMod(this.exp, 3)];
    }

    @Override
    public void writeSync(PacketBuffer buf, boolean init) {
        buf.writeInt(this.on);
        buf.writeInt(this.off);
        buf.writeByte(this.value);
    }

    @Override
    public void readSync(PacketBuffer buf) {
        this.on = buf.readInt();
        this.off = buf.readInt();
        int val = buf.readByte() & 0xFFFF;
        if (val != this.value) {
            this.value = val;
            this.renderCache = null;
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74768_a("on", this.on);
        nbt.func_74768_a("off", this.off);
        nbt.func_74768_a("incr", this.increment);
        nbt.func_74774_a("exp", (byte)this.exp);
        nbt.func_74778_a("unit", this.unit);
        return nbt;
    }

    @Override
    protected void loadCfg(NBTTagCompound nbt) {
        super.loadCfg(nbt);
        this.on = nbt.func_74762_e("on");
        this.off = nbt.func_74762_e("off");
        this.increment = nbt.func_74762_e("incr");
        this.exp = nbt.func_74771_c("exp");
        this.unit = nbt.func_74779_i("unit");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected boolean refreshFTESR(Orientation o, double x, double y, double z, int light, BufferBuilder buffer) {
        light = this.brightness(light);
        int vi = buffer.func_178989_h();
        Vec3d p = o.rotate(new Vec3d(this.getX() - 0.5, this.getY() - 0.5, 0.51)).func_72441_c(x + 0.5, y + 0.5, z + 0.5);
        Vec3d dx = o.X.func_186678_a(0.0625);
        Vec3d dy = o.Y.func_186678_a(0.0625);
        Vec2f t0 = Util.getUV((TextureAtlasSprite)ClientProxy.t_blank, (float)0.0f, (float)0.0f);
        Vec2f t1 = Util.getUV((TextureAtlasSprite)ClientProxy.t_blank, (float)16.0f, (float)16.0f);
        buffer.func_178981_a(Util.texturedRect((Vec3d)p, (Vec3d)dx, (Vec3d)dy, (Vec2f)t0, (Vec2f)t1, (int)(this.value <= 0 ? -65536 : -13697024), (int)light));
        buffer.func_178981_a(Util.texturedRect((Vec3d)p.func_178787_e(dy.func_186678_a(1.5)), (Vec3d)dx, (Vec3d)dy, (Vec2f)t0, (Vec2f)t1, (int)(this.value > 0 ? -16776961 : -16777169), (int)light));
        IntArrayModel m = new IntArrayModel(Util.extractData((BufferBuilder)buffer, (int)vi, (int)buffer.func_178989_h()), -1, light);
        m.origin((float)x, (float)y, (float)z);
        this.renderCache = m;
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected int brightness(int light) {
        return light & 0xFF0000 | 0xF0;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(List<BakedQuad> quads) {
        Module.IPanel host = this.host;
        if (host == null) {
            return;
        }
        Orientation o = host.getOrientation();
        quads.add(new BakedQuad(Util.texturedRect((Vec3d)o.rotate(new Vec3d(this.getX() - 0.5, this.getY() - 0.5, 0.505)).func_72441_c(0.5, 0.5, 0.5), (Vec3d)o.X.func_186678_a(0.4375), (Vec3d)o.Y.func_186678_a(0.16666666666666666), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_blank, (float)0.0f, (float)0.0f), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_blank, (float)16.0f, (float)16.0f), (int)-12632257, (int)0), -1, o.back, ClientProxy.t_blank, true, DefaultVertexFormats.field_176600_a));
    }

    @Override
    public void drawText(FontRenderer fr) {
        int x = (this.pos & 3) * 32;
        int y = (3 - (this.pos >> 2 & 3)) * 32;
        int w = 64;
        fr.func_78276_b(this.title, x + (w - fr.func_78256_a(this.title)) / 2, ++y + 1, -16777216);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.005);
        double scale = this.scale();
        String s = TooltipUtil.formatNumber((double)((double)this.on * scale), (int)(6 - this.unit.length()), (int)0) + this.unit;
        fr.func_78276_b(s, x + (w - fr.func_78256_a(s)) / 2, y + 12, -4145152);
        s = TooltipUtil.formatNumber((double)((double)this.off * scale), (int)(6 - this.unit.length()), (int)0) + this.unit;
        fr.func_78276_b(s, x + (w - fr.func_78256_a(s)) / 2, y + 23, -4145152);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.005);
    }

    @Override
    protected GuiFrame initGuiFrame(ModularGui gui) {
        GuiFrame frame = new GuiFrame(gui, 128, 66, 7).title("gui.rs_ctr.dsp_cfg.name", 0.5f).background(new ResourceLocation("rs_ctr", "textures/gui/small.png"), 80, 31);
        new TextField((GuiCompGroup)frame, 112, 7, 8, 16, 20, () -> this.title, t -> gui.sendPkt(new Object[]{(byte)0, t})).allowFormat().tooltip("gui.rs_ctr.label");
        new TextField((GuiCompGroup)frame, 18, 7, 45, 29, 3, () -> this.unit, t -> gui.sendPkt(new Object[]{(byte)5, t})).tooltip("gui.rs_ctr.unit");
        new TextField((GuiCompGroup)frame, 56, 7, 64, 29, 12, () -> Integer.toString(this.increment), t -> {
            try {
                gui.sendPkt(new Object[]{(byte)1, Integer.parseInt(t)});
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }).tooltip("gui.rs_ctr.incr");
        new TextField((GuiCompGroup)frame, 64, 7, 56, 42, 12, () -> Integer.toString(this.on), t -> {
            try {
                gui.sendPkt(new Object[]{(byte)2, Integer.parseInt(t)});
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }).tooltip("gui.rs_ctr.thr_on");
        new TextField((GuiCompGroup)frame, 64, 7, 56, 51, 12, () -> Integer.toString(this.off), t -> {
            try {
                gui.sendPkt(new Object[]{(byte)3, Integer.parseInt(t)});
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }).tooltip("gui.rs_ctr.thr_off");
        new Button((GuiCompGroup)frame, 20, 9, 7, 28, 3, () -> Math.floorMod(this.exp, 3), s -> gui.sendPkt(new Object[]{(byte)4, (byte)(s + Math.floorDiv(this.exp, 3) * 3)})).texture(227, 36).tooltip("gui.rs_ctr.uscale");
        new Button((GuiCompGroup)frame, 9, 9, 31, 28, 8, () -> (this.exp + 12) / 3, s -> gui.sendPkt(new Object[]{(byte)4, (byte)(s * 3 - 12 + Math.floorMod(this.exp, 3))})).texture(247, 0).tooltip("gui.rs_ctr.uscale");
        return frame;
    }

    public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        switch (pkt.readByte()) {
            case 0: {
                this.title = pkt.func_150789_c(32);
                break;
            }
            case 1: {
                this.increment = pkt.readInt();
                break;
            }
            case 2: {
                this.on = pkt.readInt();
                this.updateSignal(this.in);
                break;
            }
            case 3: {
                this.off = pkt.readInt();
                this.updateSignal(this.in);
                break;
            }
            case 4: {
                this.exp = pkt.readByte();
                break;
            }
            case 5: {
                this.unit = pkt.func_150789_c(3);
                break;
            }
            default: {
                return;
            }
        }
        this.host.markDirty(2);
    }

    @Override
    public void onPlaced(ItemStack stack, float x, float y) {
        this.pos = (byte)(0x10 | (int)Math.floor((double)x * 3.0) & 3 | (int)Math.floor((double)y * 4.0) << 2 & 0xC);
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public ItemStack onRemove() {
        return new ItemStack((Item)Objects.trigger);
    }

    @Override
    public Object getState(int id) {
        return id == 0 ? this.in : this.value;
    }
}

