/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity.part;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.TextField;
import cd4017be.lib.render.Util;
import cd4017be.lib.render.model.IntArrayModel;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr.ClientProxy;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.tileentity.part.Module;
import cd4017be.rs_ctr.tileentity.part.SignalModule;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class Slider
extends SignalModule
implements IInteractiveComponent.IBlockRenderComp {
    public static final String ID = "slider";
    SignalHandler out;
    int max = 15;
    int min = 0;

    @Override
    public void init(List<MountedPort> ports, int idx, Module.IPanel panel) {
        ports.add(new MountedPort((IPortProvider)panel, idx << 1, SignalHandler.class, true).setLocation(0.125, 0.125 + this.getY(), 0.75, EnumFacing.NORTH, panel.getOrientation()).setName("port.rs_ctr.o"));
        super.init(ports, idx, panel);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74768_a("min", this.min);
        nbt.func_74768_a("max", this.max);
        return nbt;
    }

    @Override
    public void loadCfg(NBTTagCompound nbt) {
        this.min = nbt.func_74762_e("min");
        this.max = nbt.func_74762_e("max");
        super.loadCfg(nbt);
    }

    @Override
    public boolean onInteract(EntityPlayer player, boolean hit, EnumFacing side, Vec3d aim) {
        if (super.onInteract(player, hit, side, aim)) {
            return true;
        }
        this.value = this.value(aim, this.host.getOrientation());
        if (this.out != null) {
            this.out.updateSignal(this.value);
        }
        this.host.updateDisplay();
        return true;
    }

    @Override
    public Pair<Vec3d, String> getDisplayText(Vec3d aim) {
        Module.IPanel host = this.host;
        if (host == null) {
            return null;
        }
        Orientation o = host.getOrientation();
        int val = this.value(aim, o);
        aim = aim.func_178787_e(o.Y.func_186678_a(-0.375 + this.getY() - aim.func_178786_a(0.5, 0.5, 0.5).func_72430_b(o.Y)));
        return Pair.of((Object)aim, (Object)String.format("%d", val));
    }

    private int value(Vec3d aim, Orientation o) {
        aim = aim.func_178786_a(0.5, 0.5, 0.5);
        double v = (aim.func_72430_b(o.X) + 0.375) / 0.75;
        if (aim.func_72430_b(o.Y) + 0.25 >= this.getY()) {
            double f = 1.0 / (v - 0.5);
            v = ((double)this.value - (double)this.min) / ((double)this.max - (double)this.min);
            v = f < 0.0 ? (v -= Math.exp(f)) : (v += Math.exp(-f));
        }
        if (v < 0.0) {
            v = 0.0;
        } else if (v > 1.0) {
            v = 1.0;
        }
        return (int)Math.round((double)this.min + ((double)this.max - (double)this.min) * v);
    }

    @Override
    public void onPlaced(ItemStack stack, float x, float y) {
        this.pos = (byte)((int)Math.floor((double)y * 3.0) << 2 & 0xC | 0x70);
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public ItemStack onRemove() {
        return new ItemStack((Item)Objects.slider);
    }

    @Override
    public void setPortCallback(Object callback) {
        SignalHandler signalHandler = this.out = callback instanceof SignalHandler ? (SignalHandler)callback : null;
        if (this.out != null) {
            this.out.updateSignal(this.value);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected GuiFrame initGuiFrame(ModularGui gui) {
        GuiFrame frame = new GuiFrame(gui, 128, 53, 3).title("gui.rs_ctr.dsp_cfg.name", 0.5f).background(new ResourceLocation("rs_ctr", "textures/gui/small.png"), 80, 140);
        new TextField((GuiCompGroup)frame, 112, 7, 8, 16, 20, () -> this.title, t -> gui.sendPkt(new Object[]{(byte)0, t})).allowFormat().tooltip("gui.rs_ctr.label");
        new TextField((GuiCompGroup)frame, 64, 7, 56, 29, 12, () -> Integer.toString(this.max), t -> {
            try {
                gui.sendPkt(new Object[]{(byte)2, Integer.parseInt(t)});
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }).tooltip("gui.rs_ctr.max");
        new TextField((GuiCompGroup)frame, 64, 7, 56, 38, 12, () -> Integer.toString(this.min), t -> {
            try {
                gui.sendPkt(new Object[]{(byte)1, Integer.parseInt(t)});
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }).tooltip("gui.rs_ctr.min");
        return frame;
    }

    public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        switch (pkt.readByte()) {
            case 0: {
                this.title = pkt.func_150789_c(32);
                break;
            }
            case 1: {
                this.min = pkt.readInt();
                break;
            }
            case 2: {
                this.max = pkt.readInt();
                break;
            }
            default: {
                return;
            }
        }
        this.host.markDirty(3);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected boolean refreshFTESR(Orientation o, double x, double y, double z, int light, BufferBuilder buffer) {
        double f = ((double)this.value - (double)this.min) / ((double)this.max - (double)this.min);
        this.renderCache = new IntArrayModel(Util.texturedRect((Vec3d)o.rotate(new Vec3d(-0.421875 + f * 0.75, this.getY() - 0.4375, 0.51)).func_72441_c(0.5, 0.5, 0.5), (Vec3d)o.X.func_186678_a(0.09375), (Vec3d)o.Y.func_186678_a(0.25), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_dial, (float)2.0f, (float)14.0f), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_dial, (float)2.75f, (float)12.0f), (int)-1, (int)light), -1, light);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(List<BakedQuad> quads) {
        int i;
        Module.IPanel host = this.host;
        if (host == null) {
            return;
        }
        Orientation o = host.getOrientation();
        double y = this.getY() - 0.5;
        quads.add(new BakedQuad(Util.texturedRect((Vec3d)o.rotate(new Vec3d(-0.375, y + 0.125, 0.505)).func_72441_c(0.5, 0.5, 0.5), (Vec3d)o.X.func_186678_a(0.75), (Vec3d)o.Y.func_186678_a(0.0625), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_blank, (float)0.0f, (float)0.0f), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_blank, (float)16.0f, (float)16.0f), (int)-12632257, (int)0), -1, o.back, ClientProxy.t_blank, true, DefaultVertexFormats.field_176600_a));
        int color = -16777216;
        if (this.title.length() >= 2 && this.title.charAt(0) == '\u00a7' && (i = Minecraft.func_71410_x().field_71466_p.func_175064_b(Character.toLowerCase(this.title.charAt(1)))) != -1) {
            color |= i & 0xFF00 | i >> 16 & 0xFF | i << 16 & 0xFF0000;
        }
        quads.add(new BakedQuad(Util.texturedRect((Vec3d)o.rotate(new Vec3d(-0.3875, y + 0.25, 0.505)).func_72441_c(0.5, 0.5, 0.5), (Vec3d)o.X.func_186678_a(0.775), (Vec3d)o.Y.func_186678_a(0.125), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_dial, (float)0.0f, (float)16.0f), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_dial, (float)7.75f, (float)14.0f), (int)color, (int)0), -1, o.back, ClientProxy.t_dial, true, DefaultVertexFormats.field_176600_a));
    }
}

