/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity.part;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.comp.Button;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.TextField;
import cd4017be.lib.render.Util;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.ClientProxy;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.tileentity.part.Module;
import cd4017be.rs_ctr.tileentity.part.SignalModule;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class Scale
extends SignalModule
implements SignalHandler,
IInteractiveComponent.IBlockRenderComp {
    public static final String ID = "scale";
    double[] gains = new double[]{1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0};
    SignalHandler out = SignalHandler.NOP;
    String unit = "";
    long scale = 0x100000000L;
    double base = 1.0;
    int gain = 54;
    int in;

    public Scale() {
        this.title = "Scale";
    }

    @Override
    public void init(List<MountedPort> ports, int idx, Module.IPanel panel) {
        ports.add(new MountedPort((IPortProvider)panel, idx << 1, SignalHandler.class, false).setLocation(this.getX() + 0.375, this.getY() + 0.125, 0.75, EnumFacing.NORTH, panel.getOrientation()).setName("port.rs_ctr.i"));
        ports.add(new MountedPort((IPortProvider)panel, idx << 1 | 1, SignalHandler.class, true).setLocation(this.getX() + 0.125, this.getY() + 0.125, 0.75, EnumFacing.NORTH, panel.getOrientation()).setName("port.rs_ctr.o"));
        super.init(ports, idx, panel);
    }

    public void updateSignal(int value) {
        this.in = value;
        if ((value = (int)((long)value * this.scale >> 32)) == this.value) {
            return;
        }
        this.value = value;
        this.out.updateSignal(this.value);
    }

    @Override
    public void setPortCallback(Object callback) {
        if (callback instanceof SignalHandler) {
            SignalHandler h = (SignalHandler)callback;
            h.updateSignal(this.value);
            this.out = h;
        } else {
            this.out = SignalHandler.NOP;
        }
    }

    @Override
    public boolean onInteract(EntityPlayer player, boolean hit, EnumFacing side, Vec3d aim) {
        if (super.onInteract(player, hit, side, aim)) {
            return true;
        }
        int d = this.increment(aim, this.host.getOrientation());
        if (d == 0) {
            return false;
        }
        if (player.func_70093_af()) {
            this.gain = 54;
        }
        if ((d += this.gain & 0x7F) < 0) {
            d = 0;
        } else if (d > 107) {
            d = 107;
        }
        this.gain = this.gain & 0x80 | d;
        this.setScale();
        this.host.updateDisplay();
        return true;
    }

    @Override
    public Pair<Vec3d, String> getDisplayText(Vec3d aim) {
        Module.IPanel host = this.host;
        if (host == null) {
            return null;
        }
        int val = this.increment(aim, host.getOrientation());
        return val == 0 ? null : Pair.of((Object)aim, (Object)(val < 0 ? (val < -1 ? "--" : "-") : (val == 1 ? "+" : "++")));
    }

    private int increment(Vec3d aim, Orientation o) {
        double d = aim.func_178786_a(0.5, 0.5, 0.5).func_72430_b(o.Y) + 0.5 - this.getY();
        if (d < 0.0625 || d > 0.1875) {
            return 0;
        }
        d = aim.func_178786_a(0.5, 0.5, 0.5).func_72430_b(o.X) + 0.5 - this.getX();
        return d < 0.25 ? (d < 0.125 ? -9 : -1) : (d < 0.375 ? 1 : 9);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74780_a("base", this.base);
        nbt.func_74774_a("gain", (byte)this.gain);
        nbt.func_74778_a("unit", this.unit);
        return nbt;
    }

    @Override
    protected void loadCfg(NBTTagCompound nbt) {
        this.base = nbt.func_74769_h("base");
        this.gain = nbt.func_74771_c("gain");
        this.unit = nbt.func_74779_i("unit");
        this.setScale();
        super.loadCfg(nbt);
    }

    private void setScale() {
        this.scale = (this.gain & 0x80) == 0 ? (long)(this.base * 4.294967296E9 * this.gain()) : (long)(this.base * 4.294967296E9 / this.gain());
        this.updateSignal(this.in);
    }

    private double gain() {
        int gain = this.gain & 0x7F;
        return this.gains[gain % 9] * TooltipUtil.ScaleUnits[gain / 9];
    }

    @Override
    public void writeSync(PacketBuffer buf, boolean init) {
        buf.writeByte(this.gain);
    }

    @Override
    public void readSync(PacketBuffer buf) {
        this.gain = buf.readByte();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected boolean refreshFTESR(Orientation o, double x, double y, double z, int light, BufferBuilder buffer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(List<BakedQuad> quads) {
        Module.IPanel host = this.host;
        if (host == null) {
            return;
        }
        Orientation o = host.getOrientation();
        quads.add(new BakedQuad(Util.texturedRect((Vec3d)o.rotate(new Vec3d(this.getX() - 0.5 + 0.0625, this.getY() - 0.5, 0.505)).func_72441_c(0.5, 0.5, 0.5), (Vec3d)o.X.func_186678_a(0.375), (Vec3d)o.Y.func_186678_a(0.16666666666666666), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_blank, (float)0.0f, (float)0.0f), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_blank, (float)16.0f, (float)16.0f), (int)-12632257, (int)0), -1, o.back, ClientProxy.t_blank, true, DefaultVertexFormats.field_176600_a));
    }

    @Override
    public void drawText(FontRenderer fr) {
        int x = (this.pos & 3) * 32;
        int y = (3 - (this.pos >> 2 & 3)) * 32;
        int w = 64;
        fr.func_78276_b(this.title, x + (w - fr.func_78256_a(this.title)) / 2, ++y + 1, -16777216);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.005);
        String s = ((this.gain & 0x80) != 0 ? (char)'/' : '*') + TooltipUtil.formatNumber((double)this.gain(), (int)3, (int)0);
        fr.func_78276_b(s, x + (w - fr.func_78256_a(s)) / 2, y + 12, -4145152);
        fr.func_78276_b(this.unit, x + (w - fr.func_78256_a(this.unit)) / 2, y + 23, -4145152);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.005);
    }

    @Override
    protected GuiFrame initGuiFrame(ModularGui gui) {
        GuiFrame frame = new GuiFrame(gui, 80, 52, 4).title("gui.rs_ctr.dsp_cfg.name", 0.5f).background(new ResourceLocation("rs_ctr", "textures/gui/small.png"), 0, 204);
        new TextField((GuiCompGroup)frame, 64, 7, 8, 16, 20, () -> this.title, t -> gui.sendPkt(new Object[]{(byte)0, t})).allowFormat().tooltip("gui.rs_ctr.label");
        new TextField((GuiCompGroup)frame, 55, 7, 17, 37, 16, () -> this.unit, t -> gui.sendPkt(new Object[]{(byte)3, t})).allowFormat().tooltip("gui.rs_ctr.unit");
        new TextField((GuiCompGroup)frame, 64, 7, 8, 28, 12, () -> Double.toString(this.base), t -> {
            try {
                gui.sendPkt(new Object[]{(byte)1, Double.parseDouble(t)});
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }).tooltip("gui.rs_ctr.scale");
        new Button((GuiCompGroup)frame, 9, 9, 7, 36, 2, () -> this.gain >> 7 & 1, s -> gui.sendPkt(new Object[]{(byte)2, (byte)(this.gain ^ 0x80)})).texture(218, 36).tooltip("gui.rs_ctr.div#");
        return frame;
    }

    public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        switch (pkt.readByte()) {
            case 0: {
                this.title = pkt.func_150789_c(32);
                break;
            }
            case 1: {
                this.base = pkt.readDouble();
                this.setScale();
                break;
            }
            case 2: {
                this.gain = pkt.readByte();
                this.setScale();
                break;
            }
            case 3: {
                this.unit = pkt.func_150789_c(32);
                break;
            }
            default: {
                return;
            }
        }
        this.host.markDirty(2);
    }

    @Override
    public void onPlaced(ItemStack stack, float x, float y) {
        this.pos = (byte)(0x10 | (int)Math.floor((double)x * 3.0) & 3 | (int)Math.floor((double)y * 4.0) << 2 & 0xC);
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public ItemStack onRemove() {
        return new ItemStack((Item)Objects.scale);
    }

    @Override
    public Object getState(int id) {
        return id == 0 ? this.in : this.value;
    }
}

