/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity.part;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.comp.Button;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.Spinner;
import cd4017be.lib.Gui.comp.TextField;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.render.model.IntArrayModel;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.render.PortRenderer;
import cd4017be.rs_ctr.tileentity.part.Module;
import cd4017be.rs_ctr.tileentity.part.SignalModule;
import cd4017be.rs_ctr.tileentity.part._7Segment;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Lever
extends SignalModule
implements TickRegistry.ITickReceiver {
    public static final String ID = "lever";
    SignalHandler out;
    int onVal = 65535;
    int offVal = 0;
    byte color;

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void onPlaced(ItemStack stack, float x, float y) {
        this.pos = (byte)((int)Math.floor(x * 4.0f) & 3 | (int)Math.floor(y * 4.0f) << 2 & 0xC);
        this.color = (byte)((stack.func_77960_j() << 4) - 16);
        if (this.color < 0) {
            this.title = "ON";
        } else if (this.color >= 16) {
            this.offVal = 5;
        }
    }

    @Override
    public ItemStack onRemove() {
        return new ItemStack((Item)Objects.lever, 1, this.color + 16 >> 4);
    }

    @Override
    public void init(List<MountedPort> ports, int idx, Module.IPanel panel) {
        ports.add(new MountedPort((IPortProvider)panel, idx << 1, SignalHandler.class, true).setLocation(this.getX() + 0.125, this.getY() + 0.125, 0.75, EnumFacing.NORTH, panel.getOrientation()).setName("port.rs_ctr.o"));
        super.init(ports, idx, panel);
    }

    @Override
    public void onLoad(Module.IPanel host) {
        if (this.color >= 16 && this.value > 0 && !host.world().field_72995_K && this.host == null) {
            TickRegistry.instance.add((TickRegistry.ITickReceiver)this);
        }
        super.onLoad(host);
    }

    @Override
    public boolean onInteract(EntityPlayer player, boolean hit, EnumFacing side, Vec3d aim) {
        if (super.onInteract(player, hit, side, aim)) {
            return true;
        }
        if (hit) {
            return false;
        }
        if (this.color < 16) {
            this.value ^= 0xFFFFFFFF;
            if (this.out != null) {
                this.out.updateSignal(this.value != 0 ? this.onVal : this.offVal);
            }
            this.host.updateDisplay();
            this.sound((SoundEvent)(this.color < 0 ? Objects.LEVER_FLIP : (this.value != 0 ? Objects.BUTTON_DOWN : Objects.BUTTON_UP)));
        } else if (player.func_70093_af()) {
            this.value = 0;
            this.sound((SoundEvent)Objects.BUTTON_UP);
        } else if (this.offVal > 0) {
            if (this.value == 0) {
                TickRegistry.instance.add((TickRegistry.ITickReceiver)this);
                this.sound((SoundEvent)Objects.BUTTON_DOWN);
            }
            this.value = this.offVal;
            if (this.out != null) {
                this.out.updateSignal(this.onVal);
            }
            this.host.updateDisplay();
        }
        return true;
    }

    private void sound(SoundEvent sound) {
        BlockPos pos = this.host.pos();
        Vec3d p = this.host.getOrientation().rotate(new Vec3d(this.getX() - 0.375, this.getY() - 0.375, 0.5));
        this.host.world().func_184148_a(null, (double)pos.func_177958_n() + p.field_72450_a + 0.5, (double)pos.func_177956_o() + p.field_72448_b + 0.5, (double)pos.func_177952_p() + p.field_72449_c + 0.5, sound, SoundCategory.BLOCKS, this.color < 0 ? 1.0f : 3.0f, this.color < 0 ? 0.5f : 2.0f);
    }

    @Override
    public void setPortCallback(Object callback) {
        if (callback instanceof SignalHandler) {
            this.out = (SignalHandler)callback;
            this.out.updateSignal(this.value != 0 ? this.onVal : (this.color < 16 ? this.offVal : 0));
        } else {
            this.out = null;
        }
    }

    public boolean tick() {
        if (this.host == null) {
            return false;
        }
        if (this.value > 0) {
            --this.value;
            return true;
        }
        if (this.out != null) {
            this.out.updateSignal(0);
        }
        this.host.updateDisplay();
        this.sound((SoundEvent)Objects.BUTTON_UP);
        return false;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74768_a("on", this.onVal);
        nbt.func_74768_a("off", this.offVal);
        nbt.func_74774_a("color", this.color);
        return nbt;
    }

    @Override
    public void loadCfg(NBTTagCompound nbt) {
        this.onVal = nbt.func_74762_e("on");
        this.offVal = nbt.func_74762_e("off");
        this.color = nbt.func_74771_c("color");
        super.loadCfg(nbt);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected boolean refreshFTESR(Orientation o, double x, double y, double z, int light, BufferBuilder buffer) {
        IntArrayModel m;
        Vec3d p = o.X.func_186678_a(this.getX()).func_178787_e(o.Y.func_186678_a(this.getY()));
        if (this.color < 0) {
            m = PortRenderer.PORT_RENDER.getModel(this.value != 0 ? "_lever.on" : "_lever.off").rotated(o);
            m.origin(-((float)p.field_72450_a), -((float)p.field_72448_b), -((float)p.field_72449_c));
        } else {
            int c = this.color & 0xF;
            if (this.value != 0) {
                p = p.func_178787_e(o.Z.func_186678_a(-0.03125));
            } else {
                c |= 0x10;
            }
            m = PortRenderer.PORT_RENDER.getModel("_lever.btn").rotated(o);
            m.origin(-((float)p.field_72450_a), -((float)p.field_72448_b), -((float)p.field_72449_c)).setColor(_7Segment.COLORS[c]);
            m.setBrightness(this.brightness(light));
        }
        this.renderCache = m;
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected int brightness(int light) {
        return this.color >= 0 && this.value != 0 ? light & 0xFF0000 | 0xF0 : light;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawText(FontRenderer fr) {
        if (this.title.isEmpty()) {
            return;
        }
        if (this.color < 0) {
            super.drawText(fr);
            return;
        }
        float dz = this.value != 0 ? 0.03125f : 0.0625f;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-dz));
        int x = (this.pos & 3) * 32;
        int y = 96 - (this.pos >> 2 & 3) * 32;
        List lines = fr.func_78271_c(this.title, 26);
        y += (32 - lines.size() * 8) / 2;
        for (String s : lines) {
            fr.func_78276_b(s, x + (32 - fr.func_78256_a(s)) / 2, y, -16777216);
            y += 8;
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)dz);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected GuiFrame initGuiFrame(ModularGui gui) {
        boolean btn = this.color >= 16;
        int w = btn ? 80 : 128;
        int h = btn ? 62 : 53;
        GuiFrame frame = new GuiFrame(gui, w, h, 4).title("gui.rs_ctr.dsp_cfg.name", 0.5f).background(new ResourceLocation("rs_ctr", "textures/gui/small.png"), btn ? 0 : 80, btn ? 89 : 140);
        new TextField((GuiCompGroup)frame, w - 16, 7, 8, 16, this.color < 0 ? 6 : 16, () -> this.title, t -> gui.sendPkt(new Object[]{(byte)0, t})).allowFormat().tooltip("gui.rs_ctr.label");
        new TextField((GuiCompGroup)frame, 64, 7, w - 72, 29, 12, () -> Integer.toString(this.onVal), t -> {
            try {
                gui.sendPkt(new Object[]{(byte)2, Integer.parseInt(t)});
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }).tooltip("gui.rs_ctr.v_on");
        if (btn) {
            new Spinner((GuiCompGroup)frame, 36, 18, 37, 37, false, "\\%.2fs", () -> (double)this.offVal / 20.0, v -> gui.sendPkt(new Object[]{(byte)1, (int)Math.round(v * 20.0)}), 0.05, 60.0, new double[]{1.0, 0.05}).tooltip("gui.rs_ctr.interval");
        } else {
            new TextField((GuiCompGroup)frame, 64, 7, 56, 38, 12, () -> Integer.toString(this.offVal), t -> {
                try {
                    gui.sendPkt(new Object[]{(byte)1, Integer.parseInt(t)});
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }).tooltip(btn ? "gui.rs_ctr.interval" : "gui.rs_ctr.v_off");
        }
        if (this.color >= 0) {
            new Button((GuiCompGroup)frame, 9, 9, 7, h - 16, 16, () -> this.color & 0xF, s -> gui.sendPkt(new Object[]{(byte)3, (byte)s})).texture(247, 72).tooltip("gui.rs_ctr.color");
        }
        return frame;
    }

    public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        switch (pkt.readByte()) {
            case 0: {
                this.title = pkt.func_150789_c(32);
                break;
            }
            case 1: {
                this.offVal = pkt.readInt();
                if (this.color >= 16) {
                    if (this.offVal < 1) {
                        this.offVal = 1;
                    } else if (this.offVal > 1200) {
                        this.offVal = 1200;
                    }
                    if (this.value <= this.offVal) break;
                    this.value = this.offVal;
                    break;
                }
                if (this.out == null || this.value != 0) break;
                this.out.updateSignal(this.offVal);
                break;
            }
            case 2: {
                this.onVal = pkt.readInt();
                if (this.out == null || this.value == 0) break;
                this.out.updateSignal(this.onVal);
                break;
            }
            case 3: {
                if (this.color < 0) {
                    return;
                }
                this.color = (byte)(this.color & 0x10 | pkt.readByte() & 0xF);
                break;
            }
            default: {
                return;
            }
        }
        this.host.markDirty(2);
    }

    @Override
    public Object getState(int id) {
        return this.value != 0 ? this.onVal : (this.color < 16 ? this.offVal : 0);
    }
}

