/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity.part;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.TextField;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.render.Util;
import cd4017be.lib.render.model.IntArrayModel;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.ClientProxy;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.tileentity.part.Module;
import cd4017be.rs_ctr.tileentity.part.SignalModule;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class Clock
extends SignalModule
implements SignalHandler,
TickRegistry.ITickReceiver,
IInteractiveComponent.IBlockRenderComp {
    public static final String ID = "clock";
    SignalHandler out = SignalHandler.NOP;
    int interval = -20;

    public Clock() {
        this.title = "Clock";
        this.value = Integer.MAX_VALUE;
    }

    public void updateSignal(int value) {
        if (this.interval < 0) {
            if (value == 0) {
                return;
            }
            if (this.value == Integer.MAX_VALUE || this.value == Integer.MIN_VALUE) {
                this.value = this.value > 0 ? 0 : this.interval;
                TickRegistry.instance.add((TickRegistry.ITickReceiver)this);
            }
        } else if (value != 0) {
            return;
        }
        this.interval = -this.interval;
        this.host.updateDisplay();
    }

    public boolean tick() {
        if (this.host == null) {
            return false;
        }
        if (this.interval <= 0) {
            this.value = this.value >= 0 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            return false;
        }
        int v = this.value + 1;
        if (v >= this.interval) {
            v = -this.interval;
            this.out.updateSignal(65535);
            this.host.updateDisplay();
        } else if (v == 0) {
            this.out.updateSignal(0);
            this.host.updateDisplay();
        }
        this.value = v;
        return true;
    }

    @Override
    public void setPortCallback(Object callback) {
        if (callback instanceof SignalHandler) {
            SignalHandler h = (SignalHandler)callback;
            h.updateSignal(this.value >= 0 ? 0 : 65535);
            this.out = h;
        } else {
            this.out = SignalHandler.NOP;
        }
    }

    @Override
    public void init(List<MountedPort> ports, int idx, Module.IPanel panel) {
        ports.add(new MountedPort((IPortProvider)panel, idx << 1, SignalHandler.class, false).setLocation(this.getX() + 0.375, this.getY() + 0.125, 0.75, EnumFacing.NORTH, panel.getOrientation()).setName("port.rs_ctr.i"));
        ports.add(new MountedPort((IPortProvider)panel, idx << 1 | 1, SignalHandler.class, true).setLocation(this.getX() + 0.125, this.getY() + 0.125, 0.75, EnumFacing.NORTH, panel.getOrientation()).setName("port.rs_ctr.o"));
        super.init(ports, idx, panel);
    }

    @Override
    public boolean onInteract(EntityPlayer player, boolean hit, EnumFacing side, Vec3d aim) {
        if (super.onInteract(player, hit, side, aim)) {
            return true;
        }
        int d = this.increment(aim, this.host.getOrientation());
        int i = Math.abs(this.interval) + d;
        if (i < 1) {
            i = 1;
        } else if (i > 1200) {
            i = 1200;
        }
        this.interval = this.interval < 0 ? -i : i;
        this.host.updateDisplay();
        return true;
    }

    @Override
    public Pair<Vec3d, String> getDisplayText(Vec3d aim) {
        Module.IPanel host = this.host;
        if (host == null) {
            return null;
        }
        Orientation o = host.getOrientation();
        int val = this.increment(aim, o);
        return val != 0 ? Pair.of((Object)aim, (Object)String.format("%+.2f", Float.valueOf((float)val / 20.0f))) : null;
    }

    private int increment(Vec3d aim, Orientation o) {
        double d = (aim = aim.func_178786_a(0.5, 0.5, 0.5)).func_72430_b(o.Y) + 0.5 - this.getY();
        if (d < 0.0625 || d > 0.1875) {
            return 0;
        }
        double dx = aim.func_72430_b(o.X) + 0.5 - this.getX();
        return dx < 0.25 ? (dx < 0.125 ? -20 : -1) : (dx < 0.375 ? 1 : 20);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74777_a("int", (short)this.interval);
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.interval = nbt.func_74765_d("int");
    }

    @Override
    protected void loadCfg(NBTTagCompound nbt) {
        short i = nbt.func_74765_d("int");
        this.interval = this.interval > 0 ^ i > 0 ? -i : i;
        super.loadCfg(nbt);
    }

    @Override
    public void onLoad(Module.IPanel host) {
        if (this.interval > 0 && !host.world().field_72995_K && this.host == null) {
            if (this.value == Integer.MIN_VALUE) {
                this.value = -this.interval;
            } else if (this.value == Integer.MAX_VALUE) {
                this.value = 0;
            }
            TickRegistry.instance.add((TickRegistry.ITickReceiver)this);
        }
        super.onLoad(host);
    }

    @Override
    public void writeSync(PacketBuffer buf, boolean init) {
        buf.writeByte(this.value < 0 ? -1 : 0);
        buf.writeShort(this.interval);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readSync(PacketBuffer buf) {
        byte val = buf.readByte();
        short interv = buf.readShort();
        if (this.value != val || this.interval != interv) {
            this.value = val;
            this.interval = interv;
            this.renderCache = null;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected boolean refreshFTESR(Orientation o, double x, double y, double z, int light, BufferBuilder buffer) {
        light = this.brightness(light);
        int vi = buffer.func_178989_h();
        Vec3d p = o.rotate(new Vec3d(this.getX() - 0.5 + 0.0625, this.getY() - 0.5, 0.51)).func_72441_c(x + 0.5, y + 0.5, z + 0.5);
        Vec3d dx = o.X.func_186678_a(0.0625);
        Vec3d dy = o.Y.func_186678_a(0.0625);
        Vec2f t0 = Util.getUV((TextureAtlasSprite)ClientProxy.t_blank, (float)0.0f, (float)0.0f);
        Vec2f t1 = Util.getUV((TextureAtlasSprite)ClientProxy.t_blank, (float)16.0f, (float)16.0f);
        buffer.func_178981_a(Util.texturedRect((Vec3d)p, (Vec3d)dx, (Vec3d)dy, (Vec2f)t0, (Vec2f)t1, (int)(this.value < 0 ? -16776961 : -16777169), (int)light));
        buffer.func_178981_a(Util.texturedRect((Vec3d)p.func_178787_e(dx.func_186678_a(5.0)), (Vec3d)dx, (Vec3d)dy, (Vec2f)t0, (Vec2f)t1, (int)(this.interval > 0 ? -16711936 : -16765184), (int)light));
        IntArrayModel m = new IntArrayModel(Util.extractData((BufferBuilder)buffer, (int)vi, (int)buffer.func_178989_h()), -1, light);
        m.origin((float)x, (float)y, (float)z);
        this.renderCache = m;
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected int brightness(int light) {
        return light & 0xFF0000 | 0xF0;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(List<BakedQuad> quads) {
        Module.IPanel host = this.host;
        if (host == null) {
            return;
        }
        Orientation o = host.getOrientation();
        quads.add(new BakedQuad(Util.texturedRect((Vec3d)o.rotate(new Vec3d(this.getX() - 0.4375, this.getY() - 0.5, 0.505)).func_72441_c(0.5, 0.5, 0.5), (Vec3d)o.X.func_186678_a(0.375), (Vec3d)o.Y.func_186678_a(0.16666666666666666), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_blank, (float)0.0f, (float)0.0f), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_blank, (float)16.0f, (float)16.0f), (int)-12632257, (int)0), -1, o.back, ClientProxy.t_blank, true, DefaultVertexFormats.field_176600_a));
    }

    @Override
    public void drawText(FontRenderer fr) {
        int x = (this.pos & 3) * 32;
        int y = (3 - (this.pos >> 2 & 3)) * 32;
        int w = 64;
        fr.func_78276_b(this.title, x + (w - fr.func_78256_a(this.title)) / 2, ++y + 1, -16777216);
        String s = TooltipUtil.format((String)"port.rs_ctr.clock", (Object[])new Object[]{Float.valueOf((float)Math.abs(this.interval) / 20.0f)});
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.005);
        fr.func_78276_b(s, x + (w - fr.func_78256_a(s)) / 2, y + 12, -4145152);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.005);
    }

    @Override
    protected GuiFrame initGuiFrame(ModularGui gui) {
        GuiFrame frame = new GuiFrame(gui, 80, 31, 1).title("gui.rs_ctr.dsp_cfg.name", 0.5f).background(new ResourceLocation("rs_ctr", "textures/gui/small.png"), 0, 0);
        new TextField((GuiCompGroup)frame, 112, 7, 8, 16, 20, () -> this.title, t -> gui.sendPkt(new Object[]{t})).allowFormat().tooltip("gui.rs_ctr.label");
        return frame;
    }

    public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        this.title = pkt.func_150789_c(32);
        this.host.markDirty(2);
    }

    @Override
    public void onPlaced(ItemStack stack, float x, float y) {
        if (stack.func_77942_o()) {
            this.interval = -stack.func_77978_p().func_74762_e("int");
        }
        this.pos = (byte)(0x10 | (int)Math.floor((double)x * 3.0) & 3 | (int)Math.floor((double)y * 4.0) << 2 & 0xC);
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public ItemStack onRemove() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("int", Math.abs(this.interval));
        ItemStack stack = new ItemStack((Item)Objects.clock);
        stack.func_77982_d(nbt);
        return stack;
    }

    @Override
    public Object getState(int id) {
        return (id == 0 ? this.interval < 0 : this.value >= 0) ? 0 : 65535;
    }
}

