/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.com.EnergyHandler;
import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.DimPos;
import cd4017be.lib.util.MovedBlock;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr.Main;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.FutureTask;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class Teleporter
extends WallMountGate
implements SignalHandler,
BaseTileEntity.ITickableServerOnly {
    protected static final int SINGLE_BLOCK = 1;
    protected static final int DO_TELEPORT = 8;
    protected static final int INVALID_COORDS = -1;
    protected static final int OUT_OF_WORLD = -2;
    protected static final int COMPLETE = 100;
    public static final Object2IntOpenHashMap<Block> blacklist = new Object2IntOpenHashMap();
    public static final Object2IntOpenHashMap<Block> whitelist;
    public static double ENERGY_PER_BLOCK;
    public static double MAX_DISTANCE;
    SignalHandler out = SignalHandler.NOP;
    EnergyHandler energy = EnergyHandler.NOP;
    BlockReference dest;
    BlockReference ref;
    int action;
    int result;
    long buffer;

    public Teleporter() {
        this.ports = new MountedPort[]{new MountedPort((IPortProvider)this, 0, BlockReference.BlockHandler.class, false).setName("port.rs_ctr.p1").setLocation(0.875, 0.625, 0.25, EnumFacing.NORTH), new MountedPort((IPortProvider)this, 1, BlockReference.BlockHandler.class, false).setName("port.rs_ctr.p0").setLocation(0.125, 0.625, 0.25, EnumFacing.NORTH), new MountedPort((IPortProvider)this, 2, SignalHandler.class, false).setName("port.rs_ctr.tp").setLocation(0.625, 0.25, 0.125, EnumFacing.UP), new MountedPort((IPortProvider)this, 3, SignalHandler.class, true).setName("port.rs_ctr.status").setLocation(0.125, 0.25, 0.125, EnumFacing.UP), new MountedPort((IPortProvider)this, 4, EnergyHandler.class, true).setName("port.rs_ctr.energy_i").setLocation(0.375, 0.25, 0.125, EnumFacing.UP)};
    }

    public void func_73660_a() {
        if ((this.action & 8) == 0) {
            return;
        }
        this.action ^= 8;
        this.result = this.run();
        this.out.updateSignal(this.result);
    }

    protected int run() {
        if (this.dest == null || this.ref == null) {
            return -1;
        }
        DimPos posA = new DimPos((Vec3i)this.ref.pos, this.ref.dim);
        DimPos posB = new DimPos((Vec3i)this.dest.pos, this.dest.dim);
        if (!this.field_145850_b.func_175701_a((BlockPos)posA) || !this.field_145850_b.func_175701_a((BlockPos)posB)) {
            return -2;
        }
        double distance = Teleporter.attenuatedDistance(posA, posB);
        if (distance == 0.0) {
            return 100;
        }
        long needed = Math.round(distance * ENERGY_PER_BLOCK);
        return this.initTeleport(() -> {
            if (this.unloaded) {
                return;
            }
            this.buffer -= needed;
            Teleporter.swap(posA, posB, null);
            List<Entity> entitiesA = Teleporter.getEntities(posA, null, false);
            List<Entity> entitiesB = Teleporter.getEntities(posB, null, false);
            Teleporter.moveEntities(entitiesA, (BlockPos)posA, posB);
            Teleporter.moveEntities(entitiesB, (BlockPos)posB, posA);
        }, needed);
    }

    protected static double attenuatedDistance(DimPos a, DimPos b) {
        double d = Math.sqrt(a.func_177951_i((Vec3i)b));
        if (Double.isInfinite(MAX_DISTANCE)) {
            return d;
        }
        return MAX_DISTANCE / (1.0 + MAX_DISTANCE / d);
    }

    protected int initTeleport(Runnable task, long needed) {
        this.buffer -= (long)this.energy.changeEnergy((int)Math.max(this.buffer - needed, -2147483647L), false);
        if (this.buffer < needed) {
            this.action |= 8;
            return 1 + (int)(this.buffer * 99L / needed);
        }
        ((WorldServer)this.field_145850_b).func_73046_m().field_175589_i.add(new FutureTask<Object>(task, null));
        return 100;
    }

    protected static void swap(DimPos pa, DimPos pb, HashMap<DimPos, NBTTagCompound> addedTiles) {
        if (!Teleporter.canTeleport((World)pa.getWorldServer(), (BlockPos)pa) || !Teleporter.canTeleport((World)pb.getWorldServer(), (BlockPos)pb)) {
            return;
        }
        MovedBlock a = MovedBlock.cut((DimPos)pa, addedTiles);
        MovedBlock b = MovedBlock.cut((DimPos)pb, addedTiles);
        a.paste(pb, addedTiles);
        b.paste(pa, addedTiles);
    }

    protected static boolean canTeleport(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        int i = (state.func_185887_b(world, pos) < 0.0f ? whitelist : blacklist).getInt((Object)block);
        return i == 0 || i > 0 && (i >> block.func_176201_c(state) & 1) == 0;
    }

    public static void addEntry(String s, boolean black) {
        ResourceLocation rl;
        Object2IntOpenHashMap<Block> map = black ? blacklist : whitelist;
        int x = black ? -1 : 0;
        int i = s.indexOf(64);
        int meta = -1;
        if (i >= 0) {
            try {
                meta = Integer.parseInt(s.substring(i + 1));
            }
            catch (NumberFormatException e) {
                Main.LOG.error(black ? "invalid teleporter blacklist entry" : "invalid teleporter whitelist entry", (Throwable)e);
                return;
            }
            s = s.substring(0, i);
        }
        if ((rl = new ResourceLocation(s)).func_110623_a().isEmpty()) {
            for (ResourceLocation loc : Block.field_149771_c.func_148742_b()) {
                if (!loc.func_110624_b().equals(s)) continue;
                map.put(Block.field_149771_c.func_82594_a((Object)loc), x);
            }
            return;
        }
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)rl);
        if (block == null || block == Blocks.field_150350_a) {
            return;
        }
        map.put((Object)block, meta < 0 ? x : (map.getInt((Object)block) ^ x) & ~(1 << meta) ^ x);
    }

    protected static List<Entity> getEntities(DimPos pos, BlockPos size, boolean skipInner) {
        AxisAlignedBB box = size == null ? new AxisAlignedBB((BlockPos)pos) : new AxisAlignedBB((BlockPos)pos, pos.func_177971_a((Vec3i)size));
        Object filter = EntitySelectors.field_180132_d;
        if (skipInner) {
            AxisAlignedBB inner = box.func_72314_b(-1.0, 0.0, -1.0);
            filter = filter.and(e -> !e.func_174813_aQ().func_72326_a(inner));
        }
        return pos.getWorldServer().func_175674_a(null, box, ((Predicate)filter)::test);
    }

    protected static void moveEntities(List<Entity> list, BlockPos from, DimPos to) {
        double dx = to.func_177958_n() - from.func_177958_n();
        double dy = to.func_177956_o() - from.func_177956_o();
        double dz = to.func_177952_p() - from.func_177952_p();
        for (Entity e : list) {
            MovedBlock.moveEntity((Entity)e, (int)to.dimId, (double)(e.field_70165_t + dx), (double)(e.field_70163_u + dy), (double)(e.field_70161_v + dz));
        }
    }

    public Object getPortCallback(int pin) {
        return pin == 1 ? block -> {
            this.ref = block;
        } : (pin == 0 ? block -> {
            this.dest = block;
        } : this);
    }

    public void setPortCallback(int pin, Object callback) {
        if (pin == 3) {
            this.out = callback instanceof SignalHandler ? (SignalHandler)callback : SignalHandler.NOP;
            this.out.updateSignal(this.result);
        } else {
            this.energy = callback instanceof EnergyHandler ? (EnergyHandler)callback : EnergyHandler.NOP;
        }
    }

    @Override
    protected void resetPin(int pin) {
        switch (pin) {
            case 0: {
                this.dest = null;
                break;
            }
            case 1: {
                this.ref = new BlockReference(this.field_145850_b, this.field_174879_c, this.o.front);
                break;
            }
            case 2: {
                this.updateSignal(0);
            }
        }
    }

    public void updateSignal(int value) {
        if (this.action == 0 && (value &= 7) != 0) {
            value |= 8;
        } else if (value == 0 && this.action != 0 && this.result != 0) {
            this.result = 0;
            this.out.updateSignal(0);
        }
        this.action = value;
        this.markDirty(0);
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        nbt.func_74772_a("buff", this.buffer);
        nbt.func_74774_a("op", (byte)this.action);
        nbt.func_74774_a("res", (byte)this.result);
        if (this.dest != null) {
            nbt.func_74782_a("dst", (NBTBase)this.dest.serializeNBT());
        }
        if (this.ref != null) {
            nbt.func_74782_a("src", (NBTBase)this.ref.serializeNBT());
        }
        super.storeState(nbt, mode);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        super.loadState(nbt, mode);
        this.buffer = nbt.func_74763_f("buff");
        this.action = nbt.func_74771_c("op");
        this.result = nbt.func_74771_c("res");
        this.dest = nbt.func_150297_b("dst", 10) ? new BlockReference(nbt.func_74775_l("dst")) : null;
        this.ref = nbt.func_150297_b("src", 10) ? new BlockReference(nbt.func_74775_l("src")) : null;
    }

    @Override
    protected void orient(Orientation o) {
        super.orient(o);
        if (this.ports[1].getConnector() == null && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.resetPin(1);
        }
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        if (this.ports[1].getConnector() == null && world != null && !world.field_72995_K) {
            this.resetPin(1);
        }
    }

    @Override
    public Object getState(int id) {
        switch (id) {
            case 0: {
                return this.dest;
            }
            case 1: {
                return this.ref;
            }
            case 2: {
                return this.action & 7;
            }
            case 3: {
                return this.result;
            }
        }
        return null;
    }

    static {
        blacklist.defaultReturnValue(0);
        whitelist = new Object2IntOpenHashMap();
        whitelist.defaultReturnValue(-1);
        ENERGY_PER_BLOCK = 1000.0;
        MAX_DISTANCE = 1024.0;
    }
}

