/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.sensor.IBlockSensor;
import cd4017be.api.rs_ctr.sensor.SensorRegistry;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr.render.PortRenderer;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class Sensor
extends WallMountGate
implements BlockReference.BlockHandler,
SignalHandler,
IInteractiveComponent,
IInteractiveComponent.IBlockRenderComp,
IBlockSensor.IHost {
    protected SignalHandler out;
    protected BlockReference blockRef;
    protected int clock;
    protected int value;
    protected int ref;
    protected boolean refChanged;
    protected IBlockSensor impl = SensorRegistry.DEFAULT;
    protected ItemStack stack = ItemStack.field_190927_a;
    Vec3d mountPos;

    public Sensor() {
        this.ports = new MountedPort[]{new MountedPort((IPortProvider)this, 0, BlockReference.BlockHandler.class, false).setLocation(0.25, 0.125, 0.125, EnumFacing.WEST).setName("port.rs_ctr.bi"), new MountedPort((IPortProvider)this, 1, SignalHandler.class, false).setLocation(0.25, 0.5, 0.125, EnumFacing.WEST).setName("port.rs_ctr.clk"), new MountedPort((IPortProvider)this, 2, SignalHandler.class, true).setLocation(0.75, 0.5, 0.125, EnumFacing.EAST).setName("port.rs_ctr.o"), new MountedPort((IPortProvider)this, 3, SignalHandler.class, false).setLocation(0.25, 0.875, 0.125, EnumFacing.WEST).setName("port.rs_ctr.ref")};
        this.mountPos = Vec3d.field_186680_a;
    }

    public Object getPortCallback(int pin) {
        return pin == 3 ? v -> {
            if (v == this.ref) {
                return;
            }
            this.ref = v;
            this.refChanged = true;
            this.markDirty(0);
        } : this;
    }

    public void setPortCallback(int pin, Object callback) {
        SignalHandler signalHandler = this.out = callback instanceof SignalHandler ? (SignalHandler)callback : null;
        if (this.out != null) {
            this.out.updateSignal(this.value - this.ref);
        }
    }

    @Override
    protected void resetPin(int pin) {
        if (pin == 0) {
            this.updateBlock(new BlockReference(this.field_145850_b, this.field_174879_c.func_177972_a(this.o.front), this.o.back));
        } else if (pin == 3) {
            this.ref = 0;
        }
    }

    public void updateBlock(BlockReference ref) {
        this.blockRef = ref;
        this.impl.onRefChange(this.blockRef, (IBlockSensor.IHost)this);
        this.updateSignal(this.clock);
    }

    public void updateSignal(int val) {
        if (val == this.clock && this.ports[1].getConnector() != null) {
            return;
        }
        this.clock = val;
        if (this.blockRef == null || !this.blockRef.isLoaded()) {
            return;
        }
        val = this.impl.readValue(this.blockRef);
        if (val == this.value && !this.refChanged) {
            return;
        }
        this.value = val;
        this.refChanged = false;
        if (this.out != null) {
            this.out.updateSignal(val - this.ref);
        }
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        super.storeState(nbt, mode);
        if (mode == 0) {
            nbt.func_74768_a("clk", this.clock);
            nbt.func_74768_a("val", this.value);
            nbt.func_74768_a("ref", this.ref);
            if (this.blockRef != null) {
                nbt.func_74782_a("block", (NBTBase)this.blockRef.serializeNBT());
            }
        }
        if (!this.stack.func_190926_b()) {
            nbt.func_74782_a("sensor", (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
            if (mode != 0 && this.impl instanceof INBTSerializable) {
                nbt.func_74782_a("sync", ((INBTSerializable)this.impl).serializeNBT());
            }
        }
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        super.loadState(nbt, mode);
        if (mode == 0) {
            this.clock = nbt.func_74762_e("clk");
            this.value = nbt.func_74762_e("val");
            this.ref = nbt.func_74762_e("ref");
            this.refChanged = true;
            this.blockRef = nbt.func_150297_b("block", 10) ? new BlockReference(nbt.func_74775_l("block")) : null;
        }
        this.stack = nbt.func_150297_b("sensor", 10) ? new ItemStack(nbt.func_74775_l("sensor")) : ItemStack.field_190927_a;
        this.impl = SensorRegistry.get((ItemStack)this.stack);
        if (mode == 0) {
            this.impl.onRefChange(this.blockRef, (IBlockSensor.IHost)this);
        } else if (this.impl instanceof INBTSerializable) {
            ((INBTSerializable)this.impl).deserializeNBT(nbt.func_74781_a("sync"));
        }
    }

    @Override
    protected void orient(Orientation o) {
        super.orient(o);
        this.mountPos = o.rotate(new Vec3d(0.0, 0.0, -0.25)).func_72441_c(0.5, 0.5, 0.5);
        if (this.ports[0].getConnector() == null && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.resetPin(0);
        }
    }

    @Override
    protected void initGuiComps(List<IInteractiveComponent> list) {
        list.add(this);
    }

    public Pair<Vec3d, EnumFacing> rayTrace(Vec3d start, Vec3d dir) {
        boolean rot = this.o.ordinal() >= 4 && (this.o.ordinal() & 1) != 0;
        return IInteractiveComponent.rayTraceFlat((Vec3d)start, (Vec3d)dir, (Vec3d)this.mountPos, (EnumFacing)this.o.back, (float)(rot ? 0.5f : 0.25f), (float)(rot ? 0.25f : 0.5f));
    }

    public boolean onInteract(EntityPlayer player, boolean hit, EnumFacing side, Vec3d aim) {
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && !player.func_70093_af()) {
            IBlockSensor sensor = SensorRegistry.get((ItemStack)stack);
            if (sensor == SensorRegistry.DEFAULT) {
                return false;
            }
            if (!this.stack.func_190926_b()) {
                this.remove(player);
            }
            this.stack = player.func_184812_l_() ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1) : stack.func_77979_a(1);
            this.impl = sensor;
            this.impl.onRefChange(this.blockRef, (IBlockSensor.IHost)this);
            this.markDirty(3);
            return true;
        }
        if (hit || player.func_70093_af() && stack.func_190926_b()) {
            if (this.stack.func_190926_b()) {
                return false;
            }
            this.remove(player);
            this.markDirty(3);
            return true;
        }
        return false;
    }

    private void remove(EntityPlayer player) {
        if (player == null) {
            ItemFluidUtil.dropStack((ItemStack)this.stack, (World)this.field_145850_b, (BlockPos)this.field_174879_c);
        } else if (!player.func_184812_l_()) {
            ItemFluidUtil.dropStack((ItemStack)this.stack, (Entity)player);
        }
        this.stack = ItemStack.field_190927_a;
        this.impl = SensorRegistry.DEFAULT;
    }

    public Pair<Vec3d, String> getDisplayText(Vec3d aim) {
        return Pair.of((Object)this.mountPos, (Object)this.impl.getTooltipString());
    }

    @SideOnly(value=Side.CLIENT)
    public void render(List<BakedQuad> quads) {
        if (this.stack.func_190926_b()) {
            return;
        }
        ResourceLocation model = this.impl.getModel();
        if (model != null) {
            PortRenderer.PORT_RENDER.drawModel(quads, (float)this.mountPos.field_72450_a, (float)this.mountPos.field_72448_b, (float)this.mountPos.field_72449_c, this.o, model.toString());
        }
    }

    public void syncSensorState() {
        this.markDirty(2);
    }

    @Override
    protected void onUnload() {
        super.onUnload();
        this.impl.onRefChange(null, null);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.ports[0].getConnector() == null && !this.field_145850_b.field_72995_K) {
            this.resetPin(0);
        }
    }

    @Override
    public Object getState(int id) {
        switch (id) {
            case 0: {
                return this.blockRef;
            }
            case 1: {
                return this.clock;
            }
            case 2: {
                return this.value - this.ref;
            }
        }
        return this.ref;
    }
}

