/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.com.EnergyHandler;
import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.IStateInfo;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.block.MultipartBlock;
import cd4017be.lib.capability.NullEnergyStorage;
import cd4017be.lib.render.Util;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.Utils;
import cd4017be.rs_ctr.ClientProxy;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.tileentity.Gate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.apache.commons.lang3.ArrayUtils;

public class RedstonePort
extends Gate
implements AdvancedBlock.IRedstoneTile,
AdvancedBlock.INeighborAwareTile,
TickRegistry.IUpdatable,
MultipartBlock.IModularTile,
AdvancedBlock.ITilePlaceHarvest,
IInteractiveComponent.IBlockRenderComp,
IStateInfo {
    private static boolean RECURSION;
    final SignalHandler[] callbacks = new SignalHandler[6];
    final BlockReference[] mirrors = new BlockReference[6];
    final int[] states = new int[12];
    byte strong;
    byte dirty;

    public RedstonePort() {
        this.ports = new MountedPort[0];
    }

    @Override
    public Port getPort(int pin) {
        Port port = super.getPort(pin);
        if (port != null) {
            return port;
        }
        int i = Arrays.binarySearch(this.ports, (Object)pin);
        return i >= 0 ? this.ports[i] : null;
    }

    public Object getPortCallback(int pin) {
        if (pin < 12) {
            return new RSOut(pin);
        }
        int i = pin - 18;
        return block -> {
            this.mirrors[i] = block;
        };
    }

    public void setPortCallback(int pin, Object callback) {
        if (pin < 6) {
            SignalHandler c;
            this.callbacks[pin] = c = callback instanceof SignalHandler ? (SignalHandler)callback : null;
            if (c != null) {
                c.updateSignal(this.states[pin]);
            }
        } else if (callback instanceof BlockReference.BlockHandler) {
            ((BlockReference.BlockHandler)callback).updateBlock(this.blockRefFor(pin - 12));
        }
    }

    private BlockReference blockRefFor(int side) {
        EnumFacing s = EnumFacing.field_82609_l[side ^ 1];
        return new BlockReference(this.field_145850_b, this.field_174879_c.func_177967_a(s, -1), s);
    }

    @Override
    protected void resetPin(int pin) {
        if (pin < 12) {
            new RSOut(pin).updateSignal(0);
        } else {
            this.mirrors[pin - 18] = null;
        }
    }

    public int redstoneLevel(EnumFacing side, boolean strong) {
        int i = side.ordinal();
        return !strong || (this.strong >> i & 1) != 0 ? this.states[i + 6] : 0;
    }

    public boolean connectRedstone(EnumFacing side) {
        int i = side.ordinal();
        return this.getPort(i) != null || this.getPort(i + 6) != null;
    }

    public void neighborBlockChange(Block b, BlockPos src) {
        EnumFacing side = Utils.getSide((BlockPos)src, (BlockPos)this.field_174879_c);
        if (side != null) {
            this.updateInput(side);
        } else {
            for (EnumFacing s : EnumFacing.field_82609_l) {
                this.updateInput(s);
            }
        }
    }

    private void updateInput(EnumFacing side) {
        int i = side.ordinal();
        int val = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(side), side);
        if (val != this.states[i]) {
            this.states[i] = val;
            if (this.dirty == 0) {
                TickRegistry.instance.updates.add(this);
            }
            this.dirty = (byte)(this.dirty | 1 << i);
        }
    }

    public void neighborTileChange(TileEntity te, EnumFacing side) {
    }

    public void process() {
        int j = this.dirty;
        int i = 0;
        while (j != 0) {
            SignalHandler c;
            if ((j & 1) != 0 && (c = this.callbacks[i]) != null) {
                c.updateSignal(this.states[i]);
            }
            j >>>= 1;
            ++i;
        }
        this.dirty = 0;
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        if (facing == null || cap != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && cap != CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && cap != CapabilityEnergy.ENERGY) {
            return false;
        }
        int i = facing.ordinal();
        return this.mirrors[i] != null || Arrays.binarySearch(this.ports, (Object)(i + 18)) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        block7: {
            if (facing == null || cap != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && cap != CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && cap != CapabilityEnergy.ENERGY) {
                return null;
            }
            int i = facing.ordinal();
            BlockReference block = this.mirrors[i];
            if (block != null && !RECURSION) {
                try {
                    Object obj;
                    RECURSION = true;
                    if (block.isLoaded() && (obj = block.getCapability(cap)) != null) {
                        Object object = obj;
                        return (T)object;
                    }
                    break block7;
                }
                finally {
                    RECURSION = false;
                }
            }
            if (Arrays.binarySearch(this.ports, (Object)(i + 18)) < 0) {
                return null;
            }
        }
        return (T)(cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? EmptyHandler.INSTANCE : (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? EmptyFluidHandler.INSTANCE : NullEnergyStorage.INSTANCE));
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        NBTTagList list = new NBTTagList();
        for (MountedPort port : this.ports) {
            NBTTagCompound tag = port.serializeNBT();
            tag.func_74774_a("pin", (byte)port.pin);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("ports", (NBTBase)list);
        nbt.func_74774_a("strong", this.strong);
        this.cover.writeNBT(nbt, "cover", mode == 2);
        NBTTagCompound tag = this.storeHooks();
        if (tag != null) {
            nbt.func_74782_a("hooks", (NBTBase)tag);
        }
        if (mode < 2) {
            nbt.func_74783_a("states", this.states);
        }
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        this.strong = nbt.func_74771_c("strong");
        NBTTagList list = nbt.func_150295_c("ports", 10);
        this.ports = new MountedPort[list.func_74745_c()];
        for (int i = 0; i < this.ports.length; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            byte pin = tag.func_74771_c("pin");
            this.ports[i] = this.createPort(pin);
            this.ports[i].deserializeNBT(tag);
        }
        Arrays.sort(this.ports);
        this.cover.readNBT(nbt, "cover", (TileEntity)(mode == 2 ? this : null));
        if (mode < 2) {
            int[] arr = nbt.func_74759_k("states");
            System.arraycopy(arr, 0, this.states, 0, Math.min(arr.length, 12));
            if (arr.length < 12) {
                Arrays.fill(this.states, arr.length, 12, 0);
            }
        }
        this.loadHooks(nbt.func_74775_l("hooks"));
        this.tesrComps = null;
        this.tesrBB = null;
        this.gui = null;
    }

    private MountedPort createPort(int pin) {
        boolean br = pin >= 12;
        boolean in = pin % 12 < 6;
        MountedPort port = new MountedPort((IPortProvider)this, pin, br ? BlockReference.BlockHandler.class : SignalHandler.class, in);
        EnumFacing side = EnumFacing.field_82609_l[pin % 6];
        Orientation o = Orientation.fromFacing((EnumFacing)side);
        Vec3d p = o.rotate(new Vec3d(in ? (double)-0.1f : (double)0.1f, in ^ br ? (double)-0.1f : (double)0.1f, -0.375));
        port.setLocation((double)((float)p.field_72450_a + 0.5f), (double)((float)p.field_72448_b + 0.5f), (double)((float)p.field_72449_c + 0.5f), o.back);
        port.setName(br ? (in ? "port.rs_ctr.brR" : "port.rs_ctr.brW") : (in ? "port.rs_ctr.rsR" : "port.rs_ctr.rsW"));
        return port;
    }

    @Override
    public ArrayList<IInteractiveComponent.IBlockRenderComp> getBMRComponents() {
        Collection list = super.getBMRComponents();
        ((ArrayList)list).add(this);
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(List<BakedQuad> quads) {
        for (MountedPort port : this.ports) {
            int i;
            Orientation o = Orientation.fromFacing((EnumFacing)port.face);
            Vec3d dx = o.X.func_186678_a((double)-0.2f);
            Vec3d dy = o.Y.func_186678_a((double)0.2f);
            Vec3d p = o.rotate(new Vec3d((double)0.1f, (double)-0.1f, -0.005));
            int n = i = port.isMaster ? 4 : 0;
            int j = port.type == SignalHandler.class ? 0 : (port.type == BlockReference.BlockHandler.class ? 4 : (port.type == EnergyHandler.class ? 8 : 12));
            quads.add(new BakedQuad(Util.texturedRect((Vec3d)port.pos.func_178787_e(p), (Vec3d)dx, (Vec3d)dy, (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_sockets, (float)i, (float)j), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_sockets, (float)(i + 4), (float)(j + 4)), (int)-1, (int)0), -1, o.front, ClientProxy.t_sockets, true, DefaultVertexFormats.field_176600_a));
        }
        for (int i = 0; i < 6; ++i) {
            if ((this.strong >> i & 1) == 0) continue;
            Orientation o = Orientation.fromFacing((EnumFacing)EnumFacing.field_82609_l[i]);
            Vec3d dx = o.X.func_186678_a((double)0.2f);
            Vec3d dy = o.Y.func_186678_a((double)0.2f);
            Vec3d p = o.rotate(new Vec3d(-0.22500000149011612, -0.22500000149011612, -0.37));
            quads.add(new BakedQuad(Util.texturedRect((Vec3d)p.func_72441_c(0.5, 0.5, 0.5), (Vec3d)dx, (Vec3d)dy, (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_sockets, (float)0.0f, (float)12.0f), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_sockets, (float)4.0f, (float)16.0f), (int)-1, (int)0), -1, o.back, ClientProxy.t_sockets, true, DefaultVertexFormats.field_176600_a));
        }
    }

    @Override
    public <T> T getModuleState(int m) {
        if (m == 7) {
            return (T)this.getBMRComponents();
        }
        if (m == 6) {
            return (T)this.cover.module();
        }
        return (T)Byte.valueOf(this.isModulePresent(m) ? (byte)0 : -1);
    }

    @Override
    public boolean isModulePresent(int m) {
        if (m == 7) {
            return false;
        }
        if (m == 6) {
            return this.cover.state != null;
        }
        return Arrays.binarySearch(this.ports, (Object)m) >= 0 || Arrays.binarySearch(this.ports, (Object)(m + 6)) >= 0 || Arrays.binarySearch(this.ports, (Object)(m + 12)) >= 0 || Arrays.binarySearch(this.ports, (Object)(m + 18)) >= 0;
    }

    public boolean addPort(EnumFacing side, int type) {
        int i = side.ordinal();
        int k = i + 6 * type;
        int j = Arrays.binarySearch(this.ports, (Object)k);
        switch (type) {
            case 0: {
                if (j < 0 && (this.strong >> i & 1) == 0) break;
                return false;
            }
            case 1: {
                if (j < 0) break;
                if ((this.strong >> i & 1) != 0) {
                    return false;
                }
                this.strong = (byte)(this.strong | 1 << i);
                this.markDirty(3);
                return true;
            }
            case 2: 
            case 3: {
                if (j < 0) break;
            }
            default: {
                return false;
            }
        }
        MountedPort port = this.createPort(k);
        this.ports = (MountedPort[])ArrayUtils.add((Object[])this.ports, (int)(-1 - j), (Object)port);
        if (!this.unloaded && !this.field_145850_b.field_72995_K) {
            port.onLoad();
            this.onPortModified((Port)port, 256);
        }
        return true;
    }

    public boolean breakPort(int side, EntityPlayer player, boolean harvest) {
        if (side <= -2) {
            return this.cover.hit((BaseTileEntity)this, player);
        }
        int i = Arrays.binarySearch(this.ports, (Object)(side + 18));
        if (i >= 0) {
            if (harvest) {
                ItemFluidUtil.dropStack((ItemStack)new ItemStack((Item)Objects.rs_port, 1, 3), (World)this.field_145850_b, (BlockPos)this.field_174879_c);
            }
            this.remPort(i, player);
        }
        if ((i = Arrays.binarySearch(this.ports, (Object)(side + 12))) >= 0) {
            if (harvest) {
                ItemFluidUtil.dropStack((ItemStack)new ItemStack((Item)Objects.rs_port, 1, 2), (World)this.field_145850_b, (BlockPos)this.field_174879_c);
            }
            this.remPort(i, player);
        }
        if ((i = Arrays.binarySearch(this.ports, (Object)(side + 6))) >= 0) {
            if (harvest) {
                ItemFluidUtil.dropStack((ItemStack)new ItemStack((Item)Objects.rs_port, 1 + (this.strong >> side & 1), 1), (World)this.field_145850_b, (BlockPos)this.field_174879_c);
            }
            this.remPort(i, player);
            this.strong = (byte)(this.strong & ~(1 << side));
        }
        if ((i = Arrays.binarySearch(this.ports, (Object)side)) >= 0) {
            if (harvest) {
                ItemFluidUtil.dropStack((ItemStack)new ItemStack((Item)Objects.rs_port, 1, 0), (World)this.field_145850_b, (BlockPos)this.field_174879_c);
            }
            this.remPort(i, player);
        }
        this.onPortModified(null, 512);
        return this.ports.length > 0;
    }

    private void remPort(int i, EntityPlayer player) {
        MountedPort port = this.ports[i];
        port.setConnector(null, player);
        port.onUnload();
        this.ports = (MountedPort[])ArrayUtils.remove((Object[])this.ports, (int)i);
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        this.neighborBlockChange(this.func_145838_q(), this.field_174879_c);
    }

    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        int in = 0;
        int out = 0;
        int br = 0;
        int mirr = 0;
        for (MountedPort port : this.ports) {
            if (port.type == BlockReference.BlockHandler.class) {
                if (port.isMaster) {
                    ++br;
                    continue;
                }
                ++mirr;
                continue;
            }
            if (port.isMaster) {
                ++in;
                continue;
            }
            if ((this.strong >> port.pin - 6 & 1) != 0) {
                out += 2;
                continue;
            }
            ++out;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (in > 0) {
            list.add(new ItemStack((Item)Objects.rs_port, in, 0));
        }
        if (out > 0) {
            list.add(new ItemStack((Item)Objects.rs_port, out, 1));
        }
        if (br > 0) {
            list.add(new ItemStack((Item)Objects.rs_port, br, 2));
        }
        if (mirr > 0) {
            list.add(new ItemStack((Item)Objects.rs_port, mirr, 2));
        }
        return list;
    }

    @Override
    protected void onUnload() {
        super.onUnload();
        this.dirty = 0;
    }

    @Override
    public Object getState(int id) {
        if (id < 12) {
            return this.states[id];
        }
        if (id < 18) {
            return this.blockRefFor(id - 12);
        }
        return this.mirrors[id - 18];
    }

    class RSOut
    implements SignalHandler {
        final BlockPos target;
        final EnumFacing side;
        final int id;

        RSOut(int id) {
            this.id = id;
            this.side = EnumFacing.field_82609_l[id - 6 ^ 1];
            this.target = RedstonePort.this.field_174879_c.func_177967_a(this.side, -1);
        }

        public void updateSignal(int value) {
            if (value != RedstonePort.this.states[this.id]) {
                RedstonePort.this.states[this.id] = value;
                RedstonePort.this.field_145850_b.func_190524_a(this.target, RedstonePort.this.func_145838_q(), RedstonePort.this.field_174879_c);
                if ((RedstonePort.this.strong >> this.id - 6 & 1) != 0) {
                    RedstonePort.this.field_145850_b.func_175695_a(this.target, RedstonePort.this.field_145854_h, this.side);
                }
            }
        }
    }
}

