/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.Gui.AdvancedContainer;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.network.GuiNetworkHandler;
import cd4017be.lib.network.IGuiHandlerTile;
import cd4017be.lib.network.StateSyncClient;
import cd4017be.lib.network.StateSyncServer;
import cd4017be.lib.network.StateSynchronizer;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.gui.GuiRAM;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class RAM
extends WallMountGate
implements SignalHandler,
IGuiHandlerTile,
AdvancedContainer.IStateInteractionHandler,
AdvancedBlock.ITilePlaceHarvest,
TickRegistry.IUpdatable {
    public int[] memory;
    public int addrMask;
    public byte mode;
    public byte page;
    private SignalHandler out = SignalHandler.NOP;
    public int readIN;
    public int writeIN = -1;
    public int valueIN;
    public int valueOUT;
    private long scheduledTime;
    private boolean needWrite;
    private static final StateSynchronizer.Builder ssb = StateSynchronizer.builder().addFix(new int[]{4, 4, 1, 1}).addMulFix(4, 64).addVar(1);
    public static final byte A_MODE = 0;
    public static final byte A_PAGE = 1;
    public static final byte A_SET_MEM = 2;
    public static final byte A_DOWNLOAD = 3;
    public static final byte A_UPLOAD = 4;

    public RAM() {
        this.ports = new MountedPort[]{new MountedPort((IPortProvider)this, 0, SignalHandler.class, false).setLocation(0.125, 0.125, 0.25, EnumFacing.SOUTH).setName("port.rs_ctr.wa"), new MountedPort((IPortProvider)this, 1, SignalHandler.class, false).setLocation(0.125, 0.375, 0.25, EnumFacing.SOUTH).setName("port.rs_ctr.wv"), new MountedPort((IPortProvider)this, 2, SignalHandler.class, false).setLocation(0.125, 0.625, 0.25, EnumFacing.SOUTH).setName("port.rs_ctr.ra"), new MountedPort((IPortProvider)this, 3, SignalHandler.class, true).setLocation(0.125, 0.875, 0.25, EnumFacing.SOUTH).setName("port.rs_ctr.rv")};
        this.setMode(112);
        this.memory = new int[this.memSize()];
    }

    public SignalHandler getPortCallback(int pin) {
        switch (pin) {
            case 0: {
                return this::updateAddr;
            }
            case 1: {
                return this::updateVal;
            }
        }
        return this;
    }

    public void setPortCallback(int pin, Object callback) {
        this.out = callback instanceof SignalHandler ? (SignalHandler)callback : SignalHandler.NOP;
    }

    @Override
    protected void resetPin(int pin) {
        this.getPortCallback(pin).updateSignal(pin == 1 ? 0 : -1);
    }

    public void updateSignal(int value) {
        int v = 0;
        if (value >= 0 && value <= this.addrMask) {
            this.readIN = value;
            this.doWrite();
            v = this.get(value);
        } else {
            this.readIN = -1;
        }
        if (v != this.valueOUT) {
            this.valueOUT = v;
            this.out.updateSignal(this.valueOUT);
        }
    }

    public void updateVal(int value) {
        if (value == this.valueIN) {
            return;
        }
        this.doWrite();
        this.valueIN = value;
        this.scheduleWrite();
    }

    public void updateAddr(int value) {
        if (value < 0 || value > this.addrMask) {
            value = -1;
        }
        if (value == this.writeIN) {
            return;
        }
        this.doWrite();
        this.writeIN = value;
        this.scheduleWrite();
    }

    private void scheduleWrite() {
        if (this.writeIN < 0) {
            return;
        }
        this.needWrite = true;
        this.scheduledTime = this.field_145850_b.func_82737_E();
        if (this.writeIN == this.readIN) {
            TickRegistry.schedule((TickRegistry.IUpdatable)this);
        }
    }

    private void doWrite() {
        if (!this.needWrite || this.field_145850_b.func_82737_E() <= this.scheduledTime) {
            return;
        }
        this.needWrite = false;
        int val = this.valueIN;
        int addr = this.writeIN & this.addrMask;
        int a = addr >> (this.mode & 3);
        switch (this.mode & 3) {
            case 0: {
                this.memory[a] = val;
                break;
            }
            case 1: {
                this.memory[a] = (addr & 1) == 0 ? this.memory[a] & 0xFFFF0000 | val & 0xFFFF : this.memory[a] & 0xFFFF | val << 16;
                break;
            }
            case 2: {
                addr = (addr & 3) << 3;
                this.memory[a] = this.memory[a] & ~(255 << addr) | (val & 0xFF) << addr;
                break;
            }
            default: {
                addr = (addr & 7) << 2;
                this.memory[a] = this.memory[a] & ~(15 << addr) | (val & 0xF) << addr;
            }
        }
    }

    public int get(int addr) {
        addr &= this.addrMask;
        switch (this.mode & 3) {
            case 0: {
                return this.memory[addr];
            }
            case 1: {
                return (addr & 1) == 0 ? this.memory[addr >> 1] & 0xFFFF : this.memory[addr >> 1] >>> 16;
            }
            case 2: {
                return this.memory[addr >> 2] >> ((addr & 3) << 3) & 0xFF;
            }
        }
        return this.memory[addr >> 3] >> ((addr & 7) << 2) & 0xF;
    }

    public void setMode(int m) {
        this.mode = (byte)m;
        this.addrMask = (1 << (m >> 4 & 0xF) + (m & 3)) - 1;
    }

    public int memSize() {
        return 1 << (this.mode >> 4 & 0xF);
    }

    public void process() {
        this.updateSignal(this.readIN);
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        super.storeState(nbt, mode);
        if (mode == 0 || mode == 4) {
            this.scheduledTime = -1L;
            this.doWrite();
            nbt.func_74783_a("mem", this.memory);
            nbt.func_74774_a("mode", this.mode);
            if (mode == 0) {
                nbt.func_74768_a("addr", this.writeIN);
                nbt.func_74768_a("val", this.valueIN);
                nbt.func_74768_a("out", this.valueOUT);
            }
        }
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        super.loadState(nbt, mode);
        if (mode == 1) {
            this.memory = new int[64];
        } else if (mode == 0 || mode == 4) {
            this.setMode(nbt.func_74771_c("mode"));
            this.memory = Arrays.copyOf(nbt.func_74759_k("mem"), this.memSize());
            if (mode == 0) {
                this.writeIN = nbt.func_74762_e("addr");
                this.valueIN = nbt.func_74762_e("val");
                this.valueOUT = nbt.func_74762_e("out");
                this.needWrite = false;
            }
        }
    }

    public AdvancedContainer getContainer(EntityPlayer player, int id) {
        AdvancedContainer c = new AdvancedContainer((AdvancedContainer.IStateInteractionHandler)this, ssb.build(this.field_145850_b.field_72995_K), player);
        if (this.field_145850_b.field_72995_K) {
            if (this.memory.length != 64) {
                this.memory = new int[64];
            } else {
                Arrays.fill(this.memory, 0);
            }
        }
        return c;
    }

    public void writeState(StateSyncServer state, AdvancedContainer cont) {
        int i;
        PacketBuffer b = state.buffer;
        b.writeInt(this.readIN).writeInt(this.writeIN).writeByte((int)this.mode).writeByte((int)this.page);
        int m = this.memory.length - 1;
        int l = i + 64;
        for (i = (this.page & 0xFF) << 6; i < l; ++i) {
            b.writeInt(i <= m ? this.memory[i] : 0);
        }
        state.endFixed().putAll(new Object[]{ArrayUtils.EMPTY_INT_ARRAY});
    }

    public void readState(StateSyncClient state, AdvancedContainer cont) {
        this.readIN = state.get(this.readIN);
        this.writeIN = state.get(this.writeIN);
        this.setMode(state.get((int)this.mode));
        this.page = (byte)state.get((int)this.page);
        for (int i = 0; i < 64; ++i) {
            this.memory[i] = state.get(this.memory[i]);
        }
        if (!state.next()) {
            return;
        }
        int l = state.buffer.func_150792_a();
        if (l <= 0) {
            return;
        }
        byte[] mem = new byte[l << 2];
        state.buffer.readBytes(mem);
        if (this.field_145850_b.field_72995_K && Minecraft.func_71410_x().field_71462_r instanceof GuiRAM) {
            ((GuiRAM)Minecraft.func_71410_x().field_71462_r).processDownload(mem);
        }
    }

    public boolean canInteract(EntityPlayer player, AdvancedContainer cont) {
        return this.canPlayerAccessUI(player);
    }

    public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        switch (pkt.readByte()) {
            case 0: {
                this.setMode(this.mode & 0xF0 | pkt.readByte() & 3);
                break;
            }
            case 1: {
                this.page = pkt.readByte();
                if (this.page <= 0) {
                    this.page = 0;
                    break;
                }
                if (this.page < this.memory.length >> 6) break;
                this.page = (byte)Math.max(0, (this.memory.length >> 6) - 1);
                break;
            }
            case 2: {
                int i = pkt.readShort() & 0xFFFF;
                byte v = pkt.readByte();
                int bit = (i & 7) * 4;
                int idx = i >> 3;
                if (idx >= this.memory.length) break;
                this.memory[idx] = v << bit | this.memory[idx] & ~(15 << bit);
                if (this.readIN != i >> 3 - this.mode) break;
                TickRegistry.schedule((TickRegistry.IUpdatable)this);
                break;
            }
            case 3: {
                if (!(sender.field_71070_bA instanceof AdvancedContainer)) break;
                AdvancedContainer c = (AdvancedContainer)sender.field_71070_bA;
                StateSyncServer sss = ((StateSyncServer)c.sync).begin();
                pkt = sss.buffer;
                pkt.func_150787_b(this.memory.length);
                for (int i : this.memory) {
                    pkt.writeIntLE(i);
                }
                sss.set(68);
                pkt = sss.encodePacket();
                if (pkt == null) break;
                GuiNetworkHandler.GNH_INSTANCE.sendToPlayer(pkt, sender);
                break;
            }
            case 4: {
                int l = pkt.readUnsignedShort();
                if (l > this.memory.length) {
                    return;
                }
                for (int i = 0; i < l; ++i) {
                    this.memory[i] = pkt.readIntLE();
                }
                Arrays.fill(this.memory, l, this.memory.length, 0);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("msg.rs_ctr.import_succ", new Object[0]));
                TickRegistry.schedule((TickRegistry.IUpdatable)this);
                break;
            }
            default: {
                return;
            }
        }
        this.markDirty(0);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiRAM getGuiScreen(EntityPlayer player, int id) {
        return new GuiRAM(this, player);
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        this.setMode(item.func_77960_j() << 4);
        if (item.func_77942_o()) {
            this.loadState(item.func_77978_p(), 4);
        } else {
            this.memory = new int[this.memSize()];
        }
    }

    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        ItemStack stack = new ItemStack((Item)Objects.ram, 1, this.mode >> 4 & 0xF);
        NBTTagCompound nbt = new NBTTagCompound();
        this.storeState(nbt, 4);
        stack.func_77982_d(nbt);
        return Arrays.asList(stack);
    }

    @Override
    public Object getState(int id) {
        switch (id) {
            case 0: {
                return this.writeIN;
            }
            case 1: {
                return this.valueOUT;
            }
            case 2: {
                return this.readIN;
            }
        }
        return this.valueOUT;
    }
}

