/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.gui.BlockButton;
import cd4017be.rs_ctr.tileentity.SignalCombiner;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class NummericCombiner
extends SignalCombiner {
    byte inModes;
    BlockButton[] buttons = new BlockButton[4];

    public NummericCombiner() {
        for (int i = 0; i < 4; ++i) {
            int pin = i;
            this.buttons[i] = new BlockButton(a -> {
                this.inModes = (byte)(this.inModes ^ 1 << pin);
                this.refreshInput(pin);
                this.markDirty(3);
            }, () -> "_buttons.num(" + (this.inModes >> pin & 1) + ")", () -> TooltipUtil.translate((String)("port.rs_ctr.num" + (this.inModes >> pin & 1)))).setSize(0.0625f, 0.0625f);
        }
    }

    @Override
    protected int computeResult() {
        return this.inputs[0] + this.inputs[1] + this.inputs[2] + this.inputs[3];
    }

    @Override
    public SignalHandler getPortCallback(int pin) {
        if ((this.inModes >> pin & 1) == 0) {
            return super.getPortCallback(pin);
        }
        return val -> this.setInput(pin, -val);
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        nbt.func_74774_a("mode", this.inModes);
        super.storeState(nbt, mode);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        this.inModes = nbt.func_74771_c("mode");
        super.loadState(nbt, mode);
    }

    @Override
    protected void initGuiComps(List<IInteractiveComponent> list) {
        Collections.addAll(list, this.buttons);
    }

    @Override
    protected void orient(Orientation o) {
        for (int i = 0; i < 4; ++i) {
            this.buttons[i].setLocation(0.375, 0.125f + (float)i * 0.25f, 0.25, o);
        }
        super.orient(o);
    }

    @Override
    public Object getState(int id) {
        if (id < 4 && (this.inModes >> id & 1) != 0) {
            return -this.inputs[id];
        }
        return super.getState(id);
    }
}

