/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.frame.IFrameOperator;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.render.HybridFastTESR;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.gui.BlockButton;
import cd4017be.rs_ctr.render.FrameRenderer;
import cd4017be.rs_ctr.render.ISpecialRenderComp;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import java.util.Collections;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSelector
extends WallMountGate
implements IFrameOperator,
TickRegistry.IUpdatable,
IntConsumer,
Supplier<String>,
ISpecialRenderComp,
IInteractiveComponent.ITESRenderComp {
    public static int RANGE = 64;
    BlockButton[] buttons = new BlockButton[4];
    public int[] area = new int[6];
    public byte missingFrames = (byte)-1;
    public byte invertAxis;
    BlockReference.BlockHandler out;
    public int sx;
    public int sy;
    public int sz;
    byte tick;
    boolean delayed;
    boolean showFrame = true;

    public BlockSelector() {
        this.ports = new MountedPort[]{new MountedPort((IPortProvider)this, 0, SignalHandler.class, false).setName("port.rs_ctr.x").setLocation(0.875, 0.125, 0.0, EnumFacing.NORTH), new MountedPort((IPortProvider)this, 1, SignalHandler.class, false).setName("port.rs_ctr.y").setLocation(0.625, 0.125, 0.0, EnumFacing.NORTH), new MountedPort((IPortProvider)this, 2, SignalHandler.class, false).setName("port.rs_ctr.z").setLocation(0.375, 0.125, 0.0, EnumFacing.NORTH), new MountedPort((IPortProvider)this, 3, BlockReference.BlockHandler.class, true).setName("port.rs_ctr.bo").setLocation(0.125, 0.125, 0.0, EnumFacing.NORTH)};
        for (int i = 0; i < 3; ++i) {
            int ax = i;
            this.buttons[i] = new BlockButton(a -> this.invert(ax), () -> "_buttons.num(" + (this.invertAxis >> ax & 1) + ")", () -> TooltipUtil.translate((String)("port.rs_ctr.invax" + (this.invertAxis >> ax & 1)))).setSize(0.0625f, 0.0625f);
        }
        this.buttons[3] = new BlockButton(this, () -> null, this).setSize(0.5f, 0.25f);
    }

    public SignalHandler getPortCallback(int pin) {
        switch (pin) {
            case 0: {
                return val -> {
                    if (val == this.sx) {
                        return;
                    }
                    this.onInputChange();
                    this.sx = val;
                };
            }
            case 1: {
                return val -> {
                    if (val == this.sy) {
                        return;
                    }
                    this.onInputChange();
                    this.sy = val;
                };
            }
            case 2: {
                return val -> {
                    if (val == this.sz) {
                        return;
                    }
                    this.onInputChange();
                    this.sz = val;
                };
            }
        }
        return null;
    }

    public void setPortCallback(int pin, Object callback) {
        if (callback instanceof BlockReference.BlockHandler) {
            this.out = (BlockReference.BlockHandler)callback;
            this.out.updateBlock(this.getOutput());
        } else {
            this.out = null;
        }
    }

    @Override
    protected void resetPin(int pin) {
        this.getPortCallback(pin).updateSignal(0);
    }

    private void onInputChange() {
        if (this.tick == 0) {
            this.tick = TickRegistry.TICK;
            TickRegistry.schedule((TickRegistry.IUpdatable)this);
        } else if (this.tick != TickRegistry.TICK) {
            this.process();
            this.tick = TickRegistry.TICK;
            this.delayed = true;
        }
    }

    public void process() {
        if (this.delayed) {
            this.delayed = false;
            TickRegistry.schedule((TickRegistry.IUpdatable)this);
            return;
        }
        this.tick = 0;
        if (this.out != null) {
            this.out.updateBlock(this.getOutput());
        }
        this.markDirty(2);
    }

    private BlockReference getOutput() {
        BlockPos p = this.selBlock();
        return p == null ? null : new BlockReference(this.field_145850_b, p, this.getOrientation().front);
    }

    private BlockPos selBlock() {
        if (this.missingFrames != 0 || this.sx < 0 || this.sy < 0 || this.sz < 0 || this.sx >= this.area[3] || this.sy >= this.area[4] || this.sz >= this.area[5]) {
            return null;
        }
        int x = this.sx;
        int y = this.sy;
        int z = this.sz;
        byte inv = this.invertAxis;
        if ((inv & 1) != 0) {
            x = this.area[3] - x - 1;
        }
        if ((inv & 2) != 0) {
            y = this.area[4] - y - 1;
        }
        if ((inv & 4) != 0) {
            z = this.area[5] - z - 1;
        }
        return new BlockPos(x + this.area[0], y + this.area[1], z + this.area[2]);
    }

    @Override
    public void onFrameBreak(BlockPos pos) {
        int i = 0;
        int d = pos.func_177958_n() - this.area[0];
        if (d == this.area[3]) {
            i |= 1;
        } else if (d != -1) {
            return;
        }
        d = pos.func_177956_o() - this.area[1];
        if (d == this.area[4] - 1) {
            i |= 2;
        } else if (d != 0) {
            return;
        }
        d = pos.func_177952_p() - this.area[2];
        if (d == this.area[5]) {
            i |= 4;
        } else if (d != -1) {
            return;
        }
        this.missingFrames = (byte)(this.missingFrames | 1 << i);
        this.markDirty(2);
    }

    @Override
    public String get() {
        if (Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
            return TooltipUtil.translate((String)("port.rs_ctr.show_sel" + (this.showFrame ? (char)'1' : '0')));
        }
        int dx = this.area[3];
        int dy = this.area[4];
        int dz = this.area[5];
        char status = dx <= 0 || dy <= 0 || dz <= 0 ? (char)'2' : (this.missingFrames != 0 ? (char)'1' : '0');
        return TooltipUtil.format((String)("port.rs_ctr.area" + status), (Object[])new Object[]{dx, dy, dz, Integer.bitCount(this.missingFrames & 0xFF)});
    }

    @Override
    public void accept(int value) {
        if ((value & 1) != 0) {
            return;
        }
        if ((value & 2) == 0) {
            if (this.area[3] <= 0 || this.area[4] <= 0 || this.area[5] <= 0 || (this.missingFrames = (byte)IFrameOperator.checkCorners(this.field_145850_b, this.field_174879_c, this.area)) != 0) {
                IFrameOperator.unlinkCorners(this.field_145850_b, this.field_174879_c, this.area, ~this.missingFrames);
                IFrameOperator.scanArea(this.field_145850_b, this.field_174879_c, this.area, RANGE, this.getOrientation().front);
                this.fallbackArea();
                this.missingFrames = (byte)IFrameOperator.checkCorners(this.field_145850_b, this.field_174879_c, this.area);
            }
        } else {
            this.showFrame = !this.showFrame;
        }
        this.markDirty(2);
    }

    private void fallbackArea() {
        if (this.area[3] > 0 && this.area[4] > 0 && this.area[5] > 0) {
            return;
        }
        if (this.sx <= 0 || this.sx > RANGE || this.sy <= 0 || this.sy > RANGE || this.sz <= 0 || this.sz > RANGE) {
            return;
        }
        this.area[0] = this.field_174879_c.func_177958_n() - ((this.invertAxis & 1) != 0 ? this.sx : -1);
        this.area[1] = this.field_174879_c.func_177956_o() - ((this.invertAxis & 2) != 0 ? this.sy - 1 : 0);
        this.area[2] = this.field_174879_c.func_177952_p() - ((this.invertAxis & 4) != 0 ? this.sz : -1);
        this.area[3] = this.sx;
        this.area[4] = this.sy;
        this.area[5] = this.sz;
    }

    private void invert(int ax) {
        this.invertAxis = (byte)(this.invertAxis ^ 1 << ax);
        this.onInputChange();
        this.markDirty(3);
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        nbt.func_74768_a("sx", this.sx);
        nbt.func_74768_a("sy", this.sy);
        nbt.func_74768_a("sz", this.sz);
        IFrameOperator.writeArea(this.area, nbt, this.field_174879_c);
        nbt.func_74774_a("frame", this.missingFrames);
        nbt.func_74757_a("dsp", this.showFrame);
        nbt.func_74774_a("inv", this.invertAxis);
        super.storeState(nbt, mode);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        this.sx = nbt.func_74762_e("sx");
        this.sy = nbt.func_74762_e("sy");
        this.sz = nbt.func_74762_e("sz");
        IFrameOperator.readArea(this.area, nbt, this.field_174879_c);
        this.missingFrames = nbt.func_74771_c("frame");
        this.showFrame = nbt.func_74767_n("dsp");
        this.invertAxis = nbt.func_74771_c("inv");
        super.loadState(nbt, mode);
    }

    @Override
    public void breakBlock() {
        super.breakBlock();
        IFrameOperator.unlinkCorners(this.field_145850_b, this.field_174879_c, this.area, ~this.missingFrames);
    }

    @Override
    protected void initGuiComps(List<IInteractiveComponent> list) {
        Collections.addAll(list, this.buttons);
    }

    @Override
    protected void orient(Orientation o) {
        Orientation opp = Orientation.values()[o.ordinal() + 2 & 3];
        for (int i = 0; i < 3; ++i) {
            this.buttons[i].setLocation(0.125 + (double)i * 0.25, 0.375, 1.0, opp);
        }
        this.buttons[3].setLocation(0.5, 0.75, 0.0, o);
        super.orient(o);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpecial(double x, double y, double z, float t, FontRenderer fr) {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        int mf = this.missingFrames & 0xFF;
        if (mf == 0) {
            return;
        }
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        int i = 0;
        while (i < 8) {
            if ((mf & 1) != 0) {
                BlockPos p = IFrameOperator.getCorner(this.area, i).func_177973_b((Vec3i)this.field_174879_c);
                double x1 = x + (double)p.func_177958_n();
                double y1 = y + (double)p.func_177956_o();
                double z1 = z + (double)p.func_177952_p();
                RenderGlobal.func_189694_a((double)x1, (double)y1, (double)z1, (double)(x1 + 1.0), (double)(y1 + 1.0), (double)(z1 + 1.0), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            ++i;
            mf >>= 1;
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasFastRenderer() {
        return this.missingFrames == 0 && !HybridFastTESR.isAimedAt((TileEntity)this);
    }

    public double func_145833_n() {
        int d = this.area[3];
        double d2 = super.func_145833_n() + (double)(d * d);
        d = this.area[4];
        double d3 = d2 + (double)(d * d);
        d = this.area[5];
        return d3 + (double)(d * d);
    }

    public void render(World world, BlockPos pos, double x, double y, double z, int light, BufferBuilder buffer) {
        BlockPos p = this.selBlock();
        if (p != null) {
            FrameRenderer.renderBeam(x + 0.5, y + 0.5, z + 0.5, p.func_177958_n() - pos.func_177958_n(), p.func_177956_o() - pos.func_177956_o(), p.func_177952_p() - pos.func_177952_p(), this.getOrientation().front, buffer, 0x7FFFFF00);
        }
        if (this.showFrame) {
            FrameRenderer.renderFrame(x - 0.0625, y - 0.0625, z - 0.0625, (x += (double)(this.area[0] - pos.func_177958_n())) + (double)this.area[3] + 0.0625, (y += (double)(this.area[1] - pos.func_177956_o())) + (double)this.area[4] + 0.0625, (z += (double)(this.area[2] - pos.func_177952_p())) + (double)this.area[5] + 0.0625, buffer, this.missingFrames == 0 ? 0x7F00FF00 : 0x7F0000FF);
        }
    }

    public AxisAlignedBB getRenderBB(World world, BlockPos pos) {
        return new AxisAlignedBB((double)(this.area[0] - 1), (double)this.area[1], (double)(this.area[2] - 1), (double)(this.area[0] + this.area[3] + 1), (double)(this.area[1] + this.area[4]), (double)(this.area[2] + this.area[5] + 1));
    }

    @Override
    public Object getState(int id) {
        switch (id) {
            case 0: {
                return this.sx;
            }
            case 1: {
                return this.sy;
            }
            case 2: {
                return this.sz;
            }
        }
        return this.getOutput();
    }
}

