/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import java.util.Arrays;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class BlockDeserializer
extends WallMountGate
implements BlockReference.BlockHandler {
    private final SignalHandler[] out;
    private int refX;
    private int refY;
    private int refZ;
    private BlockReference block;

    public BlockDeserializer() {
        this.ports = new MountedPort[]{new MountedPort((IPortProvider)this, 0, BlockReference.BlockHandler.class, false).setName("port.rs_ctr.bi").setLocation(0.25, 0.125, 0.125, EnumFacing.WEST), new MountedPort((IPortProvider)this, 1, SignalHandler.class, false).setName("port.rs_ctr.refx").setLocation(0.25, 0.375, 0.125, EnumFacing.WEST), new MountedPort((IPortProvider)this, 2, SignalHandler.class, false).setName("port.rs_ctr.refy").setLocation(0.25, 0.625, 0.125, EnumFacing.WEST), new MountedPort((IPortProvider)this, 3, SignalHandler.class, false).setName("port.rs_ctr.refz").setLocation(0.25, 0.875, 0.125, EnumFacing.WEST), new MountedPort((IPortProvider)this, 4, SignalHandler.class, true).setName("port.rs_ctr.dim").setLocation(0.75, 0.125, 0.125, EnumFacing.EAST), new MountedPort((IPortProvider)this, 5, SignalHandler.class, true).setName("port.rs_ctr.xo").setLocation(0.75, 0.375, 0.125, EnumFacing.EAST), new MountedPort((IPortProvider)this, 6, SignalHandler.class, true).setName("port.rs_ctr.yo").setLocation(0.75, 0.625, 0.125, EnumFacing.EAST), new MountedPort((IPortProvider)this, 7, SignalHandler.class, true).setName("port.rs_ctr.zo").setLocation(0.75, 0.875, 0.125, EnumFacing.EAST)};
        this.out = new SignalHandler[4];
        Arrays.fill(this.out, SignalHandler.NOP);
    }

    public Object getPortCallback(int pin) {
        switch (pin) {
            case 1: {
                return v -> {
                    this.refX = v;
                };
            }
            case 2: {
                return v -> {
                    this.refY = v;
                };
            }
            case 3: {
                return v -> {
                    this.refZ = v;
                };
            }
        }
        return this;
    }

    public void setPortCallback(int pin, Object callback) {
        SignalHandler h;
        this.out[pin - 4] = h = callback instanceof SignalHandler ? (SignalHandler)callback : SignalHandler.NOP;
        h.updateSignal(this.out(pin - 4));
    }

    @Override
    protected void resetPin(int pin) {
        if (pin == 0) {
            this.updateBlock(new BlockReference(this.field_145850_b, this.field_174879_c, this.o.front));
        } else {
            ((SignalHandler)this.getPortCallback(pin)).updateSignal(0);
        }
    }

    public void updateBlock(BlockReference ref) {
        if (BlockReference.equal((BlockReference)ref, (BlockReference)this.block)) {
            return;
        }
        this.block = ref;
        for (int i = 0; i < 4; ++i) {
            this.out[i].updateSignal(this.out(i));
        }
    }

    private int out(int i) {
        switch (i) {
            default: {
                return this.block == null ? Integer.MIN_VALUE : this.block.dim;
            }
            case 1: {
                return this.block == null ? 0 : this.block.pos.func_177958_n() - this.refX;
            }
            case 2: {
                return this.block == null ? 0 : this.block.pos.func_177956_o() - this.refY;
            }
            case 3: 
        }
        return this.block == null ? 0 : this.block.pos.func_177952_p() - this.refZ;
    }

    @Override
    public Object getState(int pin) {
        switch (pin) {
            case 0: {
                return this.block;
            }
            case 1: {
                return this.refX;
            }
            case 2: {
                return this.refY;
            }
            case 3: {
                return this.refZ;
            }
        }
        return this.out(pin - 4);
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        super.storeState(nbt, mode);
        if (mode == 0) {
            if (this.block != null) {
                nbt.func_74782_a("block", (NBTBase)this.block.serializeNBT());
            }
            nbt.func_74768_a("refX", this.refX);
            nbt.func_74768_a("refY", this.refY);
            nbt.func_74768_a("refZ", this.refZ);
        }
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        super.loadState(nbt, mode);
        if (mode == 0) {
            this.block = nbt.func_150297_b("block", 10) ? new BlockReference(nbt.func_74775_l("block")) : null;
            this.refX = nbt.func_74762_e("refX");
            this.refY = nbt.func_74762_e("refY");
            this.refZ = nbt.func_74762_e("refZ");
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.ports[0].getConnector() == null && !this.field_145850_b.field_72995_K) {
            this.resetPin(0);
        }
    }
}

