/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.port;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.port.SplitPlug;
import cd4017be.rs_ctr.port.WireType;
import java.util.Arrays;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SignalSplitPlug
extends SplitPlug
implements SignalHandler {
    SignalHandler[] callbacks;
    int lastValue;

    public SignalSplitPlug(MountedPort port) {
        super(port);
    }

    @Override
    public int addLinks(int n) {
        n = super.addLinks(n);
        this.callbacks = this.callbacks == null ? new SignalHandler[n] : Arrays.copyOf(this.callbacks, this.wires.length);
        Arrays.fill(this.callbacks, this.callbacks.length - n, this.callbacks.length, SignalHandler.NOP);
        return n;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.callbacks = new SignalHandler[this.wires.length];
        Arrays.fill(this.callbacks, SignalHandler.NOP);
    }

    public void setPortCallback(int pin, Object callback) {
        if (callback instanceof SignalHandler) {
            SignalHandler signalHandler = (SignalHandler)callback;
            this.callbacks[pin - 1] = signalHandler;
            signalHandler.updateSignal(this.lastValue);
        } else {
            this.callbacks[pin - 1] = SignalHandler.NOP;
        }
    }

    @Override
    protected WireType type() {
        return WireType.SIGNAL;
    }

    @Override
    protected ItemStack drop() {
        return new ItemStack((Item)Objects.split_s, this.wires.length);
    }

    public void updateSignal(int value) {
        if (value == this.lastValue) {
            return;
        }
        this.lastValue = value;
        for (SignalHandler h : this.callbacks) {
            h.updateSignal(value);
        }
    }
}

