/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.port;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.Connector;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.port.WireType;
import cd4017be.rs_ctr.render.PortRenderer;
import cd4017be.rs_ctr.render.WireRenderer;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockProbe
extends Connector
implements IInteractiveComponent.IBlockRenderComp,
IInteractiveComponent.ITESRenderComp {
    public static final String ID = "blockProbe";
    private BlockPos linkPos;
    private EnumFacing linkFace;
    private float[] vertices;
    private int light1 = -1;

    public BlockProbe(MountedPort port, BlockPos linkPos, EnumFacing linkFace) {
        super(port);
        this.linkPos = linkPos.func_177973_b((Vec3i)port.getPos());
        this.linkFace = linkFace;
    }

    public BlockProbe(MountedPort port) {
        super(port);
    }

    protected String id() {
        return ID;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74772_a("pos", this.linkPos.func_177986_g());
        nbt.func_74774_a("side", (byte)this.linkFace.func_176745_a());
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.linkPos = BlockPos.func_177969_a((long)nbt.func_74763_f("pos"));
        this.linkFace = EnumFacing.func_82600_a((int)nbt.func_74771_c("side"));
    }

    public void onRemoved(EntityPlayer player) {
        this.port.owner.onPortModified((Port)this.port, 2);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("lx", this.linkPos.func_177958_n());
        nbt.func_74768_a("ly", this.linkPos.func_177956_o());
        nbt.func_74768_a("lz", this.linkPos.func_177952_p());
        nbt.func_74774_a("lf", (byte)this.linkFace.func_176745_a());
        ItemStack stack = new ItemStack((Item)Objects.block_plug);
        stack.func_77982_d(nbt);
        this.dropItem(stack, player);
    }

    public String displayInfo(MountedPort port, int linkID) {
        String name = port.getWorld().func_180495_p(port.getPos().func_177971_a((Vec3i)this.linkPos)).func_177230_c().func_149732_F();
        if (name.endsWith(".name")) {
            name = name.substring(0, name.length() - 5);
        }
        return "\n\u00a7b" + name + "\u00a7f " + TooltipUtil.translate((String)("enumfacing." + this.linkFace.name().toLowerCase()));
    }

    public void onLoad() {
        ((BlockReference.BlockHandler)this.port.owner.getPortCallback(this.port.pin)).updateBlock(new BlockReference(this.port.getWorld(), this.port.getPos().func_177971_a((Vec3i)this.linkPos), this.linkFace));
    }

    @SideOnly(value=Side.CLIENT)
    public void render(World world, BlockPos pos, double x, double y, double z, int light, BufferBuilder buffer) {
        if (this.vertices == null) {
            double dx = (double)this.linkFace.func_82601_c() * 0.375 + (double)this.linkPos.func_177958_n() + 0.5 - (double)this.port.face.func_82601_c() * 0.125;
            double dy = (double)this.linkFace.func_96559_d() * 0.375 + (double)this.linkPos.func_177956_o() + 0.5 - (double)this.port.face.func_96559_d() * 0.125;
            double dz = (double)this.linkFace.func_82599_e() * 0.375 + (double)this.linkPos.func_177952_p() + 0.5 - (double)this.port.face.func_82599_e() * 0.125;
            this.vertices = WireRenderer.createLine(this.port, new Vec3d(dx, dy, dz).func_178788_d(this.port.pos));
        }
        if (this.light1 < 0) {
            this.light1 = this.port.getWorld().func_175626_b(pos.func_177971_a((Vec3i)this.linkPos).func_177972_a(this.linkFace), 0);
        }
        WireRenderer.drawLine(buffer, this.vertices, (float)x, (float)y, (float)z, light, this.light1, -256);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(List<BakedQuad> quads) {
        this.light1 = -1;
        PortRenderer.PORT_RENDER.drawModel(quads, (float)this.port.pos.field_72450_a, (float)this.port.pos.field_72448_b, (float)this.port.pos.field_72449_c, Orientation.fromFacing((EnumFacing)this.port.face), WireType.BLOCK.wireModel());
    }

    public AxisAlignedBB getRenderBB(World world, BlockPos pos) {
        return new AxisAlignedBB(new Vec3d((Vec3i)pos).func_178787_e(this.port.pos), new Vec3d((Vec3i)new BlockPos(1, 1, 1).func_177971_a(this.linkFace.func_176730_m())).func_186678_a(0.5).func_178787_e(new Vec3d((Vec3i)pos.func_177971_a((Vec3i)this.linkPos))));
    }
}

