/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.item;

import cd4017be.api.rs_ctr.port.Connector;
import cd4017be.api.rs_ctr.port.IIntegratedConnector;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.api.rs_ctr.wire.RelayPort;
import cd4017be.api.rs_ctr.wire.WiredConnector;
import cd4017be.lib.item.BaseItem;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.port.WireBranch;
import cd4017be.rs_ctr.port.WireConnection;
import cd4017be.rs_ctr.port.WireType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ItemWireCon
extends BaseItem
implements WiredConnector.IWiredConnectorItem {
    public static int MAX_LENGTH = 16;
    public final WireType type;

    public ItemWireCon(String id, WireType type) {
        super(id);
        this.type = type;
    }

    public void doAttach(ItemStack stack, MountedPort port, EntityPlayer player) {
        WireBranch conB;
        WireBranch conA;
        int lz;
        int ly;
        int lx;
        int d;
        if (port.type != this.type.clazz && port.type != null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.rs_ctr.type", new Object[0]));
            return;
        }
        boolean creative = player.func_184812_l_();
        NBTTagCompound nbt = stack.func_77978_p();
        BlockPos pos = port.getPos();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
            nbt.func_74768_a("lx", pos.func_177958_n());
            nbt.func_74768_a("ly", pos.func_177956_o());
            nbt.func_74768_a("lz", pos.func_177952_p());
            nbt.func_74768_a("lp", port.pin);
            nbt.func_74757_a("d", port.isMaster);
            return;
        }
        stack.func_77982_d(null);
        if (!nbt.func_74767_n("d") ^ port.isMaster) {
            if (port instanceof RelayPort) {
                port = ((RelayPort)port).opposite;
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(TooltipUtil.translate((String)"msg.rs_ctr.wire0")));
                return;
            }
        }
        if ((d = (int)Math.ceil(pos.func_185332_f(lx = nbt.func_74762_e("lx"), ly = nbt.func_74762_e("ly"), lz = nbt.func_74762_e("lz")))) > MAX_LENGTH || !creative && d > stack.func_190916_E()) {
            player.func_145747_a((ITextComponent)new TextComponentString(d > MAX_LENGTH ? TooltipUtil.format((String)"msg.rs_ctr.wire2", (Object[])new Object[]{MAX_LENGTH}) : TooltipUtil.translate((String)"msg.rs_ctr.wire1")));
            return;
        }
        BlockPos lpos = new BlockPos(lx, ly, lz);
        Port p = IPortProvider.getPort((World)player.field_70170_p, (BlockPos)lpos, (int)nbt.func_74762_e("lp"));
        if (!(p instanceof MountedPort)) {
            player.func_145747_a((ITextComponent)new TextComponentString(TooltipUtil.translate((String)"msg.rs_ctr.wire3")));
            return;
        }
        MountedPort lport = (MountedPort)p;
        Connector con = port.getConnector();
        if (con instanceof IIntegratedConnector) {
            conA = new WireBranch(port, this.type);
            if (!((IIntegratedConnector)con).addWire((WiredConnector)conA, player, true)) {
                return;
            }
        } else {
            conA = new WireConnection(port, this.type);
        }
        if ((con = lport.getConnector()) instanceof IIntegratedConnector) {
            conB = new WireBranch(lport, this.type);
            if (!((IIntegratedConnector)con).addWire((WiredConnector)conB, player, false)) {
                return;
            }
        } else {
            conB = new WireConnection(lport, this.type);
            lport.setConnector((Connector)conB, player);
        }
        if ((con = port.getConnector()) instanceof IIntegratedConnector) {
            ((IIntegratedConnector)con).addWire((WiredConnector)conA, player, false);
        } else {
            port.setConnector((Connector)conA, player);
        }
        conA.length = d / 2;
        conB.length = d - conA.length;
        if (!player.func_184812_l_()) {
            stack.func_190918_g(d);
        }
        conA.connect(conB);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            ItemStack stack = player.func_184586_b(hand);
            stack.func_77982_d(null);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!isSelected) {
            return;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return;
        }
        Vec3d start = entity.func_174824_e(1.0f);
        RayTraceResult rt = world.func_72933_a(start, start.func_178787_e(entity.func_70676_i(1.0f).func_186678_a(3.0)));
        BlockPos pos = rt == null ? entity.func_180425_c() : rt.func_178782_a();
        nbt.func_74768_a("n", (int)Math.ceil(pos.func_185332_f(nbt.func_74762_e("lx"), nbt.func_74762_e("ly"), nbt.func_74762_e("lz"))));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77978_p() != null;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        return (double)nbt.func_74762_e("n") / (double)Math.min(stack.func_190916_E(), MAX_LENGTH);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.func_77969_a(newStack);
    }
}

