/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.item;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.Connector;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.Link;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.lib.Gui.AdvancedContainer;
import cd4017be.lib.Gui.ItemInteractionHandler;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.item.BaseItem;
import cd4017be.lib.network.GuiNetworkHandler;
import cd4017be.lib.network.IGuiHandlerItem;
import cd4017be.lib.network.IPlayerPacketReceiver;
import cd4017be.lib.network.StateSyncClient;
import cd4017be.lib.network.StateSyncServer;
import cd4017be.lib.network.StateSynchronizer;
import cd4017be.lib.network.SyncNetworkHandler;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.gui.GuiRemoteKeybind;
import cd4017be.rs_ctr.port.RemoteReceiver;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemRemoteControl
extends BaseItem
implements Connector.IConnectorItem,
IPlayerPacketReceiver.ItemPPR,
IGuiHandlerItem {
    Byte2ObjectOpenHashMap<KeyState> keyStates = new Byte2ObjectOpenHashMap();
    long lastTick;

    public ItemRemoteControl(String id) {
        super(id);
        this.func_77625_d(1);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void doAttach(ItemStack stack, MountedPort port, EntityPlayer player) {
        if (port.type != SignalHandler.class) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.rs_ctr.type", new Object[0]));
            return;
        }
        if (port.isMaster) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.rs_ctr.dir_in", new Object[0]));
            return;
        }
        NBTTagCompound nbt = ItemFluidUtil.createTag((ItemStack)stack);
        Sender s = ItemRemoteControl.getSender(nbt);
        if (s != null) {
            s.kill();
        }
        nbt.func_74768_a("link", 0);
        port.setConnector((Connector)new RemoteReceiver(port), player);
        port.connect(new Sender(nbt).port);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af() || !stack.func_77942_o()) {
            GuiNetworkHandler.openHeldItemGui((EntityPlayer)player, (EnumHand)hand, (int)0, (int)0, (int)0);
        } else {
            NBTTagCompound nbt = stack.func_77978_p();
            boolean enabled = nbt.func_74767_n("enabled");
            if (enabled) {
                this.updateState(nbt, 0);
            }
            nbt.func_74757_a("enabled", !enabled);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public String func_77653_i(ItemStack item) {
        return TooltipUtil.translate((String)(this.func_77667_c(item) + (item.func_77942_o() && item.func_77978_p().func_74767_n("enabled") ? ".name1" : ".name0")));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, World player, List<String> list, ITooltipFlag b) {
        super.func_77624_a(item, player, list, b);
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt != null) {
            list.add(String.format("#%d <- x%08X", nbt.func_74762_e("link"), nbt.func_74762_e("state")));
        }
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("state")) {
            nbt = nbt.func_74737_b();
            nbt.func_82580_o("state");
        }
        return nbt;
    }

    public void handlePlayerPacket(ItemStack stack, int slot, PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        this.updateState(ItemFluidUtil.createTag((ItemStack)stack), pkt.readInt());
    }

    private void updateState(NBTTagCompound nbt, int value) {
        if (value == nbt.func_74762_e("state")) {
            return;
        }
        nbt.func_74768_a("state", value);
        if (nbt.func_74762_e("link") == 0) {
            return;
        }
        Sender h = ItemRemoteControl.getSender(nbt);
        if (h == null) {
            h = new Sender(nbt);
        }
        if (!h.update) {
            h.update = true;
            h.state = value;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyEvent(InputEvent.KeyInputEvent e) {
        KeyState ks = (KeyState)this.keyStates.get((byte)Keyboard.getEventKey());
        if (ks == null || ks.down == Keyboard.getEventKeyState()) {
            return;
        }
        ks.down = !ks.down;
        ks.t = Keyboard.getEventNanoseconds() - ks.t;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void updateKeys(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        NonNullList inv = player.field_71071_by.field_70462_a;
        for (int i = 0; i < inv.size(); ++i) {
            NBTTagCompound nbt;
            ItemStack stack = (ItemStack)inv.get(i);
            if (stack.func_77973_b() != this || (nbt = stack.func_77978_p()) == null || !nbt.func_74767_n("enabled")) continue;
            this.updateKeys(nbt, i);
        }
        long dt = System.nanoTime() - this.lastTick;
        this.lastTick += dt;
        ObjectIterator it = this.keyStates.values().iterator();
        while (it.hasNext()) {
            KeyState ks = (KeyState)it.next();
            if (!ks.requested) {
                it.remove();
            } else {
                ks.t = ks.down ? (ks.t += dt) : 0L;
            }
            ks.requested = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateKeys(NBTTagCompound nbt, int slot) {
        byte[] keys = nbt.func_74770_j("keys");
        int newPressed = 0;
        for (int i = 0; i < keys.length; ++i) {
            byte k = keys[i];
            if (k == 0) continue;
            KeyState ks = (KeyState)this.keyStates.computeIfAbsent((Object)k, KeyState::new);
            ks.requested = true;
            if (!ks.down && ks.t <= 0L) continue;
            newPressed |= 1 << i;
        }
        if (newPressed == nbt.func_74762_e("state")) {
            return;
        }
        nbt.func_74768_a("state", newPressed);
        PacketBuffer pkt = SyncNetworkHandler.preparePacket((int)slot);
        pkt.writeInt(newPressed);
        SyncNetworkHandler.instance.sendToServer(pkt);
    }

    public AdvancedContainer getContainer(ItemStack stack, EntityPlayer player, int slot, int x, int y, int z) {
        return new StateInteractionHandler(slot).createContainer(player);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGuiScreen(ItemStack stack, EntityPlayer player, int slot, int x, int y, int z) {
        return new GuiRemoteKeybind(new StateInteractionHandler(slot), player);
    }

    private static Sender getSender(NBTTagCompound nbt) {
        Link l = Link.of((int)nbt.func_74762_e("link"));
        if (l == null) {
            return null;
        }
        Port p = l.source();
        if (p == null || !(p.owner instanceof Sender)) {
            return null;
        }
        return ((Sender)p.owner).refresh(nbt);
    }

    public static class StateInteractionHandler
    extends ItemInteractionHandler {
        public final byte[] keys = new byte[32];

        public StateInteractionHandler(int slot) {
            super((Item)Objects.remote, slot);
        }

        public void writeState(StateSyncServer state, AdvancedContainer cont) {
            state.buffer.writeBytes(this.getKeybinds(cont.player));
            state.endFixed();
        }

        public void readState(StateSyncClient state, AdvancedContainer cont) {
            state.get(this.keys);
        }

        protected void initSync(StateSynchronizer.Builder sb) {
            sb.addMulFix(1, 32);
        }

        public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
            short i = pkt.readUnsignedByte();
            if (i >= 32) {
                return;
            }
            this.getKeybinds((EntityPlayer)sender)[i] = pkt.readByte();
        }

        private byte[] getKeybinds(EntityPlayer player) {
            NBTTagCompound nbt = this.getNBT(player);
            byte[] arr = nbt.func_74770_j("keys");
            if (arr.length != 32) {
                arr = this.keys;
                nbt.func_74773_a("keys", this.keys);
            }
            return arr;
        }
    }

    public static class Sender
    implements IPortProvider,
    TickRegistry.ITickReceiver {
        private final Port port = new Port((IPortProvider)this, 0, SignalHandler.class, true);
        private WeakReference<NBTTagCompound> ref;
        private SignalHandler callback = SignalHandler.NOP;
        private int state;
        private boolean update;

        private Sender(NBTTagCompound nbt) {
            this.ref = new WeakReference<NBTTagCompound>(nbt);
            this.state = nbt.func_74762_e("state");
            TickRegistry.instance.add((TickRegistry.ITickReceiver)this);
            this.port.deserializeNBT(nbt);
            this.port.onLoad();
        }

        private Sender refresh(NBTTagCompound nbt) {
            if (this.ref.get() != nbt) {
                this.ref = new WeakReference<NBTTagCompound>(nbt);
            }
            return this;
        }

        public Port getPort(int pin) {
            return this.port;
        }

        public Object getPortCallback(int pin) {
            return this;
        }

        public void setPortCallback(int pin, Object callback) {
            this.callback = callback instanceof SignalHandler ? (SignalHandler)callback : SignalHandler.NOP;
            this.update = true;
        }

        public void onPortModified(Port port, int event) {
            NBTTagCompound nbt = (NBTTagCompound)this.ref.get();
            if (nbt == null) {
                return;
            }
            nbt.func_74768_a("link", port.getLink());
            if (event == 2) {
                this.ref.clear();
            }
        }

        public boolean tick() {
            NBTTagCompound nbt = (NBTTagCompound)this.ref.get();
            if (nbt == null) {
                this.port.onUnload();
                return false;
            }
            if (this.update) {
                this.callback.updateSignal(this.state);
                int s = nbt.func_74762_e("state");
                if (s == this.state) {
                    this.update = false;
                } else {
                    this.state = s;
                }
            }
            return true;
        }

        public void kill() {
            Link l = Link.of((int)this.port.getLink());
            if (l != null && l.sink() instanceof MountedPort) {
                ((MountedPort)l.sink()).setConnector(null, null);
            }
            this.port.disconnect();
            this.ref.clear();
        }
    }

    static class KeyState {
        boolean down;
        boolean requested;
        long t;

        KeyState(byte key) {
            this.down = Keyboard.isKeyDown((int)(key & 0xFF));
        }
    }
}

