/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.item;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.Connector;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.Gui.AdvancedContainer;
import cd4017be.lib.Gui.ItemInteractionHandler;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.IGuiComp;
import cd4017be.lib.Gui.comp.TextField;
import cd4017be.lib.network.GuiNetworkHandler;
import cd4017be.lib.network.IGuiHandlerItem;
import cd4017be.lib.network.StateSyncClient;
import cd4017be.lib.network.StateSyncServer;
import cd4017be.lib.network.StateSynchronizer;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.item.ItemPlug;
import cd4017be.rs_ctr.port.Constant;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemConstantPlug
extends ItemPlug
implements Connector.IConnectorItem,
IGuiHandlerItem {
    public ItemConstantPlug(String id) {
        super(id, SignalHandler.class, false);
    }

    @Override
    protected Connector create(MountedPort port, ItemStack stack, EntityPlayer player) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return null;
        }
        Constant c = new Constant(port);
        c.deserializeNBT(nbt);
        return c;
    }

    public String func_77653_i(ItemStack item) {
        String s = super.func_77653_i(item);
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt != null) {
            s = s + " \u00a79" + ItemConstantPlug.toString(nbt.func_74762_e("val"), nbt.func_74771_c("dsp"));
        }
        return s;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            GuiNetworkHandler.openHeldItemGui((EntityPlayer)player, (EnumHand)hand, (int)0, (int)0, (int)0);
        } else if (stack.func_77942_o()) {
            NBTTagCompound nbt = (stack = stack.func_77946_l()).func_77978_p();
            if (nbt.func_74762_e("val") == 0) {
                stack.func_77982_d(null);
            } else {
                nbt.func_74774_a("dsp", (byte)((nbt.func_74771_c("dsp") + 1) % 3));
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public AdvancedContainer getContainer(ItemStack stack, EntityPlayer player, int slot, int x, int y, int z) {
        return new StateInteractionHandler(slot).createContainer(player);
    }

    @SideOnly(value=Side.CLIENT)
    public ModularGui getGuiScreen(ItemStack stack, EntityPlayer player, int slot, int x, int y, int z) {
        StateInteractionHandler state = new StateInteractionHandler(slot);
        ModularGui gui = new ModularGui(state.createContainer(player));
        GuiFrame frame = new GuiFrame(gui, 80, 31, 1).title("gui.rs_ctr.constant.name", 0.5f).background(new ResourceLocation("rs_ctr", "textures/gui/small.png"), 0, 0);
        frame.add((IGuiComp)new TextField((GuiCompGroup)frame, 64, 7, 8, 16, 12, (Supplier)state, t -> {
            try {
                if (t.isEmpty()) {
                    return;
                }
                char c = (t = t.toLowerCase()).charAt(0);
                if (c == 'x') {
                    gui.sendPkt(new Object[]{Integer.parseInt(t.substring(1), 16), (byte)1});
                } else if (c == 'b') {
                    gui.sendPkt(new Object[]{Integer.parseInt(t.substring(1), 2), (byte)2});
                } else {
                    gui.sendPkt(new Object[]{Integer.parseInt(t), (byte)0});
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }));
        gui.compGroup = frame;
        return gui;
    }

    public static String toString(int value, byte dsp) {
        switch (dsp) {
            case 0: {
                return Integer.toString(value);
            }
            case 1: {
                return 'x' + Integer.toHexString(value);
            }
        }
        return 'b' + Integer.toBinaryString(value);
    }

    static class StateInteractionHandler
    extends ItemInteractionHandler
    implements Supplier<String> {
        int value;
        byte dsp;

        public StateInteractionHandler(int slot) {
            super((Item)Objects.constant, slot);
        }

        protected void initSync(StateSynchronizer.Builder sb) {
            sb.addFix(new int[]{4, 1});
        }

        public void writeState(StateSyncServer state, AdvancedContainer cont) {
            NBTTagCompound nbt = this.getNBT(cont.player);
            state.buffer.writeInt(nbt.func_74762_e("val")).writeByte((int)nbt.func_74771_c("dsp"));
            state.endFixed();
        }

        public void readState(StateSyncClient state, AdvancedContainer cont) {
            this.value = state.get(this.value);
            this.dsp = (byte)state.get((int)this.dsp);
        }

        public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
            NBTTagCompound nbt = this.getNBT((EntityPlayer)sender);
            nbt.func_74768_a("val", pkt.readInt());
            nbt.func_74774_a("dsp", pkt.readByte());
        }

        @Override
        public String get() {
            return ItemConstantPlug.toString(this.value, this.dsp);
        }
    }
}

