/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.gui;

import cd4017be.lib.Gui.comp.GuiCompBase;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.gui.CircuitEditor;
import cd4017be.rscpl.editor.Gate;
import cd4017be.rscpl.editor.InvalidSchematicException;
import java.util.Arrays;

public class GuiErrorMarker
extends GuiCompBase<GuiCompGroup> {
    private final CircuitEditor gui;
    public InvalidSchematicException lastErr;

    public GuiErrorMarker(CircuitEditor gui) {
        super(gui.compGroup, gui.compGroup.w, gui.compGroup.h, 0, 0);
        this.gui = gui;
    }

    public void update(int e) {
        if (e == 0) {
            this.lastErr = null;
            this.setEnabled(false);
        } else if (this.lastErr == null || this.lastErr.errcode != (e & 0xFF)) {
            this.lastErr = new InvalidSchematicException(e, this.gui.tile.schematic::get);
            if (this.lastErr.gate != null) {
                this.gui.board.selPart = this.lastErr.gate.getBounds();
                this.gui.changeSelPart();
            }
            this.setEnabled(true);
        }
    }

    public void drawOverlay(int mx, int my) {
        int py;
        int px;
        InvalidSchematicException lastErr = this.lastErr;
        if (lastErr == null) {
            return;
        }
        Gate node = lastErr.gate;
        switch (lastErr.errcode) {
            case 32: 
            case 34: {
                px = 182;
                py = 240;
                break;
            }
            case 33: {
                px = 220;
                py = 234 + lastErr.pin * 6;
                break;
            }
            case 2: 
            case 4: 
            case 64: {
                px = 211;
                py = 177;
                break;
            }
            case 7: {
                px = 211;
                py = 188;
                break;
            }
            case 5: 
            case 6: {
                if (node == null) {
                    return;
                }
                px = (node.rasterX << 2) + 14;
                py = (node.rasterY << 2) + 19;
                break;
            }
            case 65: {
                if (node == null) {
                    return;
                }
                px = (node.rasterX + node.type.width << 2) + 10;
                py = (node.rasterY << 2) + (node.type.height << 1) + 16;
                break;
            }
            case 1: 
            case 3: {
                if (node == null) {
                    return;
                }
                if (lastErr.pin < node.inputCount()) {
                    px = (node.rasterX << 2) + 10;
                    py = (node.rasterY + node.type.getInputHeight(lastErr.pin) << 2) + 18;
                    break;
                }
                px = (node.rasterX << 2) + 14;
                py = (node.rasterY << 2) + 19;
                break;
            }
            default: {
                return;
            }
        }
        this.gui.field_146297_k.field_71446_o.func_110577_a(this.parent.mainTex);
        this.gui.func_73729_b(this.x + px - 4, this.y + py - 8, 193, 0, 7, 8);
        this.parent.drawTooltip(Arrays.asList(TooltipUtil.getConfigFormat((String)("gui.rs_ctr.error" + lastErr.errcode)).split("\n")), this.x + px, this.y + py);
    }
}

