/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.circuit.editor;

import cd4017be.rs_ctr.circuit.editor.ASMCode;
import cd4017be.rs_ctr.circuit.editor.GeneratedGate;
import cd4017be.rs_ctr.circuit.editor.GeneratedType;
import cd4017be.rs_ctr.circuit.editor.LinkVar;
import cd4017be.rscpl.compile.Context;
import cd4017be.rscpl.compile.Dep;
import cd4017be.rscpl.compile.Node;
import cd4017be.rscpl.compile.NodeCompiler;
import it.unimi.dsi.fastutil.chars.CharArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class GeneratedNode
implements NodeCompiler {
    public final ASMCode code;
    public final LinkVar[] inputs;
    public final Type out;
    protected final int sort;
    private final boolean strictTypes;
    private final Predicate<GeneratedGate> precondition;
    private final Function<GeneratedGate, Object>[] arguments;
    public GeneratedNode next;

    public GeneratedNode(Type result, ASMCode code, List<LinkVar> inputs, int sort, boolean strict, Predicate<GeneratedGate> precond, List<Function<GeneratedGate, Object>> args) {
        this.out = result;
        this.inputs = inputs.toArray(new LinkVar[inputs.size()]);
        this.code = code;
        this.sort = sort;
        this.strictTypes = strict;
        this.precondition = precond;
        this.arguments = args.toArray(new Function[args.size()]);
    }

    public void translateVars(CharArrayList names, int nn, int ni) {
        for (LinkVar v : this.inputs) {
            v.name = (char)GeneratedType.lookup(names, v.name, nn, ni);
        }
        if (this.next != null) {
            this.next.translateVars(names, nn, ni);
        }
    }

    public Node createNode(GeneratedType type, GeneratedGate gate) {
        if (!this.precondition.test(gate)) {
            return null;
        }
        Node[] ins = new Node[this.inputs.length];
        for (int i = 0; i < ins.length; ++i) {
            LinkVar v = this.inputs[i];
            Node n = type.getNode(gate, v.name);
            if (n == null || !Dep.canConvert(n.code.getOutType(), v.type, this.strictTypes)) {
                return null;
            }
            ins[i] = n;
        }
        Object[] args = new Object[this.arguments.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.arguments[i].apply(gate);
        }
        return new Node((NodeCompiler)this, args, ins);
    }

    @Override
    public Type getInType(int i) {
        return this.inputs[i].type;
    }

    @Override
    public Type getOutType() {
        return this.out;
    }

    @Override
    public void compile(Dep[] inputs, Object param, MethodVisitor mv, Context context) {
        if (this.sort < inputs.length) {
            Arrays.sort(inputs, this.sort, inputs.length);
        }
        ASMCode.CompCont c = new ASMCode.CompCont(this.code, inputs, (Object[])param, context, null);
        for (ASMCode.Insn i : this.code.instructions) {
            i.visit(mv, c);
        }
        c.clear();
    }

    public static class Pass
    extends Bool {
        public Pass(Type result, List<LinkVar> inputs, int sort, boolean strict, Predicate<GeneratedGate> precond) {
            super(result, null, inputs, sort, strict, precond, Collections.emptyList());
            int n = result == Type.VOID_TYPE ? 0 : 1;
            for (LinkVar v : inputs) {
                if (v.type == Type.VOID_TYPE) continue;
                --n;
            }
            if (n < 0) {
                throw new IllegalStateException("too many non void inputs in empty node");
            }
        }

        @Override
        public void compile(Dep[] inputs, Object param, MethodVisitor mv, Context context, Label target, boolean cond) {
            if (this.sort < inputs.length) {
                Arrays.sort(inputs, this.sort, inputs.length);
            }
            for (Dep i : inputs) {
                if (i.type == Type.VOID_TYPE) {
                    i.compile(mv, context);
                    continue;
                }
                i.compile(mv, context, target, cond);
            }
        }

        @Override
        public void compile(Dep[] inputs, Object param, MethodVisitor mv, Context context) {
            if (this.sort < inputs.length) {
                Arrays.sort(inputs, this.sort, inputs.length);
            }
            for (Dep i : inputs) {
                i.compile(mv, context);
            }
        }
    }

    public static class Bool
    extends GeneratedNode
    implements NodeCompiler.Bool {
        public Bool(Type result, ASMCode code, List<LinkVar> inputs, int sort, boolean strict, Predicate<GeneratedGate> precond, List<Function<GeneratedGate, Object>> args) {
            super(result, code, inputs, sort, strict, precond, args);
        }

        @Override
        public void compile(Dep[] inputs, Object param, MethodVisitor mv, Context context, Label target, boolean cond) {
            if (this.sort < inputs.length) {
                Arrays.sort(inputs, this.sort, inputs.length);
            }
            ASMCode.CompCont c = new ASMCode.CompCont(this.code, inputs, (Object[])param, context, target);
            ASMCode code = this.code.extra;
            if (cond) {
                code = code.extra;
            }
            for (ASMCode.Insn i : code.instructions) {
                i.visit(mv, c);
            }
            c.clear();
        }
    }
}

