/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.circuit;

import cd4017be.lib.jvm_utils.SecurityChecker;
import cd4017be.rs_ctr.Main;
import cd4017be.rs_ctr.circuit.Circuit;
import cd4017be.rs_ctr.circuit.UtilFunc;
import cd4017be.rscpl.util.StateBuffer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CircuitLoader
extends ClassLoader {
    public static final CircuitLoader INSTANCE = new CircuitLoader();
    public static final SecurityChecker CHECKER = new SecurityChecker().putAll(Circuit.class).putAll(StateBuffer.class).putAll(String.class).putAll(Math.class).putAll(UtilFunc.class).putAll(Integer.class).putAll(Float.class).put(Object.class, new String[0]);
    private HashMap<String, Function<String, byte[]>> registry = new HashMap();

    private CircuitLoader() {
        super(CircuitLoader.class.getClassLoader());
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Function<String, byte[]> gen = this.registry.remove(name);
        if (gen == null) {
            throw new ClassNotFoundException(name);
        }
        byte[] data = gen.apply(name);
        if (data == null) {
            throw new ClassNotFoundException(name);
        }
        CHECKER.verify(data);
        return this.defineClass(name, data, 0, data.length);
    }

    public Circuit newCircuit(String name) {
        try {
            return (Circuit)Class.forName(name, true, this).newInstance();
        }
        catch (ClassNotFoundException | LinkageError | SecurityException e) {
            Main.LOG.error("failed to load circuit class", e);
            return null;
        }
        catch (IllegalAccessException | InstantiationException e) {
            Main.LOG.error("failed to initialize circuit instance", (Throwable)e);
            return null;
        }
    }

    public boolean register(String name, byte[] code) {
        Function<String, byte[]> gen;
        if (this.findLoadedClass(name) != null) {
            return true;
        }
        if (code != null) {
            gen = n -> code;
            File file = CircuitLoader.file(name);
            if (file != null && !file.exists()) {
                try {
                    FileOutputStream os = new FileOutputStream(file);
                    os.write(code);
                    os.close();
                }
                catch (IOException | SecurityException e) {
                    Main.LOG.error("Failed to save circuit class file", (Throwable)e);
                }
            }
        } else {
            gen = CircuitLoader::loadCircuitFile;
        }
        return this.registry.put(name, gen) != null;
    }

    private static byte[] loadCircuitFile(String name) {
        try {
            File file = CircuitLoader.file(name);
            if (file == null) {
                return null;
            }
            FileInputStream is = new FileInputStream(file);
            ByteBuf buff = Unpooled.buffer();
            while (buff.writeBytes((InputStream)is, 4096) == 4096) {
            }
            is.close();
            byte[] arr = new byte[buff.writerIndex()];
            buff.readBytes(arr);
            return arr;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static File file(String name) {
        FMLCommonHandler fml = FMLCommonHandler.instance();
        MinecraftServer server = fml.getMinecraftServerInstance();
        if (server == null) {
            return null;
        }
        File dir = new File(fml.getSavesDirectory(), server.func_71270_I() + "/circuits");
        dir.mkdir();
        return new File(dir, name.substring(2) + ".class");
    }
}

