/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr;

import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.api.rs_ctr.sensor.SensorRegistry;
import cd4017be.lib.BlockItemRegistry;
import cd4017be.lib.block.MultipartBlock;
import cd4017be.lib.render.SpecialModelLoader;
import cd4017be.lib.render.model.BlockMimicModel;
import cd4017be.lib.render.model.MultipartModel;
import cd4017be.rs_ctr.CommonProxy;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.block.BlockGate;
import cd4017be.rs_ctr.circuit.editor.CircuitInstructionSet;
import cd4017be.rs_ctr.port.WireType;
import cd4017be.rs_ctr.render.FrameRenderer;
import cd4017be.rs_ctr.render.PortRenderer;
import cd4017be.rs_ctr.render.SignalProbeRenderer;
import cd4017be.rs_ctr.sensor.BlockHardnessSensor;
import cd4017be.rs_ctr.sensor.DraconicFusionSensor;
import cd4017be.rs_ctr.sensor.FluidSensor;
import cd4017be.rs_ctr.sensor.ForgeEnergySensor;
import cd4017be.rs_ctr.sensor.GrowthSensor;
import cd4017be.rs_ctr.sensor.IC2EnergySensor;
import cd4017be.rs_ctr.sensor.ItemSensor;
import cd4017be.rs_ctr.sensor.LightSensor;
import cd4017be.rs_ctr.tileentity.BlockSelector;
import cd4017be.rs_ctr.tileentity.ChunkLoader;
import cd4017be.rs_ctr.tileentity.Gate;
import cd4017be.rscpl.gui.Category;
import cd4017be.rscpl.gui.GateTextureHandler;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    public static final ResourceLocation T_BLANK = new ResourceLocation("white");
    public static final ResourceLocation T_DIAL = new ResourceLocation("rs_ctr", "blocks/analog_dial");
    public static final ResourceLocation T_7SEG = new ResourceLocation("rs_ctr", "blocks/7seg");
    public static final ResourceLocation T_SOCKETS = new ResourceLocation("rs_ctr", "blocks/sockets");
    public static final ResourceLocation T_FRAME = new ResourceLocation("rs_ctr", "blocks/area");
    public static final ResourceLocation T_BEAM = new ResourceLocation("rs_ctr", "blocks/beam");
    public static final ResourceLocation T_OSC = new ResourceLocation("rs_ctr", "blocks/oscilloscope");
    public static TextureAtlasSprite t_blank;
    public static TextureAtlasSprite t_dial;
    public static TextureAtlasSprite t_7seg;
    public static TextureAtlasSprite t_sockets;
    public static TextureAtlasSprite t_frame;
    public static TextureAtlasSprite t_beam;
    public static TextureAtlasSprite t_osc;

    @Override
    public void preInit() {
        super.preInit();
        SensorRegistry.RENDERER = PortRenderer.PORT_RENDER;
    }

    @Override
    public void init(RecipeScriptContext.ConfigConstants cc) {
        super.init(cc);
        ClientRegistry.bindTileEntitySpecialRenderer(Gate.class, (TileEntitySpecialRenderer)PortRenderer.PORT_RENDER);
        ClientRegistry.bindTileEntitySpecialRenderer(BlockSelector.class, (TileEntitySpecialRenderer)FrameRenderer.FRAME_RENDER);
        ClientRegistry.bindTileEntitySpecialRenderer(ChunkLoader.class, (TileEntitySpecialRenderer)FrameRenderer.FRAME_RENDER);
        for (Category c : CircuitInstructionSet.TABS) {
            if (c == null) continue;
            GateTextureHandler.ins_sets.add(c);
        }
        GateTextureHandler.register();
    }

    @SubscribeEvent
    public void registerTextures(TextureStitchEvent.Pre event) {
        TextureMap map = event.getMap();
        if (!"textures".equals(map.getBasePath())) {
            return;
        }
        map.func_174942_a(T_DIAL);
        map.func_174942_a(T_7SEG);
        map.func_174942_a(T_SOCKETS);
        map.func_174942_a(T_FRAME);
        map.func_174942_a(T_BEAM);
        map.func_174942_a(T_OSC);
    }

    @SubscribeEvent
    public void getTextures(TextureStitchEvent.Post event) {
        TextureMap map = event.getMap();
        if (!"textures".equals(map.getBasePath())) {
            return;
        }
        t_blank = map.func_110572_b(T_BLANK.toString());
        t_dial = map.func_110572_b(T_DIAL.toString());
        t_7seg = map.func_110572_b(T_7SEG.toString());
        t_sockets = map.func_110572_b(T_SOCKETS.toString());
        t_frame = map.func_110572_b(T_FRAME.toString());
        t_beam = map.func_110572_b(T_BEAM.toString());
        t_osc = map.func_110572_b(T_OSC.toString());
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent ev) {
        SpecialModelLoader.setMod((String)"rs_ctr");
        SpecialModelLoader.registerBlockModel((Block)Objects.RS_PORT, (IModel)new MultipartModel((MultipartBlock)Objects.RS_PORT).setPipeVariants(1).setProvider(7, (MultipartModel.IModelProvider)PortRenderer.PORT_RENDER));
        SpecialModelLoader.overrideBlockModel((Block)Objects.WIRE_ANCHOR, (IModel)new MultipartModel((Block)Objects.WIRE_ANCHOR, Collections.singletonMap(Objects.WIRE_ANCHOR.func_176223_P(), new ModelResourceLocation(Objects.WIRE_ANCHOR.getRegistryName(), "empty")), true, new MultipartModel.IModelProvider[]{PortRenderer.PORT_RENDER, BlockMimicModel.provider}));
        ClientProxy.addGates(Objects.SPLITTER, Objects.ANALOG_COMB, Objects.LOGIC_COMB, Objects.NUM_COMB, Objects.BIN_COMB, Objects.BIN_SPLIT, Objects.XOR_GATE, Objects.COUNTER, Objects.DELAY, Objects.SPLITTER_B, Objects.MULTIPLEX_B, Objects.DELAY_B, Objects.PROCESSOR, Objects.PROCESSOR2, Objects.PROCESSOR3, Objects.COMPARATOR, Objects.POWER_HUB, Objects.ITEM_TRANSLOCATOR, Objects.FLUID_TRANSLOCATOR, Objects.ENERGY_VALVE, Objects.PANEL, Objects.SOLAR_CELL, Objects.BLOCK_SELECTOR, Objects.BLOCK_BREAKER, Objects.BLOCK_BREAKER1, Objects.ITEM_PLACER, Objects.OC_ADAPTER, Objects.RAM, Objects.CHUNK_LOADER, Objects.TELEPORTER, Objects.TELEPORTER1, Objects.BLOCK_DESERIALIZER, Objects.BLOCK_REORIENTER, Objects.INT_PANEL);
        Objects.WIRE_ANCHOR.setBlockLayer(null);
        PortRenderer.PORT_RENDER.register("_buttons.num(0)", "_buttons.num(1)");
        PortRenderer.PORT_RENDER.register("_buttons.logic(0)", "_buttons.logic(1)", "_buttons.logic(2)", "_buttons.logic(3)");
        PortRenderer.PORT_RENDER.register("_buttons.bin(0)", "_buttons.bin(1)", "_buttons.bin(2)", "_buttons.bin(3)");
        PortRenderer.PORT_RENDER.register("_buttons.energy(0)", "_buttons.energy(1)");
        for (WireType t : WireType.values()) {
            PortRenderer.PORT_RENDER.register(t.wireModel(), t.wirelessModel());
        }
        PortRenderer.PORT_RENDER.register("_plug.misc(0)", "_plug.misc(1)", "_plug.misc(2)", "_plug.misc(3)", "_plug.misc(4)");
        PortRenderer.PORT_RENDER.register("_hook.pin(1)", "_hook.pin(2)", "_hook.pin(3)");
        PortRenderer.PORT_RENDER.register("_battery");
        PortRenderer.PORT_RENDER.register("_lever.on", "_lever.off", "_lever.btn");
        PortRenderer.PORT_RENDER.dependencies.add(ItemSensor.MODEL);
        PortRenderer.PORT_RENDER.dependencies.add(FluidSensor.MODEL);
        PortRenderer.PORT_RENDER.dependencies.add(ForgeEnergySensor.MODEL);
        PortRenderer.PORT_RENDER.dependencies.add(BlockHardnessSensor.MODEL);
        PortRenderer.PORT_RENDER.dependencies.add(LightSensor.MODEL);
        PortRenderer.PORT_RENDER.dependencies.add(GrowthSensor.MODEL);
        if (HAS_IC2_API) {
            PortRenderer.PORT_RENDER.dependencies.add(IC2EnergySensor.MODEL);
        }
        if (Loader.isModLoaded((String)"draconicevolution")) {
            PortRenderer.PORT_RENDER.dependencies.add(DraconicFusionSensor.MODEL);
        }
        BlockItemRegistry.registerRender((Block)Objects.RS_PORT, (int)0, (int)3);
        BlockItemRegistry.registerRender((Block)Objects.WIRE_ANCHOR);
        BlockItemRegistry.registerRender((Block)Objects.EDITOR);
        BlockItemRegistry.registerRender((Block)Objects.ASSEMBLER);
        BlockItemRegistry.registerRender((Block)Objects.FRAME);
        BlockItemRegistry.registerRender((Item)Objects.wire);
        BlockItemRegistry.registerRender((Item)Objects.wire_e);
        BlockItemRegistry.registerRender((Item)Objects.split_s);
        BlockItemRegistry.registerRender((Item)Objects.split_b);
        BlockItemRegistry.registerRender((Item)Objects.wireless);
        BlockItemRegistry.registerRender((Item)Objects.wireless_b);
        BlockItemRegistry.registerRender((Item)Objects.constant);
        BlockItemRegistry.registerRender((Item)Objects.lamp);
        BlockItemRegistry.registerRender((Item)Objects.tag);
        BlockItemRegistry.registerRender((Item)Objects.block_wire);
        BlockItemRegistry.registerRender((Item)Objects.clock);
        BlockItemRegistry.registerRender((Item)Objects.wrench);
        BlockItemRegistry.registerRender((Item)Objects.seg7, (int)0, (int)3);
        BlockItemRegistry.registerRender((Item)Objects.pointer_dsp, (int)0, (int)3);
        BlockItemRegistry.registerRender((Item)Objects.slider);
        BlockItemRegistry.registerRender((Item)Objects.text, (int)1, (int)4);
        BlockItemRegistry.registerRender((Item)Objects.lever, (int)0, (int)2);
        BlockItemRegistry.registerRender((Item)Objects.trigger);
        BlockItemRegistry.registerRender((Item)Objects.scale);
        BlockItemRegistry.registerRender((Item)Objects.offset);
        BlockItemRegistry.registerRender((Item)Objects.oscilloscope, (int)0, (int)3);
        BlockItemRegistry.registerRender((Item)Objects.ram, null);
        BlockItemRegistry.registerRender((Item)Objects.edge_trigger, (int)0, (int)1);
        BlockItemRegistry.registerRender((Item)Objects.pulse_gen);
        BlockItemRegistry.registerRender((Item)Objects.cl_fuel);
        BlockItemRegistry.registerRender((Item)Objects.signal_probe);
        Objects.signal_probe.setTileEntityItemStackRenderer(new SignalProbeRenderer((Item)Objects.signal_probe));
        BlockItemRegistry.registerRender((Item)Objects.block_plug);
        BlockItemRegistry.registerRender((Item)Objects.remote);
        BlockItemRegistry.registerRender((Item)Objects.socket_s);
        BlockItemRegistry.registerRender((Item)Objects.socket_b);
    }

    private static void addGates(BlockGate ... gates) {
        DefaultStateMapper sm = new DefaultStateMapper();
        for (BlockGate gate : gates) {
            gate.setBlockLayer(null);
            SpecialModelLoader.overrideBlockModel((Block)gate, (IModel)new MultipartModel((Block)gate, sm.func_178130_a((Block)gate), true, new MultipartModel.IModelProvider[]{PortRenderer.PORT_RENDER, BlockMimicModel.provider}));
            BlockItemRegistry.registerRender((Block)gate);
        }
    }
}

