/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.integrations.replaymod;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.impl.ExtendedModule;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.MappingUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiScreen;
import unilib.external.io.github.classgraph.ClassInfo;

public class ReplayModUtils
implements ExtendedModule {
    private boolean enabled = false;
    private boolean isInUse = false;
    private boolean hasScannedInternals = false;
    private boolean hasInitialized = false;
    private boolean hasInitializedMain = false;
    private boolean hasInitializedSub = false;
    private String CURRENT_GUI_NAME;
    private Object CURRENT_SCREEN;

    @Override
    public void clearAttributes() {
        this.CURRENT_GUI_NAME = null;
        this.CURRENT_SCREEN = null;
        this.clearMainPlaceholders();
        this.clearSubPlaceholders();
        this.hasInitialized = false;
        this.hasInitializedMain = false;
        this.hasInitializedSub = false;
    }

    @Override
    public void updateData() {
        if (CraftPresence.GUIS.CURRENT_SCREEN == null) {
            this.clearClientData();
        } else {
            Class screenClass = FileUtils.loadClass((String[])new String[]{"com.replaymod.lib.de.johni0702.minecraft.gui.container.GuiScreen"});
            Class overlayClass = FileUtils.loadClass((String[])new String[]{"com.replaymod.lib.de.johni0702.minecraft.gui.container.GuiOverlay"});
            Object possibleScreen = StringUtils.executeMethod((Class)screenClass, null, (Class[])new Class[]{GuiScreen.class}, (Object[])new Object[]{CraftPresence.GUIS.CURRENT_SCREEN}, (String[])new String[]{"from"});
            Object possibleOverlay = StringUtils.executeMethod((Class)overlayClass, null, (Class[])new Class[]{GuiScreen.class}, (Object[])new Object[]{CraftPresence.GUIS.CURRENT_SCREEN}, (String[])new String[]{"from"});
            if (possibleScreen == null && possibleOverlay == null) {
                this.clearClientData();
            } else {
                Object newScreen = possibleOverlay != null ? possibleOverlay : possibleScreen;
                String newScreenName = MappingUtils.getClassName((Object)newScreen);
                if (!newScreen.equals(this.CURRENT_SCREEN) || !newScreenName.equals(this.CURRENT_GUI_NAME)) {
                    this.CURRENT_SCREEN = newScreen;
                    this.CURRENT_GUI_NAME = newScreenName;
                    if (!CraftPresence.GUIS.GUI_NAMES.contains(newScreenName)) {
                        CraftPresence.GUIS.GUI_NAMES.add(newScreenName);
                    }
                    if (!this.hasInitialized) {
                        this.initPresence();
                        this.hasInitialized = true;
                    }
                    this.updatePresence();
                }
                this.syncPlaceholders();
            }
        }
    }

    @Override
    public void getInternalData() {
        List searchClasses = StringUtils.newArrayList((Object[])new Class[]{FileUtils.findClass((String[])new String[]{"com.replaymod.lib.de.johni0702.minecraft.gui.container.AbstractGuiContainer"}), FileUtils.findClass((String[])new String[]{"com.replaymod.lib.de.johni0702.minecraft.gui.container.AbstractGuiScreen"}), FileUtils.findClass((String[])new String[]{"com.replaymod.lib.de.johni0702.minecraft.gui.container.AbstractGuiOverlay"})});
        for (ClassInfo classObj : FileUtils.getClassNamesMatchingSuperType((List)searchClasses, (String[])new String[0]).values()) {
            String screenName = MappingUtils.getClassName((ClassInfo)classObj);
            if (!CraftPresence.GUIS.GUI_NAMES.contains(screenName)) {
                CraftPresence.GUIS.GUI_NAMES.add(screenName);
            }
            if (CraftPresence.GUIS.GUI_CLASSES.containsKey(screenName)) continue;
            CraftPresence.GUIS.GUI_CLASSES.put(screenName, classObj);
        }
    }

    @Override
    public void getConfigData() {
    }

    @Override
    public void syncArgument(String argumentName, Supplier<Boolean> condition, Supplier<Object> event, boolean plain) {
        CraftPresence.CLIENT.syncArgument(argumentName, this.getModuleFunction(condition, event), plain);
    }

    @Override
    public ModuleData getData(String key) {
        return CraftPresence.GUIS.getData(key);
    }

    @Override
    public String getOverrideText(ModuleData data) {
        return CraftPresence.GUIS.getOverrideText(data);
    }

    @Override
    public boolean canFetchInternals() {
        return CraftPresence.GUIS.canFetchInternals();
    }

    @Override
    public boolean hasScannedInternals() {
        return this.hasScannedInternals;
    }

    @Override
    public void setScannedInternals(boolean state) {
        this.hasScannedInternals = state;
    }

    @Override
    public boolean canBeEnabled() {
        return CraftPresence.GUIS.canBeEnabled();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean canBeUsed() {
        return CraftPresence.GUIS.canBeUsed();
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }

    @Override
    public void initPresence() {
        this.syncArgument("screen.default.icon", () -> CraftPresence.CONFIG.advancedSettings.guiSettings.fallbackGuiIcon);
        this.syncArgument("data.screen.instance", () -> this.CURRENT_SCREEN);
        this.syncArgument("screen.name", () -> this.CURRENT_GUI_NAME, true);
        this.syncArgument("screen.message", () -> {
            ModuleData defaultData = this.getDefaultData();
            ModuleData currentData = this.getData(this.CURRENT_GUI_NAME);
            String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
            return this.getResult(Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : defaultMessage, this.CURRENT_GUI_NAME);
        });
        this.syncArgument("screen.icon", () -> {
            ModuleData defaultData = this.getDefaultData();
            ModuleData currentData = this.getData(this.CURRENT_GUI_NAME);
            String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : this.CURRENT_GUI_NAME;
            String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : defaultIcon;
            return this.getResult(CraftPresence.CLIENT.imageOf(true, currentIcon, CraftPresence.CONFIG.advancedSettings.guiSettings.fallbackGuiIcon), this.CURRENT_GUI_NAME);
        });
        CraftPresence.CLIENT.addForcedData("screen", () -> this.isInUse() ? this.getPresenceData(this.CURRENT_GUI_NAME) : null);
    }

    @Override
    public void updatePresence() {
    }

    private void clearMainPlaceholders() {
        CraftPresence.CLIENT.removeArguments("replaymod.time");
    }

    private void clearSubPlaceholders() {
        CraftPresence.CLIENT.removeArguments("replaymod.frames");
    }

    private void syncPlaceholders() {
        Class videoRendererScreen = FileUtils.loadClass((String[])new String[]{"com.replaymod.render.gui.GuiVideoRenderer"});
        if (this.CURRENT_SCREEN != null && this.CURRENT_SCREEN.getClass() == videoRendererScreen) {
            if (!this.hasInitializedMain) {
                this.syncArgument("replaymod.time.current", () -> this.secToString((Integer)StringUtils.getValidInteger((Object)StringUtils.getField((Class)videoRendererScreen, (Object)this.CURRENT_SCREEN, (String[])new String[]{"renderTimeTaken"})).getSecond() / 1000), true);
                this.syncArgument("replaymod.time.remaining", () -> this.secToString((Integer)StringUtils.getValidInteger((Object)StringUtils.getField((Class)videoRendererScreen, (Object)this.CURRENT_SCREEN, (String[])new String[]{"renderTimeLeft"})).getSecond() / 1000), true);
                this.hasInitializedMain = true;
            }
            Object rendererObj = StringUtils.getField((Class)videoRendererScreen, (Object)this.CURRENT_SCREEN, (String[])new String[]{"renderer"});
            Class videoRendererInfo = FileUtils.loadClass((String[])new String[]{"com.replaymod.render.rendering.VideoRenderer"});
            if (rendererObj != null && rendererObj.getClass() == videoRendererInfo) {
                if (!this.hasInitializedSub) {
                    this.syncArgument("replaymod.frames.current", () -> StringUtils.executeMethod((Class)videoRendererInfo, (Object)rendererObj, null, null, (String[])new String[]{"getFramesDone"}));
                    this.syncArgument("replaymod.frames.total", () -> StringUtils.executeMethod((Class)videoRendererInfo, (Object)rendererObj, null, null, (String[])new String[]{"getTotalFrames"}));
                    this.hasInitializedSub = true;
                }
            } else if (this.hasInitializedSub) {
                this.clearSubPlaceholders();
                this.hasInitializedSub = false;
            }
        } else if (this.hasInitializedMain) {
            this.clearMainPlaceholders();
            this.hasInitializedMain = false;
        }
    }

    private String secToString(int seconds) {
        int hours = seconds / 3600;
        int min = seconds / 60 - hours * 60;
        int sec = seconds - (min * 60 + hours * 60 * 60);
        StringBuilder builder = new StringBuilder();
        if (hours > 0) {
            builder.append(hours).append("hour(s)");
        }
        if (min > 0 || hours > 0) {
            builder.append(min).append("minute(s)");
        }
        builder.append(sec).append("second(s)");
        return builder.toString();
    }
}

