/*
 * Decompiled with CFR 0.152.
 */
package org.hjson;

import java.math.BigDecimal;
import org.hjson.JsonType;
import org.hjson.JsonValue;

class JsonNumber
extends JsonValue {
    private final double value;

    JsonNumber(double value) {
        this.value = value;
    }

    @Override
    public String toString() {
        long l = (long)this.value;
        if ((double)l == this.value) {
            return Long.toString(l);
        }
        String res = BigDecimal.valueOf(this.value).toEngineeringString();
        if (res.endsWith(".0")) {
            return res.substring(0, res.length() - 2);
        }
        if (res.contains("E")) {
            res = Double.toString(this.value);
            res = res.replace("E-", "e-").replace("E", "e+");
        }
        return res;
    }

    @Override
    public JsonType getType() {
        return JsonType.NUMBER;
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public int asInt() {
        return (int)this.value;
    }

    @Override
    public long asLong() {
        return (long)this.value;
    }

    @Override
    public float asFloat() {
        return (float)this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 59 + Double.valueOf(this.value).hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JsonNumber other = (JsonNumber)object;
        return this.value == other.value;
    }
}

