/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world.generator;

import com.personthecat.cavegenerator.data.ConditionSettings;
import com.personthecat.cavegenerator.data.DecoratorSettings;
import com.personthecat.cavegenerator.data.PondSettings;
import com.personthecat.cavegenerator.model.ConfiguredCaveBlock;
import com.personthecat.cavegenerator.model.ConfiguredPond;
import com.personthecat.cavegenerator.model.ConfiguredShell;
import com.personthecat.cavegenerator.model.ConfiguredWallDecorator;
import com.personthecat.cavegenerator.model.Decorators;
import com.personthecat.cavegenerator.util.PositionFlags;
import com.personthecat.cavegenerator.world.generator.BasicGenerator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public abstract class WorldCarver
extends BasicGenerator {
    protected final Decorators decorators;
    protected final int maxPondDepth;

    public WorldCarver(ConditionSettings conditions, DecoratorSettings decorators, World world) {
        super(conditions, world);
        this.decorators = Decorators.compile(decorators, world);
        this.maxPondDepth = WorldCarver.getMaxPondDepth(decorators.ponds);
    }

    private static int getMaxPondDepth(List<PondSettings> ponds) {
        int max = 0;
        for (PondSettings pond : ponds) {
            max = Math.max(pond.depth, max);
        }
        return max;
    }

    protected boolean hasWallDecorators() {
        return this.decorators.wallMap.containsAny;
    }

    protected boolean hasPonds() {
        return !this.decorators.ponds.isEmpty();
    }

    protected boolean hasShell() {
        return !this.decorators.shell.decorators.isEmpty();
    }

    protected void replaceBlock(Random rand, ChunkPrimer primer, int x, int y, int z, int chunkX, int chunkZ) {
        if (this.decorators.canReplace.test(primer.func_177856_a(x, y, z))) {
            for (ConfiguredCaveBlock block : this.decorators.caveBlocks) {
                if (!block.canGenerate(x, y, z, chunkX, chunkZ)) continue;
                for (IBlockState state : block.cfg.states) {
                    if (!((double)rand.nextFloat() <= block.cfg.integrity)) continue;
                    primer.func_177855_a(x, y, z, state);
                    return;
                }
            }
            primer.func_177855_a(x, y, z, BLK_AIR);
        }
    }

    protected void decorateAll(PositionFlags positions, Random rand, World world, ChunkPrimer primer, int cX, int cZ) {
        if (this.hasPonds()) {
            this.generatePond(positions, rand, world, primer, cX, cZ);
        }
        if (this.hasWallDecorators()) {
            this.generateWall(positions, rand, primer, cX, cZ);
        }
    }

    protected void generatePond(PositionFlags positions, Random rand, World world, ChunkPrimer primer, int cX, int cZ) {
        positions.forEach((x, y, z) -> this.evaluatePond(world, primer, rand, x, y, z, cX, cZ));
    }

    private void evaluatePond(World world, ChunkPrimer primer, Random rand, int x, int y, int z, int cX, int cZ) {
        int aX = cX * 16 + x;
        int aZ = cZ * 16 + x;
        IBlockState candidate = primer.func_177856_a(x, y - 1, z);
        if (Blocks.field_150350_a.equals(candidate.func_177230_c())) {
            return;
        }
        if (WorldCarver.anySolid(WorldCarver.getSurrounding(world, primer, x, y, z, aX, aZ))) {
            return;
        }
        if (WorldCarver.anyAir(WorldCarver.getSurrounding(world, primer, x, y - 1, z, aX, aZ))) {
            return;
        }
        int d = 1;
        for (ConfiguredPond pond : this.decorators.ponds) {
            if (pond.cfg.depth < d || !pond.canGenerate(rand, candidate, x, y, z, cX, cZ)) continue;
            d = WorldCarver.placeCountPond(pond, primer, rand, x, y, z);
        }
    }

    private static IBlockState[] getSurrounding(World world, ChunkPrimer primer, int x, int y, int z, int aX, int aZ) {
        return new IBlockState[]{x == 0 ? WorldCarver.getBlock(world, aX - 1, y, aZ) : primer.func_177856_a(x - 1, y, z), x == 15 ? WorldCarver.getBlock(world, aX + 1, y, aZ) : primer.func_177856_a(x + 1, y, z), z == 0 ? WorldCarver.getBlock(world, aX, y, aZ - 1) : primer.func_177856_a(x, y, z - 1), z == 15 ? WorldCarver.getBlock(world, aX, y, aZ + 1) : primer.func_177856_a(x, y, z + 1)};
    }

    private static IBlockState getBlock(World world, int aX, int y, int aZ) {
        BlockPos pos = new BlockPos(aX, y, aZ);
        if (world.func_175667_e(pos)) {
            return world.func_180495_p(pos);
        }
        return null;
    }

    private static boolean anySolid(IBlockState[] states) {
        for (IBlockState state : states) {
            if (state == null || !state.func_185904_a().func_76220_a()) continue;
            return true;
        }
        return false;
    }

    private static boolean anyAir(IBlockState[] states) {
        for (IBlockState state : states) {
            if (state == null || !Blocks.field_150350_a.equals(state.func_177230_c())) continue;
            return true;
        }
        return false;
    }

    private static int placeCountPond(ConfiguredPond pond, ChunkPrimer primer, Random rand, int x, int y, int z) {
        if (pond.cfg.integrity == 1.0 && pond.cfg.states.size() > 0) {
            IBlockState state = pond.cfg.states.get(0);
            for (int i = y - 1; i > y - pond.cfg.depth - 1; --i) {
                primer.func_177855_a(x, i, z, state);
            }
            return y - pond.cfg.depth;
        }
        int yO = y;
        for (int i = 1; i < pond.cfg.depth + 1; ++i) {
            yO = y - i;
            for (IBlockState state : pond.cfg.states) {
                if ((double)rand.nextFloat() <= pond.cfg.integrity) {
                    primer.func_177855_a(x, y, z, state);
                    continue;
                }
                return yO + 1;
            }
        }
        return yO;
    }

    protected void generateShell(Random rand, ChunkPrimer primer, int x, int y, int z, int cY, int chunkX, int chunkZ) {
        for (ConfiguredShell.Decorator shell : this.decorators.shell.decorators) {
            IBlockState candidate;
            if (!shell.cfg.height.contains(cY) || !shell.matches(candidate = primer.func_177856_a(x, y, z)) || !shell.testNoise(x, y, z, chunkX, chunkZ)) continue;
            for (IBlockState state : shell.cfg.states) {
                if (!((double)rand.nextFloat() <= shell.cfg.integrity)) continue;
                primer.func_177855_a(x, y, z, state);
                return;
            }
        }
    }

    protected void generateWall(PositionFlags positions, Random rand, ChunkPrimer primer, int cX, int cZ) {
        positions.forEach((x, y, z) -> this.decorateBlock(rand, primer, x, y, z, cX, cZ));
    }

    protected void decorateBlock(Random rand, ChunkPrimer primer, int x, int y, int z, int cX, int cZ) {
        if (!this.decorators.wallMap.containsAny) {
            return;
        }
        if (WorldCarver.decorateAll(this.decorators.wallMap.all, primer, rand, x, y, z, cX, cZ)) {
            return;
        }
        if (WorldCarver.decorateSide(this.decorators.wallMap.side, primer, rand, x, y, z, cX, cZ)) {
            return;
        }
        if (y > 0 && WorldCarver.decorate(this.decorators.wallMap.down, primer, rand, x, y, z, x, y - 1, z, cX, cZ)) {
            return;
        }
        if (y < 255 && WorldCarver.decorate(this.decorators.wallMap.up, primer, rand, x, y, z, x, y + 1, z, cX, cZ)) {
            return;
        }
        if (x > 0 && WorldCarver.decorate(this.decorators.wallMap.west, primer, rand, x, y, z, x - 1, y, z, cX, cZ)) {
            return;
        }
        if (x < 15 && WorldCarver.decorate(this.decorators.wallMap.east, primer, rand, x, y, z, x + 1, y, z, cX, cZ)) {
            return;
        }
        if (z > 0 && WorldCarver.decorate(this.decorators.wallMap.north, primer, rand, x, y, z, x, y, z - 1, cX, cZ)) {
            return;
        }
        if (z < 15) {
            WorldCarver.decorate(this.decorators.wallMap.south, primer, rand, x, y, z, x, y, z + 1, cX, cZ);
        }
    }

    private static boolean decorateAll(List<ConfiguredWallDecorator> all, ChunkPrimer primer, Random rand, int x, int y, int z, int cX, int cZ) {
        for (ConfiguredWallDecorator decorator : all) {
            if (!decorator.canGenerate(rand, x, y, z, cX, cZ)) continue;
            if (y > 0 && WorldCarver.checkPlaceWall(decorator, primer, rand, x, y, z, x, y - 1, z)) {
                return true;
            }
            if (y < 255 && WorldCarver.checkPlaceWall(decorator, primer, rand, x, y, z, x, y + 1, z)) {
                return true;
            }
            if (x > 0 && WorldCarver.checkPlaceWall(decorator, primer, rand, x, y, z, x - 1, y, z)) {
                return true;
            }
            if (x < 15 && WorldCarver.checkPlaceWall(decorator, primer, rand, x, y, z, x + 1, y, z)) {
                return true;
            }
            if (z > 0 && WorldCarver.checkPlaceWall(decorator, primer, rand, x, y, z, x, y, z - 1)) {
                return true;
            }
            if (z >= 15 || !WorldCarver.checkPlaceWall(decorator, primer, rand, x, y, z, x, y, z + 1)) continue;
            return true;
        }
        return false;
    }

    private static boolean decorateSide(List<ConfiguredWallDecorator> side, ChunkPrimer primer, Random rand, int x, int y, int z, int cX, int cZ) {
        for (ConfiguredWallDecorator decorator : side) {
            if (!decorator.canGenerate(rand, x, y, z, cX, cZ)) continue;
            if (x > 0 && WorldCarver.checkPlaceWall(decorator, primer, rand, x, y, z, x - 1, y, z)) {
                return true;
            }
            if (x < 15 && WorldCarver.checkPlaceWall(decorator, primer, rand, x, y, z, x + 1, y, z)) {
                return true;
            }
            if (z > 0 && WorldCarver.checkPlaceWall(decorator, primer, rand, x, y, z, x, y, z - 1)) {
                return true;
            }
            if (z >= 15 || !WorldCarver.checkPlaceWall(decorator, primer, rand, x, y, z, x, y, z + 1)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkPlaceWall(ConfiguredWallDecorator decorator, ChunkPrimer primer, Random rand, int x, int y, int z, int xO, int yO, int zO) {
        if (decorator.matchesBlock(primer.func_177856_a(xO, yO, zO))) {
            return WorldCarver.placeWall(decorator, primer, rand, x, y, z, xO, yO, zO);
        }
        return false;
    }

    private static boolean decorate(List<ConfiguredWallDecorator> decorators, ChunkPrimer primer, Random rand, int x, int y, int z, int xO, int yO, int zO, int cX, int cZ) {
        for (ConfiguredWallDecorator decorator : decorators) {
            IBlockState candidate;
            if (!decorator.canGenerate(rand, candidate = primer.func_177856_a(xO, yO, zO), x, y, z, cX, cZ) || !WorldCarver.placeWall(decorator, primer, rand, x, y, z, xO, yO, zO)) continue;
            return true;
        }
        return false;
    }

    private static boolean placeWall(ConfiguredWallDecorator decorator, ChunkPrimer primer, Random rand, int x, int y, int z, int xO, int yO, int zO) {
        for (IBlockState state : decorator.cfg.states) {
            if (!((double)rand.nextFloat() <= decorator.cfg.integrity) || !decorator.decidePlace(state, primer, x, y, z, xO, yO, zO)) continue;
            return true;
        }
        return false;
    }
}

