/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world.generator;

import com.personthecat.cavegenerator.data.TunnelSettings;
import com.personthecat.cavegenerator.model.PrimerData;
import com.personthecat.cavegenerator.util.XoRoShiRo;
import com.personthecat.cavegenerator.world.generator.MapGenerator;
import com.personthecat.cavegenerator.world.generator.TunnelGenerator;
import com.personthecat.cavegenerator.world.generator.TunnelPathInfo;
import com.personthecat.cavegenerator.world.generator.TunnelSocket;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class TunnelConnector<Socket extends TunnelSocket>
extends TunnelGenerator {
    private final Socket parent;

    public TunnelConnector(TunnelSettings tunnelCfg, Socket parent, World world) {
        super(tunnelCfg, world);
        this.parent = parent;
    }

    @Override
    protected void mapGenerate(MapGenerator.MapGenerationContext ctx) {
        this.bury(ctx.heightmap, ctx.world, ctx.rand.nextLong(), ctx.destChunkX, ctx.destChunkZ, ctx.chunkX, ctx.chunkZ, ctx.primer);
    }

    protected void bury(int[][] heightmap, World world, long seed, int destX, int destZ, int x, int z, ChunkPrimer primer) {
        XoRoShiRo rand = new XoRoShiRo(seed);
        int frequency = this.getTunnelCount(rand);
        for (int i = 0; i < frequency; ++i) {
            int distance = this.cfg.distance;
            PrimerData data = new PrimerData(primer, x, z);
            for (int j = 0; j < this.getBranchCount(rand); ++j) {
                TunnelPathInfo path = new TunnelPathInfo(this.cfg, (Random)rand, destX, destZ);
                int y = this.parent.getTunnelHeight(heightmap, rand, (int)path.getX(), (int)path.getZ(), x, z);
                if (y == Integer.MIN_VALUE) continue;
                path.setY(y);
                this.addTunnel(world, ((Random)rand).nextLong(), data, path, 0, distance);
            }
        }
    }
}

