/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world.generator;

import com.personthecat.cavegenerator.config.ConfigFile;
import com.personthecat.cavegenerator.data.ConditionSettings;
import com.personthecat.cavegenerator.data.DecoratorSettings;
import com.personthecat.cavegenerator.model.ConfiguredCaveBlock;
import com.personthecat.cavegenerator.model.PrimerData;
import com.personthecat.cavegenerator.util.PositionFlags;
import com.personthecat.cavegenerator.util.XoRoShiRo;
import com.personthecat.cavegenerator.world.BiomeSearch;
import com.personthecat.cavegenerator.world.generator.PrimerContext;
import com.personthecat.cavegenerator.world.generator.SphereData;
import com.personthecat.cavegenerator.world.generator.WorldCarver;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public abstract class MapGenerator
extends WorldCarver {
    private static final IBlockState BLK_WATER = Blocks.field_150355_j.func_176223_P();
    private static final int WATER_WIGGLE_ROOM = 7;
    protected final List<BlockPos> invalidChunks = new ArrayList<BlockPos>(BiomeSearch.size());
    private final SphereData sphere = new SphereData();
    protected final Random rand = new XoRoShiRo(0L);
    private final boolean testWater;

    public MapGenerator(ConditionSettings conditions, DecoratorSettings decorators, World world, boolean testWater) {
        super(conditions, decorators, world);
        this.testWater = testWater;
    }

    @Override
    public final void generate(PrimerContext ctx) {
        if (this.conditions.dimensions.test(ctx.world.field_73011_w.getDimension())) {
            if (this.conditions.hasBiomes) {
                if (ctx.biomes.anyMatches(this.conditions.biomes)) {
                    this.fillInvalidChunks(ctx.biomes);
                    this.generateChecked(ctx);
                    this.invalidChunks.clear();
                }
            } else if (this.conditions.hasRegion) {
                if (this.conditions.region.GetBoolean(ctx.offsetX, ctx.offsetZ)) {
                    this.fillInvalidChunks(ctx.chunkX, ctx.chunkZ);
                    this.generateChecked(ctx);
                    this.invalidChunks.clear();
                }
            } else {
                this.generateChecked(ctx);
            }
        }
    }

    private void fillInvalidChunks(BiomeSearch biomes) {
        for (BiomeSearch.Data d : biomes.surrounding.get()) {
            if (this.conditions.biomes.test(d.biome) && this.conditions.region.GetBoolean(d.centerX, d.centerZ)) continue;
            this.invalidChunks.add(new BlockPos(d.centerX, 0, d.centerZ));
        }
    }

    private void fillInvalidChunks(int chunkX, int chunkZ) {
        int range = ConfigFile.biomeRange;
        for (int cX = chunkX - range; cX <= chunkX + range; ++cX) {
            for (int cZ = chunkZ - range; cZ < chunkZ + range; ++cZ) {
                int centerX = cX * 16 + 8;
                int centerZ = cZ * 16 + 8;
                if (this.conditions.region.GetBoolean(centerX, centerZ)) continue;
                this.invalidChunks.add(new BlockPos(centerX, 0, centerZ));
            }
        }
    }

    @Override
    protected final void generateChecked(PrimerContext ctx) {
        int range = ConfigFile.mapRange;
        this.rand.setSeed(ctx.world.func_72905_C());
        long xMask = this.rand.nextLong();
        long zMask = this.rand.nextLong();
        for (int destX = ctx.chunkX - range; destX <= ctx.chunkX + range; ++destX) {
            for (int destZ = ctx.chunkZ - range; destZ <= ctx.chunkZ + range; ++destZ) {
                long xHash = (long)destX * xMask;
                long zHash = (long)destZ * zMask;
                this.rand.setSeed(xHash ^ zHash ^ ctx.world.func_72905_C());
                this.mapGenerate(new MapGenerationContext(ctx, this.rand, destX, destZ));
            }
        }
    }

    protected abstract void mapGenerate(MapGenerationContext var1);

    protected double getNearestBorder(int x, int z) {
        double shortestDistance = Double.MAX_VALUE;
        for (BlockPos invalid : this.invalidChunks) {
            double sum = Math.pow(x - invalid.func_177958_n(), 2.0) + Math.pow(z - invalid.func_177952_p(), 2.0);
            double distance = Math.sqrt(sum);
            shortestDistance = Math.min(distance, shortestDistance);
        }
        return shortestDistance;
    }

    protected final void generateSphere(PrimerData data, World world, Random rand, double x, double y, double z, double rXZ, double rY, double roXZ, double roY) {
        int miX = MapGenerator.limitXZ(MathHelper.func_76128_c((double)(x - roXZ)) - data.absX - 1);
        int maX = MapGenerator.limitXZ(MathHelper.func_76128_c((double)(x + roXZ)) - data.absX + 1);
        int miY = MapGenerator.limitY(MathHelper.func_76128_c((double)(y - roY)) - 1);
        int maY = MapGenerator.limitY(MathHelper.func_76128_c((double)(y + roY)) + 1);
        int miZ = MapGenerator.limitXZ(MathHelper.func_76128_c((double)(z - roXZ)) - data.absZ - 1);
        int maZ = MapGenerator.limitXZ(MathHelper.func_76128_c((double)(z + roXZ)) - data.absZ + 1);
        this.sphere.reset();
        this.sphere.grow(maX - miX, maY - miY, maZ - miZ);
        if (roXZ - rXZ != 0.0 && rand.nextInt(this.decorators.shell.cfg.sphereResolution) == 0) {
            this.fillDouble(this.sphere, x, y, z, data.absX, data.absZ, rXZ, rY, roXZ, roY, miX, maX, miY, maY, miZ, maZ);
        } else {
            this.fillSphere(this.sphere, x, y, z, data.absX, data.absZ, rXZ, rY, miX, maX, miY, maY, miZ, maZ);
        }
        if (!this.shouldTestForWater(miY, maY) || !this.testForWater(data.p, this.sphere.inner)) {
            this.generateShell(data, rand, this.sphere.shell, (int)y);
            this.replaceSphere(data, rand, this.sphere.inner);
            this.decorateAll(this.sphere.inner, rand, world, data.p, data.chunkX, data.chunkZ);
        }
    }

    private static int limitXZ(int xz) {
        return xz < 0 ? 0 : Math.min(xz, 16);
    }

    private static int limitY(int y) {
        return y < 1 ? 1 : Math.min(y, 248);
    }

    protected abstract void fillSphere(SphereData var1, double var2, double var4, double var6, int var8, int var9, double var10, double var12, int var14, int var15, int var16, int var17, int var18, int var19);

    protected abstract void fillDouble(SphereData var1, double var2, double var4, double var6, int var8, int var9, double var10, double var12, double var14, double var16, int var18, int var19, int var20, int var21, int var22, int var23);

    protected int getDistance(Random rand, int input) {
        if (input <= 0) {
            return 112 - rand.nextInt(28);
        }
        return input;
    }

    private boolean shouldTestForWater(int miY, int maY) {
        if (!this.testWater) {
            return false;
        }
        for (ConfiguredCaveBlock block : this.decorators.caveBlocks) {
            if (!block.cfg.states.contains(BLK_WATER) || maY > block.cfg.height.max + 7 || miY < block.cfg.height.min - 7) continue;
            return false;
        }
        return true;
    }

    protected boolean testForWater(ChunkPrimer primer, PositionFlags sphere) {
        return sphere.anyMatches((x, y, z) -> primer.func_177856_a(x, y, z).equals(BLK_WATER));
    }

    protected void generateShell(PrimerData data, Random rand, PositionFlags sphere, int cY) {
        sphere.forEach((x, y, z) -> this.generateShell(rand, data.p, x, y, z, cY, data.chunkX, data.chunkZ));
    }

    protected void replaceSphere(PrimerData data, Random rand, PositionFlags sphere) {
        sphere.forEach((x, y, z) -> this.replaceBlock(rand, data.p, x, y, z, data.chunkX, data.chunkZ));
    }

    protected void decorateSphere(PrimerData data, Random rand, PositionFlags sphere) {
        sphere.forEach((x, y, z) -> this.decorateBlock(rand, data.p, x, y, z, data.chunkX, data.chunkZ));
    }

    protected static class MapGenerationContext {
        protected final int[][] heightmap;
        protected final World world;
        protected final Random rand;
        protected final int destChunkX;
        protected final int destChunkZ;
        protected final int chunkX;
        protected final int chunkZ;
        protected final int offsetX;
        protected final int offsetZ;
        protected final ChunkPrimer primer;

        private MapGenerationContext(PrimerContext ctx, Random rand, int destChunkX, int destChunkZ) {
            this.heightmap = ctx.heightmap;
            this.world = ctx.world;
            this.rand = rand;
            this.destChunkX = destChunkX;
            this.destChunkZ = destChunkZ;
            this.chunkX = ctx.chunkX;
            this.chunkZ = ctx.chunkZ;
            this.offsetX = ctx.offsetX;
            this.offsetZ = ctx.offsetZ;
            this.primer = ctx.primer;
        }
    }
}

