/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world.generator;

import com.personthecat.cavegenerator.config.ConfigFile;
import com.personthecat.cavegenerator.data.BurrowSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.util.PositionFlags;
import com.personthecat.cavegenerator.world.BiomeSearch;
import com.personthecat.cavegenerator.world.generator.PrimerContext;
import com.personthecat.cavegenerator.world.generator.TunnelSocket;
import com.personthecat.cavegenerator.world.generator.WorldCarver;
import fastnoise.FastNoise;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class BurrowGenerator
extends WorldCarver
implements TunnelSocket {
    private final List<BlockPos> invalidChunks = new ArrayList<BlockPos>(BiomeSearch.size());
    private final FastNoise map;
    private final FastNoise offset;
    protected final BurrowSettings cfg;
    private final PositionFlags caverns;
    private final double mid;
    private final double midShelled;
    private final double radiusShelled;

    public BurrowGenerator(BurrowSettings cfg, World world) {
        super(cfg.conditions, cfg.decorators, world);
        this.map = cfg.map.getGenerator(world);
        this.offset = cfg.offset.getGenerator(world);
        this.cfg = cfg;
        this.caverns = new PositionFlags((int)(256.0 * ((double)cfg.radius + cfg.decorators.shell.radius) * (double)cfg.stretch * 2.0) + 1);
        this.mid = (double)cfg.radius / Math.pow(cfg.target, cfg.exponent);
        this.radiusShelled = (double)cfg.radius + cfg.decorators.shell.radius;
        double ratio = this.radiusShelled / (double)cfg.radius;
        this.midShelled = this.radiusShelled / Math.pow((double)cfg.target * ratio, cfg.exponent);
    }

    @Override
    public void generate(PrimerContext ctx) {
        if (this.conditions.dimensions.test(ctx.world.field_73011_w.getDimension())) {
            if (this.conditions.hasBiomes) {
                if (ctx.biomes.anyMatches(this.conditions.biomes)) {
                    this.fillInvalidChunks(ctx.biomes);
                    this.generateChecked(ctx);
                    this.invalidChunks.clear();
                }
            } else if (this.conditions.hasRegion) {
                if (this.conditions.region.GetBoolean(ctx.offsetX, ctx.offsetZ)) {
                    this.fillInvalidChunks(ctx.chunkX, ctx.chunkZ);
                    this.generateChecked(ctx);
                    this.invalidChunks.clear();
                }
            } else {
                this.generateChecked(ctx);
            }
            this.caverns.reset();
        }
    }

    private void fillInvalidChunks(BiomeSearch biomes) {
        for (BiomeSearch.Data d : biomes.surrounding.get()) {
            if (this.conditions.biomes.test(d.biome) && this.conditions.region.GetBoolean(d.centerX, d.centerZ)) continue;
            this.invalidChunks.add(new BlockPos(d.centerX, 0, d.centerZ));
        }
    }

    private void fillInvalidChunks(int chunkX, int chunkZ) {
        int range = ConfigFile.biomeRange;
        for (int cX = chunkX - range; cX <= chunkX + range; ++cX) {
            for (int cZ = chunkZ - range; cZ < chunkZ + range; ++cZ) {
                int centerX = cX * 16 + 8;
                int centerZ = cZ * 16 + 8;
                if (this.conditions.region.GetBoolean(centerX, centerZ)) continue;
                this.invalidChunks.add(new BlockPos(centerX, 0, centerZ));
            }
        }
    }

    @Override
    protected void generateChecked(PrimerContext ctx) {
        boolean storePositions;
        boolean bl = storePositions = this.hasWallDecorators() || this.hasPonds();
        if (this.hasShell()) {
            this.generateShelled(ctx, storePositions ? this::replaceRecord : this::replaceOnly);
        } else {
            this.generateUnShelled(ctx, storePositions ? this::replaceRecord : this::replaceOnly);
        }
        this.decorateAll(this.caverns, ctx.localRand, ctx.world, ctx.primer, ctx.chunkX, ctx.chunkZ);
    }

    private void generateShelled(PrimerContext ctx, GenerationFunction f) {
        for (int x = 0; x < 16; ++x) {
            int actualX = ctx.chunkX * 16 + x;
            for (int z = 0; z < 16; ++z) {
                Range height;
                int centerY;
                int actualZ = ctx.chunkZ * 16 + z;
                double distance = this.getNearestBorder(actualX, actualZ);
                double value = this.map.GetNoise(actualX, actualZ);
                double shifted = (double)this.cfg.shift + value;
                int cap = (int)((double)this.cfg.stretch * ((double)this.cfg.radius - Math.pow(shifted, this.cfg.exponent) * this.mid));
                int shell = (int)((double)this.cfg.stretch * (this.radiusShelled - Math.pow(shifted, this.cfg.exponent) * this.midShelled));
                if (cap > 0) {
                    centerY = (int)this.offset.GetAdjustedNoise(actualX, actualZ);
                    height = this.conditions.getColumn(ctx.heightmap, actualX, actualZ);
                    int min = Math.max(centerY - cap, height.min);
                    int max = Math.min(centerY + cap, height.max);
                    int minShell = Math.max(0, Math.max(centerY - shell, height.min));
                    int maxShell = Math.min(255, Math.min(centerY + shell, height.max));
                    this.coverOuter(ctx, distance, x, z, minShell, min, centerY);
                    this.coverOuter(ctx, distance, x, z, max, maxShell, centerY);
                    for (int y = min; y < max + 1; ++y) {
                        double curve = distance - this.getBiomeCurve(centerY - y);
                        if (curve > (double)this.cfg.wallDistance) {
                            f.generate(ctx, x, y, z);
                            continue;
                        }
                        if (!(curve > (double)this.cfg.wallDistance - this.decorators.shell.radius)) continue;
                        this.generateShell(ctx.localRand, ctx.primer, x, y, z, centerY, ctx.chunkX, ctx.chunkZ);
                    }
                    continue;
                }
                if (shell <= 0) continue;
                centerY = (int)this.offset.GetAdjustedNoise(actualX, actualZ);
                height = this.conditions.getColumn(ctx.heightmap, actualX, actualZ);
                int minShell = Math.max(0, Math.max(centerY - shell, height.min));
                int maxShell = Math.min(255, Math.min(centerY + shell, height.max));
                this.coverOuter(ctx, distance, x, z, minShell, maxShell, centerY);
            }
        }
    }

    private void coverOuter(PrimerContext ctx, double distance, int x, int z, int min, int max, int centerY) {
        for (int y = min; y < max + 1; ++y) {
            double curve = distance - this.getBiomeCurve(centerY - y);
            if (!(curve > (double)this.cfg.wallDistance - this.decorators.shell.radius)) continue;
            this.generateShell(ctx.localRand, ctx.primer, x, y, z, centerY, ctx.chunkX, ctx.chunkZ);
        }
    }

    private void generateUnShelled(PrimerContext ctx, GenerationFunction f) {
        for (int x = 0; x < 16; ++x) {
            int actualX = ctx.chunkX * 16 + x;
            for (int z = 0; z < 16; ++z) {
                int actualZ = ctx.chunkZ * 16 + z;
                double distance = this.getNearestBorder(actualX, actualZ);
                double value = this.map.GetNoise(actualX, actualZ);
                double shifted = (double)this.cfg.shift + value;
                int cap = (int)((double)this.cfg.stretch * ((double)this.cfg.radius - Math.pow(shifted, this.cfg.exponent) * this.mid));
                if (cap <= 0) continue;
                int centerY = (int)this.offset.GetAdjustedNoise(actualX, actualZ);
                Range height = this.conditions.getColumn(ctx.heightmap, actualX, actualZ);
                int min = Math.max(centerY - cap, height.min);
                int max = Math.min(centerY + cap, height.max);
                for (int y = min; y < max + 1; ++y) {
                    double curve = distance - this.getBiomeCurve(centerY - y);
                    if (!(curve > (double)this.cfg.wallDistance)) continue;
                    f.generate(ctx, x, y, z);
                }
            }
        }
    }

    private double getBiomeCurve(double relY) {
        double curve = Math.pow(relY, this.cfg.wallExponent) / (double)this.cfg.radius;
        return Math.min((double)this.cfg.radius * 2.0, curve);
    }

    private void replaceOnly(PrimerContext ctx, int x, int y, int z) {
        this.replaceBlock(ctx.localRand, ctx.primer, x, y, z, ctx.chunkX, ctx.chunkZ);
    }

    private void replaceRecord(PrimerContext ctx, int x, int y, int z) {
        this.replaceOnly(ctx, x, y, z);
        this.caverns.add(x, y, z);
    }

    private double getNearestBorder(int x, int z) {
        double shortestDistance = Double.MAX_VALUE;
        for (BlockPos pos : this.invalidChunks) {
            double sum = Math.pow(x - pos.func_177958_n(), 2.0) + Math.pow(z - pos.func_177952_p(), 2.0);
            double distance = Math.sqrt(sum);
            shortestDistance = Math.min(distance, shortestDistance);
        }
        return shortestDistance;
    }

    private void decorateCaverns(Random rand, ChunkPrimer primer, int chunkX, int chunkZ) {
        this.caverns.forEach((x, y, z) -> this.decorateBlock(rand, primer, x, y, z, chunkX, chunkZ));
    }

    @Override
    public int getTunnelHeight(int[][] heightmap, Random rand, int x, int z, int chunkX, int chunkZ) {
        double value = this.map.GetNoise(x, z);
        double shifted = (double)this.cfg.shift + value;
        int cap = (int)((double)this.cfg.stretch * ((double)this.cfg.radius - Math.pow(shifted, this.cfg.exponent) * this.mid));
        if (cap > 0) {
            int y = (int)this.offset.GetAdjustedNoise(x, z);
            if (this.conditions.getColumn(x, z).contains(y) && this.conditions.noise.GetBoolean(x, y, z)) {
                return y;
            }
        }
        return Integer.MIN_VALUE;
    }

    @FunctionalInterface
    private static interface GenerationFunction {
        public void generate(PrimerContext var1, int var2, int var3, int var4);
    }
}

