/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world.feature;

import com.personthecat.cavegenerator.data.StructureSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.world.feature.FeatureGenerator;
import com.personthecat.cavegenerator.world.feature.StructureSpawner;
import com.personthecat.cavegenerator.world.feature.WorldContext;
import java.util.Optional;
import java.util.Random;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureGenerator
extends FeatureGenerator {
    private static final Logger log = LogManager.getLogger(StructureGenerator.class);
    private final StructureSettings cfg;
    private final Template structure;

    public StructureGenerator(StructureSettings cfg, World world) {
        super(cfg.conditions, world);
        this.cfg = cfg;
        this.structure = StructureSpawner.getTemplate(cfg.name, world);
    }

    @Override
    protected void doGenerate(WorldContext ctx) {
        BlockPos center = new BlockPos(ctx.offsetX, 0, ctx.offsetZ);
        if (this.conditions.biomes.test(ctx.world.getBiomeForCoordsBody(center))) {
            for (int i = 0; i < this.cfg.count; ++i) {
                if (!(ctx.rand.nextDouble() <= (double)this.cfg.chance)) continue;
                this.generateSingle(ctx);
            }
        }
    }

    private void generateSingle(WorldContext ctx) {
        Optional<BlockPos> spawnPos = this.getSpawnPos(ctx).filter(pos -> this.conditions.noise.GetBoolean(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        spawnPos.ifPresent(pos -> {
            if (this.allChecksPass((BlockPos)pos, ctx.world)) {
                this.preStructureSpawn(ctx, (BlockPos)pos);
                BlockPos adjusted = StructureGenerator.offset(StructureGenerator.centerBySize(pos, this.structure.func_186259_a()), this.cfg.offset);
                StructureSpawner.spawnStructure(this.structure, this.cfg.placement, ctx.world, adjusted);
            }
        });
    }

    private boolean allChecksPass(BlockPos pos, World world) {
        return this.checkSources(this.cfg.matchers, world, pos) && this.checkNonSolid(this.cfg.nonSolidChecks, world, pos) && this.checkSolid(this.cfg.solidChecks, world, pos) && this.checkAir(this.cfg.airChecks, world, pos) && this.checkWater(this.cfg.waterChecks, world, pos) && this.checkBlocks(this.cfg.blockChecks, world, pos);
    }

    private Optional<BlockPos> getSpawnPos(WorldContext info) {
        Optional<BlockPos> vertical;
        if ((this.cfg.directions.up || this.cfg.directions.down) && (vertical = this.getSpawnPosVertical(info, this.structure)).isPresent()) {
            return vertical;
        }
        if (this.cfg.directions.side) {
            return this.getSpawnPosHorizontal(info, this.structure);
        }
        Optional<Object> side = CommonMethods.empty();
        if (this.cfg.directions.north) {
            side = this.getSpawnPosN(info, this.structure);
        }
        if (this.cfg.directions.south && !side.isPresent()) {
            side = this.getSpawnPosS(info, this.structure);
        }
        if (this.cfg.directions.east && !side.isPresent()) {
            side = this.getSpawnPosE(info, this.structure);
        }
        if (this.cfg.directions.west && !side.isPresent()) {
            side = this.getSpawnPosW(info, this.structure);
        }
        return side;
    }

    private Optional<BlockPos> getSpawnPosVertical(WorldContext info, Template structure) {
        for (int i = 0; i < 3; ++i) {
            int y;
            BlockPos xz = this.randCoords(info.rand, structure.func_186259_a(), info.offsetX, info.offsetZ);
            int x = xz.func_177958_n();
            int z = xz.func_177952_p();
            Range height = this.conditions.getColumn(x, z);
            int minY = height.min;
            int maxY = this.cfg.checkSurface ? Math.min(info.heightmap[x & 0xF][z & 0xF] - 5, height.max) : info.world.func_72940_L();
            if (minY >= maxY || !this.conditions.region.GetBoolean(x, z) || (y = this.cfg.directions.up && this.cfg.directions.down ? this.findOpeningVertical(info.rand, info.world, x, z, minY, maxY) : (this.cfg.directions.up ? this.randFindCeiling(info.world, info.rand, x, z, minY, maxY) : this.randFindFloor(info.world, info.rand, x, z, minY, maxY))) == Integer.MIN_VALUE) continue;
            return CommonMethods.full(new BlockPos(x, y, z));
        }
        return CommonMethods.empty();
    }

    private Optional<BlockPos> getSpawnPosHorizontal(WorldContext info, Template structure) {
        BlockPos size = structure.func_186259_a();
        Range height = this.conditions.getColumn(info.offsetX, info.offsetZ);
        if (height.diff() != 0 && this.conditions.region.GetBoolean(info.offsetX, info.offsetZ)) {
            for (int i = 0; i < 20; ++i) {
                int y = height.rand(info.rand);
                Optional<BlockPos> pos = info.rand.nextBoolean() ? this.randCoordsNS(info, size.func_177958_n(), y) : this.randCoordsEW(info, size.func_177952_p(), y);
                if (!pos.isPresent()) continue;
                return pos;
            }
        }
        return CommonMethods.empty();
    }

    private Optional<BlockPos> getSpawnPosN(WorldContext info, Template structure) {
        BlockPos size = structure.func_186259_a();
        Range height = this.conditions.getColumn(info.offsetX, info.offsetZ);
        if (height.diff() != 0 && this.conditions.region.GetBoolean(info.offsetX, info.offsetZ)) {
            for (int i = 0; i < 20; ++i) {
                int y = height.rand(info.rand);
                Optional<BlockPos> pos = this.randCoordsN(info, size.func_177958_n(), y);
                if (!pos.isPresent()) continue;
                return pos;
            }
        }
        return CommonMethods.empty();
    }

    private Optional<BlockPos> getSpawnPosS(WorldContext info, Template structure) {
        BlockPos size = structure.func_186259_a();
        Range height = this.conditions.getColumn(info.offsetX, info.offsetZ);
        if (height.diff() != 0 && this.conditions.region.GetBoolean(info.offsetX, info.offsetZ)) {
            for (int i = 0; i < 20; ++i) {
                int y = height.rand(info.rand);
                Optional<BlockPos> pos = this.randCoordsS(info, size.func_177958_n(), y);
                if (!pos.isPresent()) continue;
                return pos;
            }
        }
        return CommonMethods.empty();
    }

    private Optional<BlockPos> getSpawnPosE(WorldContext info, Template structure) {
        BlockPos size = structure.func_186259_a();
        Range height = this.conditions.getColumn(info.offsetX, info.offsetZ);
        if (height.diff() != 0 && this.conditions.region.GetBoolean(info.offsetX, info.offsetZ)) {
            for (int i = 0; i < 20; ++i) {
                int y = height.rand(info.rand);
                Optional<BlockPos> pos = this.randCoordsE(info, size.func_177952_p(), y);
                if (!pos.isPresent()) continue;
                return pos;
            }
        }
        return CommonMethods.empty();
    }

    private Optional<BlockPos> getSpawnPosW(WorldContext info, Template structure) {
        BlockPos size = structure.func_186259_a();
        Range height = this.conditions.getColumn(info.offsetX, info.offsetZ);
        if (height.diff() != 0 && this.conditions.region.GetBoolean(info.offsetX, info.offsetZ)) {
            for (int i = 0; i < 20; ++i) {
                int y = height.rand(info.rand);
                Optional<BlockPos> pos = this.randCoordsW(info, size.func_177952_p(), y);
                if (!pos.isPresent()) continue;
                return pos;
            }
        }
        return CommonMethods.empty();
    }

    private int randCoord(Random rand, int size, int offset) {
        if ((size = Math.abs(size)) < 16) {
            if (size % 2 == 0) {
                ++size;
            }
            return StructureGenerator.cornerInsideChunkBounds(rand, size) + offset;
        }
        return offset + 8;
    }

    private BlockPos randCoords(Random rand, BlockPos size, int offsetX, int offsetZ) {
        int x = this.randCoord(rand, size.func_177958_n(), offsetX);
        int z = this.randCoord(rand, size.func_177952_p(), offsetZ);
        return new BlockPos(x, 0, z);
    }

    private Optional<BlockPos> randCoordsNS(WorldContext info, int sizeX, int y) {
        int z;
        int x = StructureGenerator.cornerInsideChunkBounds(info.rand, sizeX) + info.offsetX;
        int n = z = info.rand.nextBoolean() ? this.findOpeningNorth(info.world, x, y, info.offsetZ) : this.findOpeningSouth(info.world, x, y, info.offsetZ);
        if (z != Integer.MIN_VALUE && y < info.heightmap[x & 0xF][z & 0xF]) {
            return CommonMethods.full(new BlockPos(x, y, z));
        }
        return CommonMethods.empty();
    }

    private Optional<BlockPos> randCoordsEW(WorldContext info, int sizeZ, int y) {
        int x;
        int z = StructureGenerator.cornerInsideChunkBounds(info.rand, sizeZ) + info.offsetZ;
        int n = x = info.rand.nextBoolean() ? this.findOpeningEast(info.world, y, z, info.offsetX) : this.findOpeningWest(info.world, y, z, info.offsetX);
        if (x != Integer.MIN_VALUE && y < info.heightmap[x & 0xF][z & 0xF]) {
            return CommonMethods.full(new BlockPos(x, y, z));
        }
        return CommonMethods.empty();
    }

    private Optional<BlockPos> randCoordsN(WorldContext info, int sizeX, int y) {
        int x = StructureGenerator.cornerInsideChunkBounds(info.rand, sizeX) + info.offsetX;
        int z = this.findOpeningNorth(info.world, x, y, info.offsetZ);
        if (z != Integer.MIN_VALUE && y < info.heightmap[x & 0xF][z & 0xF]) {
            return CommonMethods.full(new BlockPos(x, y, z));
        }
        return CommonMethods.empty();
    }

    private Optional<BlockPos> randCoordsS(WorldContext info, int sizeX, int y) {
        int x = StructureGenerator.cornerInsideChunkBounds(info.rand, sizeX) + info.offsetX;
        int z = this.findOpeningSouth(info.world, x, y, info.offsetZ);
        if (z != Integer.MIN_VALUE && y < info.heightmap[x & 0xF][z & 0xF]) {
            return CommonMethods.full(new BlockPos(x, y, z));
        }
        return CommonMethods.empty();
    }

    private Optional<BlockPos> randCoordsE(WorldContext info, int sizeZ, int y) {
        int z = StructureGenerator.cornerInsideChunkBounds(info.rand, sizeZ) + info.offsetZ;
        int x = this.findOpeningEast(info.world, y, z, info.offsetX);
        if (x != Integer.MIN_VALUE && y < info.heightmap[x & 0xF][z & 0xF]) {
            return CommonMethods.full(new BlockPos(x, y, z));
        }
        return CommonMethods.empty();
    }

    private Optional<BlockPos> randCoordsW(WorldContext info, int sizeZ, int y) {
        int z = StructureGenerator.cornerInsideChunkBounds(info.rand, sizeZ) + info.offsetZ;
        int x = this.findOpeningWest(info.world, y, z, info.offsetX);
        if (x != Integer.MIN_VALUE && y < info.heightmap[x & 0xF][z & 0xF]) {
            return CommonMethods.full(new BlockPos(x, y, z));
        }
        return CommonMethods.empty();
    }

    private static BlockPos centerBySize(BlockPos toCenter, BlockPos size) {
        int xOffset = size.func_177958_n() / 2 * -1;
        int zOffset = size.func_177952_p() / 2 * -1;
        return toCenter.func_177982_a(xOffset, 0, zOffset);
    }

    private static BlockPos offset(BlockPos original, BlockPos offset) {
        return original.func_177982_a(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
    }

    private void preStructureSpawn(WorldContext info, BlockPos pos) {
        if (this.cfg.rotateRandomly) {
            Rotation randRotation = Rotation.values()[info.rand.nextInt(3)];
            this.cfg.placement.func_186220_a(randRotation);
        }
        if (this.cfg.debugSpawns) {
            log.info("Spawning {} at {}", (Object)this.cfg.name, (Object)pos);
        }
        if (!this.cfg.command.isEmpty()) {
            MinecraftServer server = info.world.func_73046_m();
            String interpolated = this.cfg.command.replace("{x}", String.valueOf(pos.func_177958_n())).replace("{y}", String.valueOf(pos.func_177956_o())).replace("{z}", String.valueOf(pos.func_177952_p()));
            server.field_71321_q.func_71556_a((ICommandSender)server, interpolated);
        }
    }

    private static int cornerInsideChunkBounds(Random rand, int size) {
        int min = size / 2;
        return rand.nextInt(16 - min) + min;
    }
}

