/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world.feature;

import com.personthecat.cavegenerator.data.ConditionSettings;
import com.personthecat.cavegenerator.model.BlockCheck;
import com.personthecat.cavegenerator.model.Conditions;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.world.feature.WorldContext;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class FeatureGenerator {
    protected static final int VERTICAL_RETRIES = 3;
    protected static final int HORIZONTAL_RETRIES = 20;
    protected static final int NONE_FOUND = Integer.MIN_VALUE;
    protected static final int SURFACE_ROOM = 5;
    protected final Conditions conditions;
    protected final WeakReference<World> world;

    public FeatureGenerator(ConditionSettings conditions, World world) {
        Objects.requireNonNull(world, "Nullable world types are not yet supported.");
        this.conditions = Conditions.compile(conditions, world);
        this.world = new WeakReference<World>(world);
    }

    protected final World getWorld() {
        return (World)Objects.requireNonNull(this.world.get(), "World reference has been culled.");
    }

    public final void generate(WorldContext ctx) {
        int dim = ctx.world.field_73011_w.getDimension();
        if (this.conditions.dimensions.test(dim)) {
            this.doGenerate(ctx);
        }
    }

    protected abstract void doGenerate(WorldContext var1);

    protected final boolean isSolid(World world, int x, int y, int z) {
        return this.isSolid(world, new BlockPos(x, y, z));
    }

    protected final boolean isSolid(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185914_p();
    }

    protected final int findFloor(World world, int x, int y, int z, int minY) {
        boolean previouslySolid = this.isSolid(world, x, y, z);
        for (int h = y - 1; h > minY; --h) {
            boolean currentlySolid = this.isSolid(world, x, h, z);
            if (!previouslySolid && currentlySolid) {
                return h;
            }
            previouslySolid = currentlySolid;
        }
        return Integer.MIN_VALUE;
    }

    protected final int findCeiling(World world, int x, int y, int z, int maxY) {
        boolean previouslySolid = this.isSolid(world, x, y, z);
        for (int h = y + 1; h < maxY; ++h) {
            boolean currentlySolid = this.isSolid(world, x, h, z);
            if (!previouslySolid && currentlySolid) {
                return h;
            }
            previouslySolid = currentlySolid;
        }
        return Integer.MIN_VALUE;
    }

    protected final int randFindFloor(World world, Random rand, int x, int z, int minY, int maxY) {
        int startY = CommonMethods.numBetween(rand, minY, maxY);
        int y = this.findFloor(world, x, startY, z, minY);
        if (y == Integer.MIN_VALUE) {
            y = this.findFloor(world, x, maxY, z, startY);
        }
        return y;
    }

    protected final int randFindCeiling(World world, Random rand, int x, int z, int minY, int maxY) {
        int startY = CommonMethods.numBetween(rand, minY, maxY);
        int y = this.findCeiling(world, x, startY, z, maxY);
        if (y == Integer.MIN_VALUE) {
            y = this.findCeiling(world, x, minY, z, startY);
        }
        return y;
    }

    protected final int findOpeningVertical(Random rand, World world, int x, int z, int minY, int maxY) {
        int startY = CommonMethods.numBetween(rand, minY, maxY);
        if (rand.nextBoolean()) {
            int fromCenter = this.findOpeningFromBelow(world, x, startY, z, maxY);
            if (fromCenter != Integer.MIN_VALUE) {
                return fromCenter;
            }
            return this.findOpeningFromBelow(world, x, minY, z, startY);
        }
        int fromCenter = this.findOpeningFromAbove(world, x, startY, z, minY);
        if (fromCenter != Integer.MIN_VALUE) {
            return fromCenter;
        }
        return this.findOpeningFromAbove(world, x, maxY, z, startY);
    }

    protected final int findOpeningFromBelow(World world, int x, int y, int z, int maxY) {
        boolean previouslySolid = this.isSolid(world, x, y, z);
        for (int h = y; h < maxY; ++h) {
            boolean currentlySolid = this.isSolid(world, x, h, z);
            if (previouslySolid ^ currentlySolid) {
                return currentlySolid ? h : h - 1;
            }
            previouslySolid = currentlySolid;
        }
        return Integer.MIN_VALUE;
    }

    protected final int findOpeningFromAbove(World world, int x, int y, int z, int minY) {
        boolean previouslySolid = this.isSolid(world, x, y, z);
        for (int h = y; h > minY; --h) {
            boolean currentlySolid = this.isSolid(world, x, h, z);
            if (previouslySolid ^ currentlySolid) {
                return currentlySolid ? h : h + 1;
            }
            previouslySolid = currentlySolid;
        }
        return Integer.MIN_VALUE;
    }

    protected final int findOpeningNorth(World world, int x, int y, int offsetZ) {
        boolean previouslySolid = this.isSolid(world, x, y, offsetZ + 15);
        for (int z = offsetZ + 14; z >= offsetZ; --z) {
            boolean currentlySolid = this.isSolid(world, x, y, z);
            if (previouslySolid ^ currentlySolid) {
                return z;
            }
            previouslySolid = currentlySolid;
        }
        return Integer.MIN_VALUE;
    }

    protected final int findOpeningSouth(World world, int x, int y, int offsetZ) {
        boolean previouslySolid = this.isSolid(world, x, y, offsetZ);
        for (int z = offsetZ + 1; z < offsetZ + 16; ++z) {
            boolean currentlySolid = this.isSolid(world, x, y, z);
            if (previouslySolid ^ currentlySolid) {
                return z;
            }
            previouslySolid = currentlySolid;
        }
        return Integer.MIN_VALUE;
    }

    protected final int findOpeningEast(World world, int y, int z, int offsetX) {
        boolean previouslySolid = this.isSolid(world, offsetX, y, z);
        for (int x = offsetX + 1; x < offsetX + 16; ++x) {
            boolean currentlySolid = this.isSolid(world, x, y, z);
            if (previouslySolid ^ currentlySolid) {
                return x;
            }
            previouslySolid = currentlySolid;
        }
        return Integer.MIN_VALUE;
    }

    protected final int findOpeningWest(World world, int y, int z, int offsetX) {
        boolean previouslySolid = this.isSolid(world, offsetX + 15, y, z);
        for (int x = offsetX + 14; x >= offsetX; --x) {
            boolean currentlySolid = this.isSolid(world, x, y, z);
            if (previouslySolid ^ currentlySolid) {
                return x;
            }
            previouslySolid = currentlySolid;
        }
        return Integer.MIN_VALUE;
    }

    protected final boolean checkSources(List<IBlockState> matchers, World world, BlockPos pos) {
        if (matchers.isEmpty()) {
            return true;
        }
        return matchers.contains(world.func_180495_p(pos));
    }

    protected final boolean checkNonSolid(List<BlockPos> relative, World world, BlockPos origin) {
        for (BlockPos p : relative) {
            if (!this.isSolid(world, origin.func_177982_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p()))) continue;
            return false;
        }
        return true;
    }

    protected final boolean checkSolid(List<BlockPos> relative, World world, BlockPos origin) {
        for (BlockPos p : relative) {
            if (this.isSolid(world, origin.func_177982_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p()))) continue;
            return false;
        }
        return true;
    }

    protected final boolean checkAir(List<BlockPos> relative, World world, BlockPos origin) {
        for (BlockPos p : relative) {
            if (world.func_180495_p(origin.func_177982_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p())).equals(Blocks.field_150350_a.func_176223_P())) continue;
            return false;
        }
        return true;
    }

    protected final boolean checkWater(List<BlockPos> relative, World world, BlockPos origin) {
        for (BlockPos p : relative) {
            if (world.func_180495_p(origin.func_177982_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p())).equals(Blocks.field_150355_j.func_176223_P())) continue;
            return false;
        }
        return true;
    }

    protected final boolean checkBlocks(List<BlockCheck> checks, World world, BlockPos origin) {
        for (BlockCheck c : checks) {
            for (BlockPos p : c.positions) {
                IBlockState state = world.func_180495_p(origin.func_177982_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p()));
                if (c.matchers.contains(state)) continue;
                return false;
            }
        }
        return true;
    }
}

