/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.util;

import it.unimi.dsi.fastutil.HashCommon;

public class SplitMixRandom {
    private static final long PHI = -7046029254386353131L;
    private long x;

    public SplitMixRandom(long seed) {
        this.setSeed(seed);
    }

    private static long staffordMix13(long z) {
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return z ^ z >>> 31;
    }

    private static int staffordMix4Upper32(long z) {
        z = (z ^ z >>> 33) * 7109453100751455733L;
        return (int)((z ^ z >>> 28) * -3808689974395783757L >>> 32);
    }

    public long nextLong() {
        return SplitMixRandom.staffordMix13(this.x += -7046029254386353131L);
    }

    public int nextInt() {
        return SplitMixRandom.staffordMix4Upper32(this.x += -7046029254386353131L);
    }

    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    public long nextLong(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("illegal bound " + n + " (must be positive)");
        }
        long t = SplitMixRandom.staffordMix13(this.x += -7046029254386353131L);
        long nMinus1 = n - 1L;
        if ((n & nMinus1) == 0L) {
            return t & nMinus1;
        }
        long u = t >>> 1;
        while (u + nMinus1 - (t = u % n) < 0L) {
            u = SplitMixRandom.staffordMix13(this.x += -7046029254386353131L) >>> 1;
        }
        return t;
    }

    public void setSeed(long seed) {
        this.x = HashCommon.murmurHash3((long)seed);
    }

    public void setState(long state) {
        this.x = state;
    }
}

